/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.ModuleExtension;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsLoader
implements CommandEncoder {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionsLoader.class);
    public static final String COMMAND_PREFIX = "EXT\t";
    public static final String SPECIFY_DIR_IN_PREFS = "specifyExtensionDirInPrefs";
    public static final String EXTENSION_DIR = "extensionDIR";
    protected Set<String> loadedExtensions = new HashSet<String>();
    protected Map<String, String> loadedIds = new HashMap<String, String>();
    protected ExtensionsManager extMgr;
    protected ExtensionsManager globalExtMgr;

    public void addTo(GameModule mod) {
        this.extMgr = new ExtensionsManager(mod);
        this.globalExtMgr = new ExtensionsManager("ext");
        mod.addCommandEncoder(this);
        if ("true".equals(GlobalOptions.getInstance().getAttributeValueString(SPECIFY_DIR_IN_PREFS))) {
            DirectoryConfigurer config = new DirectoryConfigurer(EXTENSION_DIR, Resources.getString("ExtensionsLoader.extensions_directory"));
            config.setValue((Object)null);
            GameModule.getGameModule().getPrefs().addOption(Resources.getString("ExtensionsLoader.extensions_tab"), config);
            this.extMgr.setExtensionsDirectory(config.getFileValue());
            if (config.getFileValue() == null) {
                config.setValue(this.extMgr.getExtensionsDirectory(false).getAbsoluteFile());
            }
            config.addPropertyChangeListener(evt -> {
                this.extMgr.setExtensionsDirectory((File)evt.getNewValue());
                this.addExtensions();
            });
        }
        this.addExtensions();
    }

    protected void addExtensions() {
        for (File ext : this.globalExtMgr.getActiveExtensions()) {
            if (this.addExtension(ext)) continue;
            this.globalExtMgr.setActive(ext, false);
        }
        for (File ext : this.extMgr.getActiveExtensions()) {
            if (this.addExtension(ext)) continue;
            GameModule.getGameModule().warn(Resources.getString("ExtensionsLoader.deactivating_extension", ext.getName()));
            this.extMgr.setActive(ext, false);
        }
    }

    protected boolean addExtension(File extension) {
        logger.info("Loading extension " + extension);
        String extname = extension.getPath();
        boolean success = this.loadedExtensions.contains(extname);
        if (!success) {
            try {
                ModuleExtension ext = this.createExtension(extname);
                ext.build();
                String id = ext.getExtensionId();
                String idMsg = "";
                if (id.length() > 0) {
                    for (String loadedId : this.loadedIds.keySet()) {
                        if (!loadedId.equals(id)) continue;
                        idMsg = Resources.getString("ExtensionsLoader.id_conflict", extension.getName(), id, this.loadedIds.get(id));
                    }
                    this.loadedIds.put(id, extname);
                }
                String msg = this.getLoadedMessage(ext.getName(), ext.getVersion());
                this.loadedExtensions.add(extname);
                GameModule.getGameModule().warn(msg);
                logger.info(msg);
                if (idMsg.length() > 0) {
                    GameModule.getGameModule().warn(idMsg);
                    logger.info(idMsg);
                }
                success = true;
            }
            catch (ZipException ext) {
            }
            catch (LoadExtensionException | IOException e) {
                this.reportBuildError(e, extension.getName());
            }
        }
        return success;
    }

    protected ModuleExtension createExtension(String extname) throws ZipException, IOException {
        return new ModuleExtension(new DataArchive(extname));
    }

    protected String getLoadedMessage(String name, String version) {
        return Resources.getString("ExtensionsLoader.extension_loaded", name, version);
    }

    private void reportBuildError(Exception e, String name) {
        String msg = e.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = e.getClass().getName();
            msg = msg.substring(msg.lastIndexOf(46));
        }
        GameModule.getGameModule().warn(this.getErrorMessage(name, msg));
    }

    protected String getErrorMessage(String name, String msg) {
        return Resources.getString("ExtensionsLoader.unable_to_load", name, msg);
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command.substring(COMMAND_PREFIX.length()), '\t');
        return new ModuleExtension.RegCmd(st.nextToken(), st.nextToken());
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof ModuleExtension.RegCmd)) {
            return null;
        }
        ModuleExtension.RegCmd cmd = (ModuleExtension.RegCmd)c;
        SequenceEncoder se = new SequenceEncoder('\t');
        se.append(cmd.getName()).append(cmd.getVersion());
        return COMMAND_PREFIX + se.getValue();
    }

    public static class LoadExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public LoadExtensionException() {
        }

        public LoadExtensionException(String message, Throwable cause) {
            super(message, cause);
        }

        public LoadExtensionException(String message) {
            super(message);
        }

        public LoadExtensionException(Throwable cause) {
            super(cause);
        }
    }
}

