/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.preferences.PositionOption;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.IconButton;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;

public class Inventory
extends AbstractToolbarItem
implements GameComponent,
PlayerRoster.SideChangeListener {
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    public static final String REFRESH_HOTKEY = "refreshHotkey";
    protected NamedKeyStrokeListener refreshListener;
    protected CounterInventory results;
    protected JTree tree;
    public static final String VERSION = "2.1";
    protected String mapSeparator = "\n";
    protected String groupSeparator = "   ";
    public static final String FILTER = "include";
    protected PropertyExpression piecePropertiesFilter = new PropertyExpression();
    public static final String GROUP_BY = "groupBy";
    protected String[] groupBy = new String[]{""};
    public static final String NON_LEAF_FORMAT = "nonLeafFormat";
    protected String nonLeafFormat = "$PropertyValue$";
    public static final String CENTERONPIECE = "centerOnPiece";
    protected boolean centerOnPiece = true;
    public static final String FORWARD_KEYSTROKE = "forwardKeystroke";
    protected boolean forwardKeystroke = true;
    public static final String SHOW_MENU = "showMenu";
    protected boolean showMenu = true;
    public static final String SIDES = "sides";
    protected String[] sides = null;
    public static final String KEYSTROKE = "keystroke";
    protected KeyStroke keyStroke = null;
    public static final String CUTBELOWROOT = "cutRoot";
    protected int cutBelowRoot = 0;
    public static final String CUTABOVELEAVES = "cutLeaves";
    protected int cutAboveLeaves = 0;
    public static final String LEAF_FORMAT = "leafFormat";
    protected String pieceFormat = "$PieceName$";
    public static final String PIECE_ZOOM = "pieceZoom";
    protected double pieceZoom = 0.25;
    public static final String ZOOM_2 = "pieceZoom2";
    protected double pieceZoom2 = 0.33;
    public static final String ZOOM_3 = "pieceZoom3";
    protected double pieceZoom3 = 0.4;
    public static final String DRAW_PIECES = "drawPieces";
    protected boolean drawPieces = true;
    public static final String FOLDERS_ONLY = "foldersOnly";
    protected boolean foldersOnly = false;
    public static final String SORT_PIECES = "sortPieces";
    protected boolean sortPieces = true;
    public static final String SORT_FORMAT = "sortFormat";
    protected String sortFormat = "$PieceName$";
    public static final String ALPHA = "alpha";
    public static final String LENGTHALPHA = "length";
    public static final String NUMERIC = "numeric";
    public static final String[] SORT_OPTIONS = new String[]{"alpha", "length", "numeric"};
    public static final String LAUNCH_FUNCTION = "launchFunction";
    public static final String FUNCTION_REFRESH = "functionRefresh";
    public static final String FUNCTION_HIDE = "functionHide";
    public static final String[] FUNCTION_OPTIONS = new String[]{"functionRefresh", "functionHide"};
    public static final String[] FUNCTION_KEYS = new String[]{"Editor.Inventory.function_refresh", "Editor.Inventory.function_hide"};
    protected String launchFunction = "functionHide";
    protected String sortStrategy = "alpha";
    public static final String SORTING = "sorting";
    public static final String BUTTON_FUNCTION = "buttonFunction";
    protected JDialog frame;
    public static final String ZOOM_ON = "zoomOn";
    protected boolean zoomShow = false;
    protected int zoomLevel = 0;
    private JButton zoomPlusButton;
    private JButton zoomMinusButton;
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    private final VisibilityCondition piecesVisible = () -> !this.foldersOnly;

    public Inventory() {
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Inventory.show_inventory"), Resources.getString("Inventory.inventory"), "/images/inventory.gif", e -> this.launch()));
        this.launch = this.getLaunchButton();
        this.refreshListener = new NamedKeyStrokeListener(e -> this.refresh());
        GameModule.getGameModule().addKeyStrokeListener(this.refreshListener);
        this.getLaunchButton().setEnabled(false);
        this.getLaunchButton().setVisible(false);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Inventory.component_type");
    }

    @Override
    public void addTo(Buildable b) {
        super.addTo(b);
        GameModule.getGameModule().addSideChangeListenerToPlayerRoster(this);
        this.getLaunchButton().setAlignmentY(0.0f);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.frame = new JDialog(GameModule.getGameModule().getPlayerWindow());
        this.frame.setTitle(this.getConfigureName());
        String key = "Inventory." + this.getConfigureName();
        GameModule.getGameModule().getPrefs().addOption(new PositionOption(key, this.frame));
        this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.add(this.initTree());
        this.frame.add(this.initButtons());
        this.frame.setSize(250, 350);
        this.zoomMinusButton.setVisible(this.zoomShow && this.drawPieces);
        this.zoomPlusButton.setVisible(this.zoomShow && this.drawPieces);
        this.zoomPlusButton.repaint();
        this.zoomMinusButton.repaint();
    }

    protected Component initTree() {
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setCellRenderer(this.initTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(e -> {
            GamePiece piece;
            if (this.centerOnPiece && (piece = this.getSelectedCounter()) != null && piece.getMap() != null) {
                piece.getMap().centerAt(piece.getPosition());
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                CounterNode node;
                GamePiece piece;
                TreePath path;
                if (Inventory.this.showMenu && e.isPopupTrigger() && (path = Inventory.this.tree.getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof CounterNode && (piece = (node = (CounterNode)path.getLastPathComponent()).getCounter().getPiece()) != null) {
                    if (!Inventory.this.isVisibleToMe(piece)) {
                        return;
                    }
                    JPopupMenu menu = MenuDisplayer.createPopup(piece);
                    if (menu != null) {
                        menu.addPropertyChangeListener("visible", evt -> {
                            if (Boolean.FALSE.equals(evt.getNewValue())) {
                                SwingUtilities.invokeLater(() -> Inventory.this.refresh());
                            }
                        });
                        menu.show(Inventory.this.tree, e.getX(), e.getY());
                    }
                }
            }
        });
        this.tree.addKeyListener(new HotKeySender());
        ScrollPane scrollPane = new ScrollPane(this.tree, 20, 30);
        this.refresh();
        return scrollPane;
    }

    private double getCurrentZoom() {
        if (this.zoomShow) {
            if (this.zoomLevel == 1) {
                return this.pieceZoom2;
            }
            if (this.zoomLevel >= 2) {
                return this.pieceZoom3;
            }
        }
        return this.pieceZoom;
    }

    private boolean isVisibleToMe(GamePiece p) {
        Map map = p.getMap();
        return !(map instanceof PrivateMap) || ((PrivateMap)map).isVisibleTo(PlayerRoster.getMySide());
    }

    protected TreeCellRenderer initTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -250332615261355856L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                GamePiece piece;
                if (!GlobalOptions.getInstance().isInventoryVisibleToAll() && value instanceof CounterNode && (piece = ((CounterNode)value).getCounter().getPiece()) != null && !Inventory.this.isVisibleToMe(piece)) {
                    super.getTreeCellRendererComponent(tree, Resources.getString("Inventory.unknown_piece"), sel, expanded, false, row, hasFocus);
                    this.setIcon(null);
                    return this;
                }
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf && !Inventory.this.foldersOnly, row, hasFocus);
                if (value instanceof CounterNode && (piece = ((CounterNode)value).getCounter().getPiece()) != null) {
                    final Rectangle r = piece.getShape().getBounds();
                    double zoom = Inventory.this.getCurrentZoom();
                    r.x = (int)Math.round((double)r.x * zoom);
                    r.y = (int)Math.round((double)r.y * zoom);
                    r.width = (int)Math.round((double)r.width * zoom);
                    r.height = (int)Math.round((double)r.height * zoom);
                    this.setIcon(Inventory.this.drawPieces ? new Icon(){

                        @Override
                        public int getIconHeight() {
                            return r.height;
                        }

                        @Override
                        public int getIconWidth() {
                            return r.width;
                        }

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            Graphics2D g2d = (Graphics2D)g;
                            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                            AffineTransform orig_t = g2d.getTransform();
                            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                            piece.draw(g, (int)((double)(-r.x) * os_scale), (int)((double)(-r.y) * os_scale), c, Inventory.this.getCurrentZoom() * os_scale);
                            g2d.setTransform(orig_t);
                        }
                    } : null);
                }
                return this;
            }
        };
    }

    private void zoomPlus() {
        if (this.zoomLevel < 2) {
            ++this.zoomLevel;
        }
        this.tree.setCellRenderer(this.initTreeCellRenderer());
        this.refresh();
    }

    private void zoomMinus() {
        if (this.zoomLevel > 0) {
            --this.zoomLevel;
        }
        this.tree.setCellRenderer(this.initTreeCellRenderer());
        this.refresh();
    }

    protected Component initButtons() {
        Box buttonBox = Box.createHorizontalBox();
        this.zoomMinusButton = new IconButton(1);
        this.zoomMinusButton.addActionListener(e -> this.zoomMinus());
        buttonBox.add(this.zoomMinusButton);
        this.zoomPlusButton = new IconButton(0);
        this.zoomPlusButton.addActionListener(e -> this.zoomPlus());
        buttonBox.add(this.zoomPlusButton);
        JButton writeButton = new JButton(Resources.getString("General.save"));
        writeButton.addActionListener(e -> this.inventoryToText());
        buttonBox.add(writeButton);
        JButton refreshButton = new JButton(Resources.getString("General.refresh"));
        refreshButton.addActionListener(e -> this.refresh());
        buttonBox.add(refreshButton);
        JButton closeButton = new JButton(Resources.getString("General.close"));
        closeButton.addActionListener(e -> this.frame.setVisible(false));
        buttonBox.add(closeButton);
        return buttonBox;
    }

    protected void inventoryToText() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        if (fc.showSaveDialog() == 1) {
            return;
        }
        StringBuilder output = new StringBuilder();
        File file = fc.getSelectedFile();
        this.mapSeparator = System.getProperty("line.separator");
        output.append(this.results.getResultString());
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
             PrintWriter p = new PrintWriter(bw);){
            p.print(output);
            Chatter.DisplayText c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), Resources.getString("Inventory.wrote", file));
            c.execute();
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, file);
        }
    }

    public GamePiece getSelectedCounter() {
        GamePiece piece = null;
        CounterNode node = (CounterNode)this.tree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            piece = node.getCounter().getPiece();
        }
        return piece;
    }

    @Override
    public void removeFrom(Buildable b) {
        super.removeFrom(b);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public void remove(Buildable b) {
    }

    protected void launch() {
        if (FUNCTION_HIDE.equals(this.launchFunction) && this.frame.isVisible()) {
            this.frame.setVisible(false);
        } else {
            this.refresh();
            this.zoomPlusButton.setVisible(this.zoomShow && this.drawPieces);
            this.zoomMinusButton.setVisible(this.zoomShow && this.drawPieces);
            this.zoomPlusButton.repaint();
            this.zoomMinusButton.repaint();
            this.frame.setVisible(true);
        }
    }

    private void buildTreeModel() {
        for (Map m : Map.getMapList()) {
            m.getPieces();
        }
        ArrayList<String> path = new ArrayList<String>();
        Collections.addAll(path, this.groupBy);
        this.results = new CounterInventory(new Counter(this.getConfigureName()), path, this.sortPieces);
        PieceIterator pi = new PieceIterator(GameModule.getGameModule().getGameState().getAllPieces().iterator(), (PieceFilter)this.piecePropertiesFilter);
        while (pi.hasMoreElements()) {
            ArrayList<String> groups = new ArrayList<String>();
            GamePiece p = pi.nextPiece();
            if (!(p instanceof Decorator) && !(p instanceof BasicPiece)) continue;
            for (String s : this.groupBy) {
                Object prop;
                if (s.length() <= 0 || (prop = p.getLocalizedProperty(s)) == null) continue;
                groups.add(String.valueOf(prop));
            }
            int count = 1;
            if (this.nonLeafFormat.length() > 0) {
                count = this.getTotalValue(p);
            }
            Counter c = new Counter(p, groups, count, this.pieceFormat, this.sortFormat);
            this.results.insert(c);
        }
    }

    protected int getTotalValue(GamePiece p) {
        int count;
        String s = (String)p.getProperty(this.nonLeafFormat);
        try {
            count = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            count = 1;
        }
        return count;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Inventory.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.Inventory.show_pieces"), Resources.getString("Editor.Inventory.sort_group_properties"), Resources.getString("Editor.Inventory.label_folders"), Resources.getString("Editor.Inventory.show_folders"), Resources.getString("Editor.Inventory.label_pieces"), Resources.getString("Editor.Inventory.sort"), Resources.getString("Editor.Inventory.label_sort"), Resources.getString("Editor.Inventory.sort_method"), Resources.getString("Editor.Inventory.center_piece"), Resources.getString("Editor.Inventory.forward_keystroke"), Resources.getString("Editor.Inventory.rightclick_piece"), Resources.getString("Editor.Inventory.draw_piece"), Resources.getString("Editor.Inventory.zoom_on"), Resources.getString("Editor.Inventory.zoom"), Resources.getString("Editor.Inventory.zoom_2"), Resources.getString("Editor.Inventory.zoom_3"), Resources.getString("Editor.Inventory.available"), Resources.getString("Editor.Inventory.function"), Resources.getString("Editor.Inventory.refresh_hotkey")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{PropertyExpression.class, String[].class, String.class, Boolean.class, PieceFormatConfig.class, Boolean.class, PieceFormatConfig.class, SortConfig.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Double.class, Double.class, Double.class, String[].class, FunctionConfig.class, NamedKeyStroke.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{FILTER, GROUP_BY, NON_LEAF_FORMAT, FOLDERS_ONLY, LEAF_FORMAT, SORT_PIECES, SORT_FORMAT, SORTING, CENTERONPIECE, FORWARD_KEYSTROKE, SHOW_MENU, DRAW_PIECES, ZOOM_ON, PIECE_ZOOM, ZOOM_2, ZOOM_3, SIDES, LAUNCH_FUNCTION, REFRESH_HOTKEY});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (FILTER.equals(key)) {
            this.piecePropertiesFilter.setExpression((String)o);
        } else if (GROUP_BY.equals(key)) {
            if (o instanceof String) {
                o = StringArrayConfigurer.stringToArray((String)o);
            }
            this.groupBy = o;
        } else if (NON_LEAF_FORMAT.equals(key)) {
            this.nonLeafFormat = (String)o;
        } else if (LEAF_FORMAT.equals(key)) {
            this.pieceFormat = (String)o;
        } else if (CENTERONPIECE.equals(key)) {
            this.centerOnPiece = this.getBooleanValue(o);
        } else if (SHOW_MENU.equals(key)) {
            this.showMenu = this.getBooleanValue(o);
        } else if (DRAW_PIECES.equals(key)) {
            this.drawPieces = this.getBooleanValue(o);
        } else if (FOLDERS_ONLY.equals(key)) {
            this.foldersOnly = this.getBooleanValue(o);
            this.cutAboveLeaves = this.foldersOnly ? 1 : 0;
        } else if (ZOOM_ON.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.zoomShow = (Boolean)o;
        } else if (PIECE_ZOOM.equals(key)) {
            if (o instanceof String) {
                o = Double.valueOf((String)o);
            }
            this.pieceZoom = (Double)o;
        } else if (ZOOM_2.equals(key)) {
            if (o instanceof String) {
                o = Double.valueOf((String)o);
            }
            this.pieceZoom2 = (Double)o;
        } else if (ZOOM_3.equals(key)) {
            if (o instanceof String) {
                o = Double.valueOf((String)o);
            }
            this.pieceZoom3 = (Double)o;
        } else if (FORWARD_KEYSTROKE.equals(key)) {
            this.forwardKeystroke = this.getBooleanValue(o);
        } else if (SIDES.equals(key)) {
            if (o instanceof String) {
                o = StringArrayConfigurer.stringToArray((String)o);
            }
            this.sides = o;
        } else if (KEYSTROKE.equals(key)) {
            if (o instanceof String) {
                o = HotKeyConfigurer.decode((String)o);
            }
            this.keyStroke = (KeyStroke)o;
        } else if (CUTBELOWROOT.equals(key)) {
            this.cutBelowRoot = o instanceof String ? Integer.parseInt((String)o) : (Integer)o;
        } else if (CUTABOVELEAVES.equals(key)) {
            this.cutAboveLeaves = o instanceof String ? Integer.parseInt((String)o) : (Integer)o;
        } else if (SORT_PIECES.equals(key)) {
            this.sortPieces = this.getBooleanValue(o);
        } else if (SORT_FORMAT.equals(key)) {
            this.sortFormat = (String)o;
        } else if (SORTING.equals(key)) {
            this.sortStrategy = (String)o;
        } else if (LAUNCH_FUNCTION.equals(key)) {
            this.launchFunction = (String)o;
        } else if (REFRESH_HOTKEY.equals(key)) {
            if (o instanceof String) {
                o = NamedHotKeyConfigurer.decode((String)o);
            }
            this.refreshListener.setKeyStroke((NamedKeyStroke)o);
        } else {
            super.setAttribute(key, o);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(PIECE_ZOOM, ZOOM_2, ZOOM_3).contains(name)) {
            return () -> this.drawPieces && !this.foldersOnly;
        }
        if (List.of(LEAF_FORMAT, CENTERONPIECE, FORWARD_KEYSTROKE, SHOW_MENU, DRAW_PIECES).contains(name)) {
            return this.piecesVisible;
        }
        return super.getAttributeVisibility(name);
    }

    protected boolean getBooleanValue(Object o) {
        if (o instanceof String) {
            o = Boolean.valueOf((String)o);
        }
        return (Boolean)o;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (FILTER.equals(key)) {
            return this.piecePropertiesFilter.getExpression();
        }
        if (GROUP_BY.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.groupBy);
        }
        if (NON_LEAF_FORMAT.equals(key)) {
            return this.nonLeafFormat;
        }
        if (LEAF_FORMAT.equals(key)) {
            return this.pieceFormat;
        }
        if (CENTERONPIECE.equals(key)) {
            return String.valueOf(this.centerOnPiece);
        }
        if (FORWARD_KEYSTROKE.equals(key)) {
            return String.valueOf(this.forwardKeystroke);
        }
        if (SHOW_MENU.equals(key)) {
            return String.valueOf(this.showMenu);
        }
        if (DRAW_PIECES.equals(key)) {
            return String.valueOf(this.drawPieces);
        }
        if (FOLDERS_ONLY.equals(key)) {
            return String.valueOf(this.foldersOnly);
        }
        if (PIECE_ZOOM.equals(key)) {
            return String.valueOf(this.pieceZoom);
        }
        if (ZOOM_ON.equals(key)) {
            return String.valueOf(this.zoomShow);
        }
        if (ZOOM_2.equals(key)) {
            return String.valueOf(this.pieceZoom2);
        }
        if (ZOOM_3.equals(key)) {
            return String.valueOf(this.pieceZoom3);
        }
        if (SIDES.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.sides);
        }
        if (KEYSTROKE.equals(key)) {
            return HotKeyConfigurer.encode(this.keyStroke);
        }
        if (CUTBELOWROOT.equals(key)) {
            return Integer.toString(this.cutBelowRoot);
        }
        if (CUTABOVELEAVES.equals(key)) {
            return Integer.toString(this.cutAboveLeaves);
        }
        if (SORT_PIECES.equals(key)) {
            return Boolean.toString(this.sortPieces);
        }
        if (SORT_FORMAT.equals(key)) {
            return this.sortFormat;
        }
        if (SORTING.equals(key)) {
            return this.sortStrategy;
        }
        if (LAUNCH_FUNCTION.equals(key)) {
            return this.launchFunction;
        }
        if (REFRESH_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.refreshListener.getNamedKeyStroke());
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void checkDisabled() {
        if (this.enabledForPlayersSide()) {
            super.checkDisabled();
        } else {
            this.getLaunchButton().setEnabled(false);
        }
    }

    @Override
    public void disableIfTrue(boolean disable) {
        if (this.enabledForPlayersSide()) {
            super.disableIfTrue(disable);
        } else {
            this.getLaunchButton().setEnabled(false);
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        super.setup(gameStarting);
        if (!gameStarting) {
            this.getLaunchButton().setEnabled(false);
        } else {
            this.checkDisabled();
        }
        if (gameStarting) {
            this.setupLaunch();
        } else if (!GameModule.getGameModule().isLoadOverSemaphore()) {
            this.frame.setVisible(false);
        }
    }

    protected void setupLaunch() {
        LaunchButton myButton = this.getLaunchButton();
        this.checkDisabled();
        if (myButton.getClientProperty("hidden") == null) {
            myButton.setVisible(this.enabledForPlayersSide());
        }
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        this.setupLaunch();
    }

    protected boolean enabledForPlayersSide() {
        if (this.sides == null || this.sides.length == 0) {
            return true;
        }
        for (String side : this.sides) {
            if (!side.equalsIgnoreCase(PlayerRoster.getMySide())) continue;
            return true;
        }
        return false;
    }

    protected Command sendHotKeyToPieces(KeyStroke keyStroke) {
        NullCommand c = new NullCommand();
        TreePath[] tp = this.tree.getSelectionPaths();
        if (tp == null) {
            return c;
        }
        HashSet<GamePiece> pieces = new HashSet<GamePiece>();
        for (TreePath treePath : tp) {
            CounterNode node = (CounterNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                pieces.add(node.getCounter().getPiece());
                continue;
            }
            Iterator<CounterNode> j = node.iterator();
            while (j.hasNext()) {
                CounterNode childNode = j.next();
                if (!childNode.isLeaf()) continue;
                pieces.add(childNode.getCounter().getPiece());
            }
        }
        for (GamePiece piece : pieces) {
            GameModule.getGameModule().sendAndLog(piece.keyEvent(keyStroke));
        }
        return c;
    }

    protected Command myUndoCommand() {
        return null;
    }

    private void refresh() {
        int i;
        HashSet<String> expanded = new HashSet<String>();
        int n = this.tree.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!this.tree.isExpanded(i)) continue;
            expanded.add(this.tree.getPathForRow(i).getLastPathComponent().toString());
        }
        this.buildTreeModel();
        this.tree.setModel(this.results);
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            if (!expanded.contains(this.tree.getPathForRow(i).getLastPathComponent().toString())) continue;
            this.tree.expandRow(i);
        }
        if (this.zoomPlusButton != null) {
            this.zoomPlusButton.setEnabled(this.zoomLevel < 2);
            this.zoomMinusButton.setEnabled(this.zoomLevel > 0);
            this.zoomPlusButton.setVisible(this.zoomShow && this.drawPieces);
            this.zoomMinusButton.setVisible(this.zoomShow && this.drawPieces);
            this.zoomPlusButton.repaint();
            this.zoomMinusButton.repaint();
        }
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.piecePropertiesFilter.getExpression());
    }

    @Override
    public List<String> getFormattedStringList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.nonLeafFormat);
        if (this.piecesVisible.shouldBeVisible()) {
            l.add(this.pieceFormat);
        }
        l.add(this.sortFormat);
        return l;
    }

    public class HotKeySender
    implements KeyListener {
        BoundsTracker tracker;

        public void keyCommand(KeyStroke stroke) {
            Command comm;
            CounterNode node;
            if (Inventory.this.forwardKeystroke && (node = (CounterNode)Inventory.this.tree.getLastSelectedPathComponent()) != null && (comm = this.getCommand(node, stroke)) != null && !comm.isNull()) {
                this.tracker.repaint();
                GameModule.getGameModule().sendAndLog(comm);
                this.tracker = null;
                Inventory.this.refresh();
            }
        }

        protected Command getCommand(CounterNode node, KeyStroke stroke) {
            Command comm;
            GamePiece p;
            GamePiece gamePiece = p = node.getCounter() == null ? null : node.getCounter().getPiece();
            if (p != null) {
                if (!Inventory.this.isVisibleToMe(p)) {
                    return new NullCommand();
                }
                p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                if (this.tracker == null) {
                    this.tracker = new BoundsTracker();
                    this.tracker.addPiece(p);
                }
                comm = p.keyEvent(stroke);
            } else {
                comm = new NullCommand();
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    comm = comm.append(this.getCommand((CounterNode)node.getChild(i), stroke));
                }
            }
            return comm;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }
    }

    public class CounterInventory
    implements TreeModel {
        protected List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
        protected java.util.Map<String, CounterNode> inventory;
        protected CounterNode root;
        protected String resultString;
        protected List<String> path;
        protected boolean changed;
        protected boolean sort;

        public CounterInventory(Counter c, List<String> path, boolean sort) {
            this.root = new CounterNode(c.getName(), c);
            this.path = path;
            this.inventory = new HashMap<String, CounterNode>();
            this.sort = sort;
            this.changed = true;
        }

        public void insert(Counter counter) {
            CounterNode newNode;
            String[] path = counter.getPath();
            StringBuilder hash = new StringBuilder();
            CounterNode insertNode = this.root;
            for (int j = 0; path != null && j < path.length; ++j) {
                hash.append(path[j]);
                if (this.inventory.get(hash.toString()) == null) {
                    newNode = new CounterNode(path[j], new Counter(path[j], counter.getPiece()), insertNode.getLevel() + 1);
                    this.inventory.put(hash.toString(), newNode);
                    insertNode.addChild(newNode, this.sort);
                }
                insertNode = this.inventory.get(hash.toString());
            }
            newNode = new CounterNode(counter.toString(), counter, insertNode.getLevel() + 1);
            insertNode.addChild(newNode, this.sort);
            this.changed = true;
        }

        private void updateEntries() {
            this.root.updateValues();
        }

        public String getResultString() {
            if (this.changed) {
                this.updateTree();
            }
            this.changed = false;
            return this.root.toResultString();
        }

        public String[] getResultStringArray() {
            return new String[]{this.getResultString()};
        }

        @Override
        public Object getRoot() {
            if (this.changed) {
                this.updateTree();
            }
            return this.root;
        }

        private void updateTree() {
            this.updateEntries();
            if (Inventory.this.cutBelowRoot > 0) {
                this.root.cutLevel(Inventory.this.cutBelowRoot);
            }
            for (int i = Inventory.this.cutAboveLeaves; i > 0; --i) {
                this.root.cutLeaves();
            }
            this.changed = false;
        }

        @Override
        public int getChildCount(Object parent) {
            CounterNode counter = (CounterNode)parent;
            return counter.getChildCount();
        }

        @Override
        public boolean isLeaf(Object node) {
            CounterNode counter = (CounterNode)node;
            return counter.isLeaf();
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.remove(l);
        }

        public void fireNodesRemoved(Object[] path, int[] childIndices, Object[] children) {
            TreeModelEvent e = new TreeModelEvent((Object)this, path, childIndices, children);
            for (TreeModelListener l : this.treeModelListeners) {
                l.treeNodesRemoved(e);
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            CounterNode counter = (CounterNode)parent;
            return counter.getChild(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            CounterNode counter = (CounterNode)parent;
            return counter.getIndexOfChild(child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }
    }

    public class CounterNode
    implements Comparable<CounterNode> {
        protected final String entry;
        protected final Counter counter;
        protected List<CounterNode> children;
        protected int level = 0;

        public CounterNode(String entry, Counter counter, int level) {
            this(entry, counter);
            this.level = level;
        }

        protected CounterNode(String entry, Counter counter) {
            this.entry = entry;
            this.counter = counter;
            counter.setNode(this);
            this.children = new ArrayList<CounterNode>();
        }

        public String toString() {
            if (this.counter != null) {
                return this.counter.toString();
            }
            return this.getEntry();
        }

        protected String separator() {
            StringBuilder sep = new StringBuilder();
            if (this.getLevel() > 0) {
                sep.append(Inventory.this.mapSeparator);
            }
            for (int i = 0; i < this.getLevel(); ++i) {
                sep.append(Inventory.this.groupSeparator);
            }
            return sep.toString();
        }

        public String toResultString() {
            StringBuilder name = new StringBuilder();
            name.append(this.separator());
            if (this.counter != null) {
                name.append(this.counter);
            } else {
                name.append(this.getEntry());
            }
            for (CounterNode child : this.children) {
                name.append(child.toResultString());
            }
            return name.toString();
        }

        public String getEntry() {
            return this.entry;
        }

        public Counter getCounter() {
            return this.counter;
        }

        public void addChild(CounterNode counterNode, boolean sort) {
            this.children.add(counterNode);
            if (sort) {
                this.sortChildren();
            }
        }

        public void addChild(int i, CounterNode counterNode, boolean sort) {
            this.children.add(i, counterNode);
            if (sort) {
                this.sortChildren();
            }
        }

        protected void sortChildren() {
            if (Inventory.this.sortStrategy.equals(Inventory.ALPHA)) {
                Collections.sort(this.children);
            } else if (Inventory.this.sortStrategy.equals(Inventory.LENGTHALPHA)) {
                this.children.sort(new LengthAlpha());
            } else if (Inventory.this.sortStrategy.equals(Inventory.NUMERIC)) {
                this.children.sort(new Numerical());
            } else {
                Collections.sort(this.children);
            }
        }

        public void removeChild(CounterNode child) {
            this.children.remove(child);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public Object getChild(int index) {
            return this.children.get(index);
        }

        public int getIndexOfChild(Object child) {
            return this.children.indexOf(child);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int updateValues() {
            int value = 0;
            if (this.counter != null) {
                value = this.counter.getValue();
            }
            for (CounterNode child : this.children) {
                value += child.updateValues();
            }
            this.counter.setValue(value);
            return this.counter.getValue();
        }

        public Iterator<CounterNode> iterator() {
            return this.children.iterator();
        }

        public void cutLevel(int cut) {
            if (cut == 0) {
                this.children.clear();
                return;
            }
            for (CounterNode child : this.children) {
                child.cutLevel(cut - 1);
            }
        }

        public void cutLeaves() {
            ArrayList<CounterNode> toBeRemoved = new ArrayList<CounterNode>();
            for (CounterNode child : this.children) {
                if (child.isLeaf()) {
                    toBeRemoved.add(child);
                    continue;
                }
                child.cutLeaves();
            }
            this.children.removeAll(toBeRemoved);
        }

        @Override
        public int compareTo(CounterNode node) {
            return this.toSortKey().compareTo(node.toSortKey());
        }

        protected String toSortKey() {
            String sortKey = this.getEntry();
            if (this.counter != null) {
                sortKey = this.counter.toSortKey();
            }
            if (!this.children.isEmpty()) {
                sortKey = this.toString();
            }
            return sortKey;
        }

        protected class LengthAlpha
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected LengthAlpha() {
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                int rightLength;
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                int leftLength = left.toSortKey().length();
                if (leftLength < (rightLength = right.toSortKey().length())) {
                    return -1;
                }
                if (leftLength > rightLength) {
                    return 1;
                }
                return left.compareTo(right);
            }
        }

        protected class Numerical
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected final String regex = "\\d+";
            protected final Pattern p;

            protected Numerical() {
                this.regex = "\\d+";
                this.p = Pattern.compile("\\d+");
            }

            protected int getInt(String key) {
                int found = Integer.MIN_VALUE;
                Matcher match = this.p.matcher(key);
                if (!match.find()) {
                    return found;
                }
                int start = match.start();
                found = Integer.parseInt(key.substring(start, match.end()));
                if (start > 0 && key.charAt(start - 1) == '-') {
                    found *= -1;
                }
                return found;
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                int r;
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                int l = this.getInt(left.toSortKey());
                if (l < (r = this.getInt(right.toSortKey()))) {
                    return -1;
                }
                if (l > r) {
                    return 1;
                }
                return 0;
            }
        }

        protected class Alpha
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected Alpha() {
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                return left.compareTo(right);
            }
        }

        protected class CompareCounterNodes {
            protected CompareCounterNodes() {
            }

            protected boolean argsOK(Object arg0, Object arg1) {
                return arg0 instanceof CounterNode && arg1 instanceof CounterNode;
            }

            protected int compareStrangeArgs(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return 1;
                }
                if (arg0.equals(arg1)) {
                    return 0;
                }
                if (arg1 == null) {
                    return -1;
                }
                if (arg0 instanceof CounterNode && !(arg1 instanceof CounterNode)) {
                    return -1;
                }
                if (arg1 instanceof CounterNode && !(arg0 instanceof CounterNode)) {
                    return 1;
                }
                throw new IllegalArgumentException("These CounterNodes are not strange!");
            }
        }
    }

    public class Counter
    implements PropertySource {
        protected GamePiece piece;
        protected GamePiece source;
        protected List<String> groups;
        protected int value;
        protected String localName;
        protected FormattedString format;
        protected FormattedString sortingFormat;
        protected CounterNode node;

        public Counter(String name) {
            this(name, null);
        }

        public Counter(String name, GamePiece p) {
            this(null, null, 0, this$0.nonLeafFormat, this$0.sortFormat);
            this.localName = name;
            this.source = p;
        }

        public Counter(GamePiece piece, List<String> groups, int value, String format, String sortFormat) {
            this.piece = piece;
            this.value = value;
            this.groups = groups;
            this.format = new FormattedString(format);
            this.sortingFormat = new FormattedString(sortFormat);
        }

        public String getName() {
            if (this.piece != null) {
                return this.piece.getName();
            }
            return this.localName;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.format.getLocalizedText((PropertySource)this, (Auditable)this, "Editor.Inventory.label_pieces");
        }

        public String toSortKey() {
            return this.sortingFormat.getLocalizedText((PropertySource)this, (Auditable)this, "Editor.Inventory.label_sort");
        }

        public String[] getPath() {
            return this.groups.toArray(new String[0]);
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public GamePiece getPiece() {
            return this.piece;
        }

        public void setPiece(GamePiece piece) {
            this.piece = piece;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Counter)) {
                return false;
            }
            Counter c = (Counter)o;
            return this.groups.equals(c.groups);
        }

        @Override
        public Object getProperty(Object key) {
            Object value = null;
            String s = (String)key;
            if (s.startsWith("sum_")) {
                if (this.piece != null) {
                    value = this.piece.getProperty(s.substring(4));
                } else {
                    int sum = 0;
                    int n = Inventory.this.results.getChildCount(this.node);
                    for (int i = 0; i < n; ++i) {
                        try {
                            CounterNode childNode = (CounterNode)Inventory.this.results.getChild(this.node, i);
                            sum += Integer.parseInt((String)childNode.getCounter().getProperty(key));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            ++sum;
                        }
                    }
                    value = String.valueOf(sum);
                }
            } else {
                if ("PropertyValue".equals(s)) {
                    return this.localName;
                }
                if (this.piece != null) {
                    value = this.piece.getProperty(key);
                } else if (this.source != null) {
                    value = this.source.getProperty(key);
                }
            }
            return value;
        }

        @Override
        public Object getLocalizedProperty(Object key) {
            return this.getProperty(key);
        }

        public void setNode(CounterNode node) {
            this.node = node;
        }
    }

    public static class PieceFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new GamePieceFormattedStringConfigurer(key, name);
        }
    }

    public static class SortConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new StringEnumConfigurer(key, name, SORT_OPTIONS);
        }
    }

    public static class FunctionConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new TranslatingStringEnumConfigurer(key, name, FUNCTION_OPTIONS, FUNCTION_KEYS);
        }
    }

    protected static class Selector
    implements PieceFilter {
        protected PieceFilter filter;

        public Selector(String include) {
            if (include != null && include.length() > 0) {
                this.filter = PropertiesPieceFilter.parse(include);
            }
        }

        @Override
        public boolean accept(GamePiece piece) {
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                return false;
            }
            if (piece instanceof Stack) {
                return false;
            }
            if (piece.getMap() == null) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.accept(piece);
            }
            return true;
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/inventory.gif");
        }
    }
}

