/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.BoxWidget;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.PanelWidget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SplitPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class PieceWindow
extends Widget
implements UniqueIdManager.Identifyable {
    protected String id;
    protected LaunchButton launch;
    protected boolean hidden;
    public static final String DEPRECATED_NAME = "entryName";
    public static final String NAME = "name";
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN = "hidden";
    public static final String SCALE = "scale";
    public static final String DEFAULT_DOCKED_WIDTH = "defaultWidth";
    protected static final UniqueIdManager idMgr = new UniqueIdManager(PieceWindow.class.getSimpleName());
    protected JComponent root = new JPanel(new BorderLayout());
    protected String tooltip = "";
    protected double scale;
    protected int defaultDockedWidth;
    @Deprecated(since="2020-11-15", forRemoval=true)
    protected ComponentSplitter.SplitPane mainWindowDock;
    protected SplitPane splitPane;
    private static final String firstId = PieceWindow.class.getSimpleName() + "0";

    public PieceWindow() {
        this.launch = new LaunchButton(Resources.getString("Editor.PieceWindow.pieces"), TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, e -> this.launchButtonPressed());
        this.launch.setToolTipText(Resources.getString("Editor.PieceWindow.show_hide_pieces_window", Resources.getString("Editor.PieceWindow.pieces")));
        this.scale = 1.0;
        this.defaultDockedWidth = 0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    private Window initFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog d = new JDialog(GameModule.getGameModule().getPlayerWindow());
            d.add(this.root);
            d.setDefaultCloseOperation(1);
            d.setTitle(this.getConfigureName());
            this.addPropertyChangeListener(e -> {
                if (NAME.equals(e.getPropertyName())) {
                    d.setTitle((String)e.getNewValue());
                }
            });
            return d;
        }
        JFrame d = new JFrame();
        d.add(this.root);
        d.setDefaultCloseOperation(1);
        d.setTitle(this.getConfigureName());
        d.setJMenuBar(MenuManager.getInstance().getMenuBarFor(d));
        this.addPropertyChangeListener(e -> {
            if (NAME.equals(e.getPropertyName())) {
                d.setTitle((String)e.getNewValue());
            }
        });
        return d;
    }

    public void launchButtonPressed() {
        if (this.splitPane != null) {
            this.splitPane.toggleLeft();
        } else {
            Container tla = this.root.getTopLevelAncestor();
            if (tla != null) {
                tla.setVisible(!tla.isVisible());
            }
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PieceWindow.html");
    }

    @Override
    public void build(Element e) {
        super.build(e);
        this.rebuild();
    }

    public boolean shouldDockIntoMainWindow() {
        return firstId.equals(this.id);
    }

    @Override
    public Component getComponent() {
        return this.root;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PieceWindow.component_type");
    }

    @Override
    public Class<?>[] getChildAllowableConfigureComponents() {
        return new Class[]{TabWidget.class, PanelWidget.class, BoxWidget.class, ListWidget.class, PieceSlot.class};
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{TabWidget.class, PanelWidget.class, BoxWidget.class, ListWidget.class};
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            this.root.add(((Widget)b).getComponent());
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            this.root.remove(((Widget)b).getComponent());
        }
        super.remove(b);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String s) {
        this.id = s;
    }

    public void dockMe() {
        JComponent controlPanel = GameModule.getGameModule().getControlPanel();
        Container cppar = controlPanel.getParent();
        int i = SwingUtils.getIndexInParent(controlPanel, cppar);
        this.splitPane = new SplitPane(1, this.root, controlPanel);
        if (this.defaultDockedWidth > 0) {
            this.splitPane.setDividerLocation(this.defaultDockedWidth);
        }
        this.splitPane.hideLeft();
        cppar.add((Component)this.splitPane, i);
    }

    @Override
    public void addTo(Buildable parent) {
        idMgr.add(this);
        if (!this.hidden) {
            if (firstId.equals(this.id) && GlobalOptions.getInstance().isUseSingleWindow()) {
                GameModule.getGameModule().setPieceWindow(this);
            } else {
                String key = "BoundsOf" + this.getConfigureName();
                Window w = this.initFrame();
                VisibilityOption pos = new VisibilityOption(key, w);
                GameModule.getGameModule().getPrefs().addOption(pos);
                GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.root, 2));
            }
            GameModule.getGameModule().getToolBar().add(this.launch);
        }
        this.setAttributeTranslatable(NAME, false);
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (this.splitPane == null && this.root != null && this.root.getTopLevelAncestor() != null) {
            this.root.getTopLevelAncestor().setVisible(false);
        }
        GameModule.getGameModule().getToolBar().remove(this.launch);
        idMgr.remove(this);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.PieceWindow.hidden"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.PieceWindow.show_hide"), Resources.getString("Editor.PieceWindow.scale"), Resources.getString("Editor.PieceWindow.default_docked_width")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, Double.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, "description", HIDDEN, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, SCALE, DEFAULT_DOCKED_WIDTH};
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (DEPRECATED_NAME.equals(name)) {
            this.setAttribute(NAME, value);
            this.setAttribute(BUTTON_TEXT, value);
        } else if (NAME.equals(name)) {
            String s = (String)value;
            this.setConfigureName(s);
            if (this.tooltip.isEmpty()) {
                this.launch.setToolTipText(Resources.getString("Editor.PieceWindow.show_hide_pieces_window", s));
            }
        } else if (HIDDEN.equals(name)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.hidden = (Boolean)value;
        } else if (SCALE.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.scale = (Double)value;
            if (this.scale < 0.01) {
                this.scale = 0.01;
            } else if (this.scale >= 4.0) {
                this.scale = 4.0;
            }
        } else if (TOOLTIP.equals(name)) {
            this.tooltip = (String)value;
            this.launch.setAttribute(name, value);
        } else if (DEFAULT_DOCKED_WIDTH.equals(name)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.defaultDockedWidth = (Integer)value;
        } else if ("description".equals(name)) {
            this.description = (String)value;
        } else {
            this.launch.setAttribute(name, value);
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if (NAME.equals(name)) {
            return this.getConfigureName();
        }
        if (HIDDEN.equals(name)) {
            return String.valueOf(this.hidden);
        }
        if (SCALE.equals(name)) {
            return String.valueOf(this.scale);
        }
        if (TOOLTIP.equals(name)) {
            return this.tooltip.isEmpty() ? this.launch.getAttributeValueString(name) : this.tooltip;
        }
        if (DEFAULT_DOCKED_WIDTH.equals(name)) {
            return String.valueOf(this.defaultDockedWidth);
        }
        if ("description".equals(name)) {
            return this.description;
        }
        return this.launch.getAttributeValueString(name);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.getAttributeValueString(BUTTON_TEXT), this.getAttributeValueString(TOOLTIP));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOTKEY)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String fileName = this.launch.getAttributeValueString(ICON);
        if (fileName != null) {
            s.add(fileName);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/counter.gif");
        }
    }
}

