/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.ChangePropertyCommand;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.tools.SequenceEncoder;

public class ChangePropertyCommandEncoder
implements CommandEncoder {
    protected static final String COMMAND_PREFIX = "MutableProperty\t";
    private final MutablePropertiesContainer container;

    public ChangePropertyCommandEncoder(MutablePropertiesContainer container) {
        this.container = container;
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command = command.substring(COMMAND_PREFIX.length()), '\t');
        String key = st.nextToken(null);
        if (key == null) {
            return null;
        }
        String oldValue = st.nextToken(null);
        String newValue = st.nextToken(null);
        String containerId = st.nextToken("");
        if (containerId.length() != 0 && !containerId.equals(this.container.getMutablePropertiesContainerId())) {
            return null;
        }
        MutableProperty p = this.container.getMutableProperty(key);
        if (p == null) {
            return null;
        }
        return new ChangePropertyCommand(p, key, oldValue, newValue);
    }

    @Override
    public String encode(Command c) {
        String their_cid;
        if (!(c instanceof ChangePropertyCommand)) {
            return null;
        }
        ChangePropertyCommand cpc = (ChangePropertyCommand)c;
        String our_cid = this.container.getMutablePropertiesContainerId();
        if (!our_cid.equals(their_cid = cpc.getProperty().getParent().getMutablePropertiesContainerId())) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder('\t');
        se.append(cpc.getPropertyName()).append(cpc.getOldValue()).append(cpc.getNewValue()).append(our_cid);
        return COMMAND_PREFIX + se.getValue();
    }
}

