/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.turn.CounterTurnLevel;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnComponent;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPanel;

public abstract class TurnLevel
extends TurnComponent {
    protected static final String NAME = "name";
    protected static final String PROP = "property";
    protected static final String TURN_FORMAT = "turnFormat";
    protected static final String LEVEL_VALUE = "value";
    protected TurnTracker turn;
    protected JDialog setDialog;
    protected JPanel levelSetControls = null;
    protected Component childSetControls = null;
    protected TurnComponent parent = null;
    protected String propertyName;
    protected int start = 1;
    protected int current = 1;
    protected int currentSubLevel = 0;
    protected boolean subLevelRolledOver = false;
    protected boolean rolledOver = false;
    protected MutableProperty.Impl myValue = new MutableProperty.Impl("", this);
    protected FormattedString turnFormat = new FormattedString("$value$");
    private static final Dimension FILLER = new Dimension(0, 3);

    protected abstract String getState();

    protected abstract void setState(String var1);

    protected abstract String getValueString();

    protected abstract String getLongestValueName();

    protected abstract Component getSetControl();

    public void findMaximumStrings(List<String> levels, int currentLevel) {
        String s = this.getLongestFormattedValue();
        if (levels.size() < currentLevel + 1 || levels.get(currentLevel) == null || levels.get(currentLevel).length() < s.length()) {
            levels.add(currentLevel, s);
        }
        for (Buildable b : this.getBuildables()) {
            if (!(b instanceof TurnLevel)) continue;
            ((TurnLevel)b).findMaximumStrings(levels, currentLevel + 1);
        }
    }

    protected String getLongestFormattedValue() {
        this.turnFormat.setProperty(LEVEL_VALUE, this.getLongestValueName());
        return this.turnFormat.getText(this, "Editor.TurnLevel.turn_level_format");
    }

    protected boolean hasSubLevelRolledOver() {
        return this.subLevelRolledOver;
    }

    protected boolean isActive() {
        return true;
    }

    protected void reset() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).reset();
        }
        this.currentSubLevel = 0;
    }

    protected void advance() {
        this.rolledOver = false;
        this.subLevelRolledOver = false;
        if (this.getTurnLevelCount() > 0) {
            TurnLevel subLevel = this.getTurnLevel(this.currentSubLevel);
            subLevel.advance();
            if (subLevel.hasRolledOver()) {
                ++this.currentSubLevel;
                if (this.currentSubLevel >= this.getTurnLevelCount()) {
                    this.currentSubLevel = 0;
                    this.subLevelRolledOver = true;
                }
                this.getTurnLevel(this.currentSubLevel).setLow();
            }
        }
    }

    protected void retreat() {
        this.rolledOver = false;
        this.subLevelRolledOver = false;
        if (this.getTurnLevelCount() > 0) {
            TurnLevel subLevel = this.getTurnLevel(this.currentSubLevel);
            subLevel.retreat();
            if (subLevel.hasRolledOver()) {
                --this.currentSubLevel;
                if (this.currentSubLevel < 0) {
                    this.currentSubLevel = this.getTurnLevelCount() - 1;
                    this.subLevelRolledOver = true;
                }
                this.getTurnLevel(this.currentSubLevel).setHigh();
            }
        }
    }

    public String getTurnString() {
        this.turnFormat.setProperty(LEVEL_VALUE, this.getValueString());
        return this.turnFormat.getText(this, "Editor.TurnLevel.turn_level_format");
    }

    public List<TurnLevel> getActiveChildLevels() {
        ArrayList<TurnLevel> children = new ArrayList<TurnLevel>();
        if (this.getTurnLevelCount() > 0) {
            TurnLevel activeChild = this.getTurnLevel(this.currentSubLevel);
            children.add(activeChild);
            children.addAll(activeChild.getActiveChildLevels());
        }
        return children;
    }

    protected void buildConfigMenu(JMenu menu) {
        JMenu m = this.getConfigMenu();
        if (m != null) {
            menu.add(m);
        }
    }

    protected JMenu getConfigMenu() {
        JMenu menu = new JMenu(this.getConfigureName());
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).buildConfigMenu(menu);
        }
        return menu.getItemCount() == 0 ? null : menu;
    }

    public boolean isConfigurable() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            if (!this.getTurnLevel(i).isConfigurable()) continue;
            return true;
        }
        return false;
    }

    protected Component getSetControls(JDialog dialog, TurnTracker turn) {
        this.turn = turn;
        this.setDialog = dialog;
        this.levelSetControls = new JPanel();
        this.levelSetControls.setLayout(new BoxLayout(this.levelSetControls, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(Box.createRigidArea(FILLER));
        p.add(this.getSetControl());
        p.add(Box.createRigidArea(FILLER));
        if (this.getTurnLevelCount() > 1) {
            String[] s = new String[this.getTurnLevelCount()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.getTurnLevel(i).getConfigureName();
            }
            StringEnumConfigurer e = new StringEnumConfigurer(null, Resources.getString("Editor.TurnLevel.select"), s);
            e.setValue(this.getTurnLevel(this.currentSubLevel).getConfigureName());
            e.addPropertyChangeListener(e1 -> {
                String option = ((StringEnumConfigurer)e1.getSource()).getValueString();
                for (int i = 0; i < this.getTurnLevelCount(); ++i) {
                    if (!option.equals(this.getTurnLevel(i).getConfigureName())) continue;
                    this.currentSubLevel = i;
                    this.addChildControls();
                }
            });
            p.add(e.getControls());
            p.add(Box.createRigidArea(FILLER));
        }
        this.levelSetControls.add(p);
        this.levelSetControls.add(Box.createRigidArea(FILLER));
        this.addChildControls();
        return this.levelSetControls;
    }

    protected void addChildControls() {
        if (this.childSetControls != null) {
            this.levelSetControls.remove(this.childSetControls);
        }
        if (this.getTurnLevelCount() > 0) {
            this.childSetControls = this.getTurnLevel(this.currentSubLevel).getSetControls(this.setDialog, this.turn);
            this.levelSetControls.add(this.childSetControls);
            this.setDialog.pack();
        }
    }

    protected TurnTracker getTurn() {
        return this.turn;
    }

    protected void setRolledOver(boolean b) {
        this.rolledOver = b;
    }

    protected boolean hasRolledOver() {
        return this.rolledOver;
    }

    protected void setLow() {
        if (this.getTurnLevelCount() > 0) {
            this.currentSubLevel = 0;
            this.getTurnLevel(this.currentSubLevel).setLow();
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    protected void setHigh() {
        if (this.getTurnLevelCount() > 0) {
            this.currentSubLevel = this.getTurnLevelCount() - 1;
            this.getTurnLevel(this.currentSubLevel).setHigh();
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.TurnLevel.property_name"), Resources.getString("Editor.TurnLevel.turn_level_format")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, TurnFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, PROP, TURN_FORMAT};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            this.myValue.setPropertyName(this.getConfigureName());
        } else if (PROP.equals(key)) {
            this.propertyName = (String)value;
            this.myValue.setPropertyName(this.propertyName);
        } else if (TURN_FORMAT.equals(key)) {
            this.turnFormat.setFormat((String)value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (TURN_FORMAT.equals(key)) {
            return this.turnFormat.getFormat();
        }
        if (PROP.equals(key)) {
            return this.propertyName;
        }
        return "";
    }

    @Override
    public void addTo(Buildable parent) {
        this.parent = (TurnComponent)parent;
        ((TurnComponent)parent).addLevel(this);
        MutableProperty.Impl existingValue = (MutableProperty.Impl)GameModule.getGameModule().getMutableProperty(this.propertyName);
        if (existingValue == null) {
            this.myValue.addTo(GameModule.getGameModule());
        } else {
            this.myValue = existingValue;
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((TurnComponent)parent).removeLevel(this);
        this.myValue.removeFromContainer();
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CounterTurnLevel.class, ListTurnLevel.class};
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(PROP, false);
        return myI18nData;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.propertyName != null && this.propertyName.length() > 0) {
            l.add(this.propertyName);
        }
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.turnFormat.getFormat());
    }

    @Override
    public List<String> getPropertyList() {
        return this.propertyName != null ? List.of(this.propertyName) : List.of();
    }

    public static class TurnFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{TurnLevel.LEVEL_VALUE});
        }
    }
}

