/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.module.Chatter;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import java.util.Objects;
import java.util.Properties;

public class NodePlayer
extends SimplePlayer {
    public static final String ID = "id";

    public NodePlayer(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePlayer)) {
            return false;
        }
        NodePlayer hPlayer = (NodePlayer)o;
        return Objects.equals(this.id, hPlayer.id);
    }

    @Override
    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public void setInfo(Properties p) {
        this.name = p.getProperty("name", "???");
        if (this.name == null || this.name.isBlank() || this.name.equals("[nobody]")) {
            this.name = "(" + Chatter.getAnonymousUserName() + ")";
        }
        this.id = p.getProperty(ID, this.id);
        this.setStatus(new SimpleStatus("true".equals(p.getProperty("looking")), "true".equals(p.getProperty("away")), p.getProperty("profile", ""), p.getProperty("client", ""), p.getProperty("ip", ""), p.getProperty("moduleVersion", ""), p.getProperty("crc", "")));
    }

    public Properties toProperties() {
        String moduleVersion;
        String ip;
        String client;
        Properties p1 = new Properties();
        if (this.name != null) {
            p1.put("name", this.name);
        }
        SimpleStatus status = (SimpleStatus)this.getStatus();
        p1.put("looking", String.valueOf(status.isLooking()));
        p1.put("away", String.valueOf(status.isAway()));
        String profile = status.getProfile();
        if (profile != null) {
            p1.put("profile", profile);
        }
        if ((client = status.getClient()) != null) {
            p1.put("client", client);
        }
        if ((ip = status.getIp()) != null) {
            p1.put("ip", ip);
        }
        if ((moduleVersion = status.getModuleVersion()) != null) {
            p1.put("moduleVersion", moduleVersion);
        }
        String crc = status.getCrc();
        if (ip != null) {
            p1.put("crc", crc);
        }
        p1.put(ID, this.id == null ? "" : this.id);
        return p1;
    }
}

