/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertiesWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Configurer configurer;
    private Configurable target;
    private Element originalState;

    public PropertiesWindow(Frame owner, boolean modal, Configurable target, HelpWindow helpWindow) {
        super(owner, modal);
        this.initialize(target, helpWindow);
    }

    protected void initialize(Configurable target, HelpWindow helpWindow) {
        this.target = target;
        this.originalState = target.getBuildElement(Builder.createNewDocument());
        Node child = this.originalState.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            if (1 == child.getNodeType()) {
                try {
                    Class<?> c = GameModule.getGameModule().getDataArchive().loadClass(((Element)child).getTagName());
                    if (Buildable.class.isAssignableFrom(c)) {
                        this.originalState.removeChild(child);
                    }
                }
                catch (ClassNotFoundException c) {
                }
                catch (LinkageError e2) {
                    ErrorDialog.bug(e2);
                }
            }
            child = nextChild;
        }
        this.setLayout((LayoutManager)new MigLayout("ins panel,wrap 1", "[grow,fill]", "[align top,grow][]"));
        this.configurer = target.getConfigurer();
        target.addPropertyChangeListener(evt -> {
            if ("name".equals(evt.getPropertyName())) {
                this.setTitle((String)evt.getNewValue());
            }
        });
        this.setTitle(ConfigureTree.getConfigureName(target));
        JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
        JButton okButton = new JButton(Resources.getString("General.ok"));
        okButton.addActionListener(e -> this.save());
        buttonBox.add((Component)okButton, "sg,tag ok");
        JButton cancelButton = new JButton(Resources.getString("General.cancel"));
        cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add((Component)cancelButton, "sg,tag cancel");
        if (target.getHelpFile() != null) {
            ShowHelpAction helpAction = new ShowHelpAction(target.getHelpFile().getContents(), null);
            JButton helpButton = new JButton(helpAction);
            buttonBox.add((Component)helpButton, "sg,tag help");
        }
        if (target instanceof PieceSlot || target instanceof PrototypeDefinition) {
            this.add(this.configurer.getControls(), "grow");
        } else {
            JPanel scrollPanel = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]"));
            JScrollPane scroll = new JScrollPane(scrollPanel, 20, 30);
            scrollPanel.add(this.configurer.getControls());
            this.add(scroll);
        }
        this.add((Component)buttonBox, "growy 0");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        SwingUtils.ensureOnScreen(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PropertiesWindow.this.cancel();
            }
        });
    }

    public void cancel() {
        if (this.target instanceof GameModule) {
            this.target.setAttribute("name", this.originalState.getAttribute("name"));
            this.target.setAttribute("version", this.originalState.getAttribute("version"));
            this.target.setAttribute("description", this.originalState.getAttribute("description"));
        } else if (this.target instanceof Map) {
            for (String propName : ((Map)this.target).getAttributeNames()) {
                this.target.setAttribute(propName, this.originalState.getAttribute(propName));
            }
        } else {
            this.target.build(this.originalState);
        }
        this.dispose();
    }

    public void save() {
        this.configurer.getValue();
        this.dispose();
    }
}

