/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PropertyExporter;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class KeyCommand
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final KeyCommand[] NONE = new KeyCommand[0];
    private final String name;
    protected String untranslatedName;
    protected String localizedMenuText;
    private final KeyStroke stroke;
    private final GamePiece target;
    private boolean global;
    private boolean enabled = true;
    protected TranslatablePiece i18nPiece;
    protected NamedKeyStroke namedKeyStroke;

    public KeyCommand(String name, KeyStroke key, GamePiece target) {
        this(name, key, target, null);
    }

    public KeyCommand(String name, NamedKeyStroke key, GamePiece target) {
        this(name, key, target, null);
    }

    public KeyCommand(String name, KeyStroke key, GamePiece target, TranslatablePiece i18nPiece) {
        super(KeyCommand.makeMenuText(key, name));
        this.target = target;
        this.name = name;
        this.stroke = key;
        this.i18nPiece = i18nPiece;
    }

    public KeyCommand(String name, NamedKeyStroke key, GamePiece target, TranslatablePiece i18nPiece) {
        this(name, key == null ? null : key.getKeyStroke(), target, i18nPiece);
        this.namedKeyStroke = key == null ? NamedKeyStroke.NULL_KEYSTROKE : key;
    }

    public KeyCommand(String name, NamedKeyStroke key, GamePiece target, boolean enabled) {
        this(name, key, target, null, enabled);
    }

    public KeyCommand(String name, NamedKeyStroke key, GamePiece target, TranslatablePiece i18nPiece, boolean enabled) {
        this(name, key == null ? null : key.getKeyStroke(), target, i18nPiece, enabled);
        this.namedKeyStroke = key == null ? NamedKeyStroke.NULL_KEYSTROKE : key;
    }

    public KeyCommand(String name, KeyStroke key, GamePiece target, boolean enabled) {
        this(name, key, target, null, enabled);
    }

    public KeyCommand(String name, KeyStroke key, GamePiece target, TranslatablePiece i18nPiece, boolean enabled) {
        this(name, key, target, i18nPiece);
        this.setEnabled(enabled);
    }

    public KeyCommand(KeyCommand command) {
        this(command.name, command.stroke, command.target, command.i18nPiece, command.isEnabled());
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(KeyStroke key) {
        return this.isEnabled() && key != null && key.equals(this.stroke);
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public NamedKeyStroke getNamedKeyStroke() {
        return this.namedKeyStroke;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.stroke != null) {
            if (this.global) {
                GameModule.getGameModule().sendAndLog(KeyBuffer.getBuffer().keyCommand(this.stroke));
            } else {
                BoundsTracker t = new BoundsTracker();
                GamePiece outer = Decorator.getOutermost(this.target);
                t.addPiece(outer);
                outer.setProperty("snapshot", ((PropertyExporter)((Object)outer)).getProperties());
                Command c = outer.keyEvent(this.stroke);
                if (this.target.getId() != null) {
                    GameModule.getGameModule().sendAndLog(c);
                }
                t.addPiece(outer);
                t.repaint();
            }
        }
    }

    public boolean isMenuSeparator() {
        return "<separator>".equals(this.name);
    }

    public String getLocalizedMenuText() {
        if (this.localizedMenuText == null && this.name != null) {
            String localizedName = this.name;
            if (this.i18nPiece != null && GameModule.getGameModule().isLocalizationEnabled()) {
                localizedName = this.i18nPiece.getI18nData().translate(this.name);
            }
            this.localizedMenuText = KeyCommand.makeMenuText(this.stroke, localizedName);
        }
        return this.localizedMenuText;
    }

    private static String makeMenuText(KeyStroke ks, String text) {
        return ((String)(ks != null && text != null && !text.isBlank() ? text + "  " + NamedHotKeyConfigurer.getString(ks) : (text == null ? "" : text))).intern();
    }
}

