/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class Pivot
extends Decorator
implements TranslatablePiece {
    public static final String ID = "pivot;";
    public static final String DEGREES = "_Degrees";
    protected int pivotX;
    protected int pivotY;
    protected double angle;
    protected String command;
    protected NamedKeyStroke key;
    protected boolean fixedAngle;
    protected KeyCommand[] commands;
    protected KeyCommand pivotCommand;
    protected FreeRotator rotator;
    protected String description;
    private static final double PI_180 = Math.PI / 180;

    public Pivot() {
        this(ID, null);
    }

    public Pivot(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Pivot.trait_description", this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Pivot.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Pivot.html");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.command = st.nextToken(Resources.getString("Editor.Pivot.default_pivot_command"));
        this.key = st.nextNamedKeyStroke(null);
        this.pivotX = st.nextInt(0);
        this.pivotY = st.nextInt(0);
        this.fixedAngle = st.nextBoolean(true);
        this.angle = st.nextDouble(90.0);
        this.description = st.nextToken("");
        this.commands = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.pivotCommand = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.command.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.pivotCommand} : KeyCommand.NONE;
            this.rotator = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
            this.pivotCommand.setEnabled(this.rotator != null);
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.command).append(this.key).append(this.pivotX).append(this.pivotY).append(this.fixedAngle).append(this.angle).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.pivotCommand.matches(stroke)) {
            if (this.fixedAngle) {
                ChangeTracker t = new ChangeTracker(this);
                double oldAngle = this.rotator.getAngle();
                Point oldPos = this.getPosition();
                Point piv = new Point(oldPos.x + this.pivotX, oldPos.y + this.pivotY);
                AffineTransform.getRotateInstance(-oldAngle * (Math.PI / 180), oldPos.x, oldPos.y).transform(piv, piv);
                this.rotator.setAngle(oldAngle - this.angle);
                double newAngle = this.rotator.getAngle();
                if (this.getMap() != null) {
                    c = Pivot.putOldProperties(this);
                    Point pos = this.getPosition();
                    this.pivotPoint(pos, -oldAngle * (Math.PI / 180), -newAngle * (Math.PI / 180));
                    GamePiece outer = Pivot.getOutermost(this);
                    if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                        pos = this.getMap().snapTo(pos);
                    }
                    outer.setProperty("Moved", Boolean.TRUE);
                    c = c.append(t.getChangeCommand());
                    MoveTracker moveTracker = new MoveTracker(outer);
                    this.getMap().placeOrMerge(outer, pos);
                    c = c.append(moveTracker.getMoveCommand());
                    MovementReporter r = new MovementReporter(c);
                    if (GlobalOptions.getInstance().autoReportEnabled()) {
                        Command reportCommand = r.getReportCommand();
                        if (reportCommand != null) {
                            reportCommand.execute();
                        }
                        c = c.append(reportCommand);
                    }
                    c = c.append(r.markMovedPieces());
                    c = this.rotator.rotateCargo(c, piv, newAngle - oldAngle);
                    this.getMap().ensureVisible(this.getMap().selectionBoundsOf(outer));
                } else {
                    c = t.getChangeCommand();
                }
            } else if (this.getMap() != null) {
                c = Pivot.putOldProperties(this);
                double oldAngle = this.rotator.getAngleInRadians();
                Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
                AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
                t.transform(pivot2D, pivot2D);
                this.rotator.beginInteractiveRotate();
                this.rotator.setPivot(this.getPosition().x + (int)Math.round(((Point2D)pivot2D).getX()), this.getPosition().y + (int)Math.round(((Point2D)pivot2D).getY()));
            }
        }
        if (c != null && this.getMap() != null && this.getMap().getMoveKey() != null) {
            c = c.append(Decorator.getOutermost(this).keyEvent(this.getMap().getMoveKey()));
        }
        return c;
    }

    private void pivotPoint(Point p, double oldAngle, double newAngle) {
        Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
        AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
        t.transform(pivot2D, pivot2D);
        t = AffineTransform.getRotateInstance(newAngle - oldAngle, ((Point2D)pivot2D).getX(), ((Point2D)pivot2D).getY());
        Point2D.Float newPos2D = new Point2D.Float(0.0f, 0.0f);
        t.transform(newPos2D, newPos2D);
        p.x += (int)Math.round(((Point2D)newPos2D).getX());
        p.y += (int)Math.round(((Point2D)newPos2D).getY());
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.Pivot.pivot_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Pivot)) {
            return false;
        }
        Pivot c = (Pivot)o;
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.pivotX, c.pivotX)) {
            return false;
        }
        if (!Objects.equals(this.pivotY, c.pivotY)) {
            return false;
        }
        if (!Objects.equals(this.fixedAngle, c.fixedAngle)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        return Objects.equals(this.angle, c.angle);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer command;
        private final NamedHotKeyConfigurer key;
        private final IntConfigurer xOff;
        private final IntConfigurer yOff;
        private final DoubleConfigurer angle;
        private final JLabel angleLabel;
        private final BooleanConfigurer fixedAngle;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer desc;

        public Ed(Pivot p) {
            this.desc = new StringConfigurer(p.description);
            this.desc.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.desc);
            this.command = new StringConfigurer(p.command);
            this.command.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.command);
            this.key = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.key);
            this.controls.add(new JLabel(Resources.getString("Editor.Pivot.pivot_point")));
            JPanel b = new JPanel((LayoutManager)new MigLayout("ins 0", "[]2[]2[]"));
            this.xOff = new IntConfigurer(p.pivotX);
            b.add(this.xOff.getControls());
            b.add(new JLabel(","));
            this.yOff = new IntConfigurer(p.pivotY);
            b.add(this.yOff.getControls());
            this.controls.add(b);
            this.fixedAngle = new BooleanConfigurer(p.fixedAngle);
            this.controls.add("Editor.Pivot.pivot_through_fixed_angle", (Configurer)this.fixedAngle);
            this.angleLabel = new JLabel(Resources.getString("Editor.Pivot.angle"));
            this.angle = new DoubleConfigurer(p.angle);
            this.controls.add(this.angleLabel);
            this.controls.add(this.angle.getControls());
            this.angle.getControls().setVisible(p.fixedAngle);
            this.fixedAngle.addPropertyChangeListener(evt -> {
                this.angle.getControls().setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.angleLabel.setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
            });
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.command.getValueString()).append(this.key.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(Boolean.TRUE.equals(this.fixedAngle.getValue())).append(this.angle.getValueString()).append(this.desc.getValueString());
            return Pivot.ID + se.getValue();
        }
    }
}

