/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentPathDialog;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.property.PersistentPropertyContainer;
import VASSAL.search.ImageSearchTarget;
import VASSAL.tools.ComponentPathBuilder;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class PlaceMarker
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "placemark;";
    protected KeyCommand command;
    protected NamedKeyStroke key;
    protected String markerSpec;
    protected String markerText = "";
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected boolean matchRotation = false;
    protected KeyCommand[] commands;
    protected NamedKeyStroke afterBurnerKey;
    protected String description = "";
    protected String gpId = "";
    protected String newGpId;
    protected GpIdSupport gpidSupport;
    protected static final int STACK_TOP = 0;
    protected static final int STACK_BOTTOM = 1;
    protected static final int ABOVE = 2;
    protected static final int BELOW = 3;
    protected int placement = 0;
    protected boolean above;

    public PlaceMarker() {
        this(ID + Resources.getString("Editor.PlaceMarker.default_command") + ";M;null;null;null", null);
    }

    public PlaceMarker(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        this.command.setEnabled(this.getMap() != null && this.markerSpec != null);
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.command.getName()).append(this.key).append(this.markerSpec == null ? "null" : this.markerSpec).append(this.markerText == null ? "null" : this.markerText).append(this.xOffset).append(this.yOffset).append(this.matchRotation).append(this.afterBurnerKey).append(this.description).append(this.gpId).append(this.placement).append(this.above);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.command.matches(stroke)) {
            return this.placeMarker();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command placeMarker() {
        String location;
        MatCargo cargo;
        Command c;
        Map m = this.getMap();
        if (m == null) {
            return null;
        }
        GamePiece marker = this.createMarker();
        if (marker == null) {
            return null;
        }
        GamePiece outer = PlaceMarker.getOutermost(this);
        Point p = this.getPosition();
        p.translate(this.xOffset, -this.yOffset);
        if (this.matchRotation) {
            FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(outer, FreeRotator.class);
            FreeRotator markerRotation = (FreeRotator)Decorator.getDecorator(marker, FreeRotator.class);
            if (myRotation != null && markerRotation != null) {
                markerRotation.setAngle(myRotation.getAngle());
                Point myPosition = this.getPosition().getLocation();
                Point2D markerPosition = p.getLocation();
                markerPosition = AffineTransform.getRotateInstance(myRotation.getAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform(markerPosition, null);
                p = new Point((int)markerPosition.getX(), (int)markerPosition.getY());
            }
        }
        if (!Boolean.TRUE.equals(marker.getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        if (m.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(marker.getProperty("NoStack")) && !Boolean.TRUE.equals(outer.getProperty("NoStack")) && m.getPieceCollection().canMerge(outer, marker)) {
            GamePiece target = outer;
            int index = -1;
            Stack parent = this.getParent();
            if (parent == null) {
                if (this.placement == 1 || this.placement == 3) {
                    index = 0;
                }
            } else {
                switch (this.placement) {
                    case 0: {
                        target = parent;
                        break;
                    }
                    case 1: {
                        index = 0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        index = parent.indexOf(outer);
                    }
                }
            }
            c = m.getStackMetrics().merge(target, marker);
            if (index >= 0) {
                if (parent == null) {
                    parent = target.getParent();
                }
                ChangeTracker ct = new ChangeTracker(parent);
                parent.insert(marker, index);
                c = c.append(ct.getChangeCommand());
            }
            m.repaint();
        } else if (m.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(marker.getProperty("NoStack"))) {
            c = m.placeOrMerge(marker, p);
            Stack parent = marker.getParent();
            if (parent != null && parent.pieceCount > 1 && (this.placement == 1 || this.placement == 3)) {
                ChangeTracker ct = new ChangeTracker(parent);
                parent.insert(marker, 0);
                c = c.append(ct.getChangeCommand());
            }
        } else {
            c = m.placeAt(marker, p);
        }
        if (c != null && GameModule.getGameModule().isMatSupport() && Boolean.TRUE.equals(marker.getProperty("IsCargo")) && (cargo = (MatCargo)Decorator.getDecorator(marker, MatCargo.class)) != null) {
            c = c.append(cargo.findNewMat());
            GamePiece mat = cargo.getMat();
            if (mat != null) {
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMat", mat.getProperty("MatName")));
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMatID", mat.getProperty("MatID")));
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMatPieceName", PlaceMarker.getOutermost(mat).getProperty("PieceName")));
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMatBasicName", PlaceMarker.getOutermost(mat).getProperty("BasicName")));
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMatOffsetX", String.valueOf(cargo.getProperty("CurrentMatOffsetX"))));
                c = c.append(((PersistentPropertyContainer)((Object)marker)).setPersistentProperty("OldMatOffsetY", String.valueOf(cargo.getProperty("CurrentMatOffsetY"))));
                if (mat.getProperty("Selected") == Boolean.TRUE) {
                    KeyBuffer.getBuffer().add(marker);
                }
            }
        }
        if (this.afterBurnerKey != null && !this.afterBurnerKey.isNull()) {
            marker.setProperty("snapshot", ((PropertyExporter)((Object)marker)).getProperties());
            try {
                RecursionLimiter.startExecution(this);
                c.append(marker.keyEvent(this.afterBurnerKey.getKeyStroke()));
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            finally {
                RecursionLimiter.endExecution();
            }
        }
        if (this.getProperty("Selected") == Boolean.TRUE) {
            this.selectMarker(marker);
        }
        if (this.markerText != null && Stream.of("ObscuredToOthers", "Obscured", "InvisibleToOthers").noneMatch(s -> Boolean.TRUE.equals(outer.getProperty(s))) && (location = m.locationName(this.getPosition())) != null) {
            Chatter.DisplayText display = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " * " + location + ":  " + outer.getName() + " " + this.markerText + " * ");
            display.execute();
            c = c == null ? display : c.append(display);
        }
        return c;
    }

    protected void selectMarker(GamePiece marker) {
        if (marker.getProperty("selectEventFilter") == null && marker.getParent() != null && marker.getParent().equals(this.getParent())) {
            KeyBuffer.getBuffer().add(marker);
        }
    }

    public GamePiece createMarker() {
        GamePiece piece = this.createBaseMarker();
        if (piece == null) {
            piece = new BasicPiece();
            this.newGpId = this.getGpId();
        } else {
            piece = PieceCloner.getInstance().clonePiece(piece);
        }
        piece.setProperty("PieceId", this.newGpId);
        return piece;
    }

    public GamePiece createBaseMarker() {
        if (this.markerSpec == null) {
            return null;
        }
        GamePiece piece = null;
        if (this.isMarkerStandalone()) {
            AddPiece comm = (AddPiece)GameModule.getGameModule().decode(this.markerSpec);
            piece = comm.getTarget();
            piece.setState(comm.getState());
            this.newGpId = this.getGpId();
        } else {
            try {
                Configurable[] c = ComponentPathBuilder.getInstance().getPath(this.markerSpec);
                Configurable conf = c[c.length - 1];
                if (conf instanceof PieceSlot) {
                    piece = ((PieceSlot)conf).getPiece();
                    this.newGpId = ((PieceSlot)conf).getGpId();
                }
            }
            catch (ComponentPathBuilder.PathFormatException e) {
                PlaceMarker.reportDataError(this, Resources.getString("Error.place_error"), e.getMessage() + " markerSpec=" + this.markerSpec, e);
            }
        }
        return piece;
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        GamePiece p;
        super.addImageNamesRecursively(s);
        if (this.isMarkerStandalone() && (p = this.createBaseMarker()) instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)p)).addImageNamesRecursively(s);
        }
    }

    public boolean isMarkerStandalone() {
        return this.markerSpec != null && this.markerSpec.startsWith("+/");
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.PlaceMarker.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.command.getName(), this.key);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.PlaceMarker.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Marker.html");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String name = st.nextToken();
        this.key = st.nextNamedKeyStroke(null);
        this.command = new KeyCommand(name, this.key, (GamePiece)this, (TranslatablePiece)this);
        this.commands = name.length() > 0 && this.key != null ? new KeyCommand[]{this.command} : KeyCommand.NONE;
        this.markerSpec = st.nextToken();
        if ("null".equals(this.markerSpec)) {
            this.markerSpec = null;
        }
        this.markerText = st.nextToken("null");
        if ("null".equals(this.markerText)) {
            this.markerText = null;
        }
        this.xOffset = st.nextInt(0);
        this.yOffset = st.nextInt(0);
        this.matchRotation = st.nextBoolean(false);
        this.afterBurnerKey = st.nextNamedKeyStroke(null);
        this.description = st.nextToken("");
        this.setGpId(st.nextToken(""));
        this.placement = st.nextInt(0);
        this.above = st.nextBoolean(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command.getName(), this.getCommandDescription(this.description, Resources.getString("Editor.PlaceMarker.place_marker_command")));
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String s) {
        this.gpId = s;
    }

    public void updateGpId(GpIdSupport s) {
        this.gpidSupport = s;
        this.updateGpId();
    }

    public void updateGpId() {
        this.setGpId(this.gpidSupport.generateGpId());
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof PlaceMarker)) {
            return false;
        }
        PlaceMarker c = (PlaceMarker)o;
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.markerSpec, c.markerSpec)) {
            return false;
        }
        if (!Objects.equals(this.markerText, c.markerText)) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        if (!Objects.equals(this.matchRotation, c.matchRotation)) {
            return false;
        }
        if (!Objects.equals(this.afterBurnerKey, c.afterBurnerKey)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.gpId, c.gpId)) {
            return false;
        }
        if (!Objects.equals(this.placement, c.placement)) {
            return false;
        }
        return Objects.equals(this.above, c.above);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key, this.afterBurnerKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command.getName());
    }

    protected static class Ed
    implements PieceEditor {
        private final NamedHotKeyConfigurer keyInput;
        private final StringConfigurer commandInput;
        private final PieceSlot pieceInput;
        private final TraitConfigPanel p;
        private String markerSlotPath;
        protected JButton defineButton = new JButton(Resources.getString("Editor.PlaceMarker.define_marker"));
        protected JButton selectButton = new JButton(Resources.getString("Editor.select"));
        protected IntConfigurer xOffsetConfig;
        protected IntConfigurer yOffsetConfig;
        protected BooleanConfigurer matchRotationConfig;
        protected BooleanConfigurer aboveConfig;
        private JLabel aboveLabel;
        protected TranslatingStringEnumConfigurer placementConfig;
        protected NamedHotKeyConfigurer afterBurner;
        protected StringConfigurer descConfig;
        private final String slotId;
        private final JPanel visPanel;

        protected Ed(PlaceMarker piece) {
            GamePiece marker = piece.createBaseMarker();
            this.markerSlotPath = piece.markerSpec;
            this.p = new TraitConfigPanel();
            this.descConfig = new StringConfigurer(piece.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.p.add("Editor.description_label", (Configurer)this.descConfig);
            this.commandInput = new StringConfigurer(piece.command.getName());
            this.commandInput.setHintKey("Editor.menu_command_hint");
            this.p.add("Editor.menu_command", (Configurer)this.commandInput);
            this.keyInput = new NamedHotKeyConfigurer(piece.key);
            this.p.add("Editor.keyboard_command", (Configurer)this.keyInput);
            JPanel b = new JPanel((LayoutManager)new MigLayout("ins 0", "[][][]"));
            this.visPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "[grow]"));
            this.pieceInput = new PieceSlot(marker);
            this.pieceInput.setGpidSupport(piece.gpidSupport);
            this.pieceInput.setGpId(piece.getGpId());
            this.visPanel.add(this.pieceInput.getComponent(), "grow");
            b.add(this.visPanel);
            this.defineButton.addActionListener(e -> {
                this.markerSlotPath = null;
                new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.p), true, this.pieceInput, null).setVisible(true);
                this.adjustVisualiserSize();
            });
            b.add(this.defineButton);
            this.adjustVisualiserSize();
            this.selectButton.addActionListener(e -> {
                ChoosePieceDialog d = new ChoosePieceDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.p), PieceSlot.class);
                d.setVisible(true);
                if (d.getTarget() instanceof PieceSlot) {
                    this.pieceInput.setPiece(((PieceSlot)d.getTarget()).getPiece());
                    this.adjustVisualiserSize();
                }
                this.markerSlotPath = d.getPath() != null ? ComponentPathBuilder.getInstance().getId(d.getPath()) : null;
            });
            b.add(this.selectButton);
            this.p.add("Editor.Placemarker.marker_definition", b);
            this.xOffsetConfig = new IntConfigurer(piece.xOffset);
            this.p.add("Editor.PlaceMarker.horizontal_offset", (Configurer)this.xOffsetConfig);
            this.yOffsetConfig = new IntConfigurer(piece.yOffset);
            this.p.add("Editor.PlaceMarker.vertical_offset", (Configurer)this.yOffsetConfig);
            this.matchRotationConfig = this.createMatchRotationConfig();
            this.matchRotationConfig.setValue(piece.matchRotation);
            JLabel matchLabel = new JLabel(this.matchRotationConfig.getName());
            this.matchRotationConfig.setName("");
            this.p.add(matchLabel, (Configurer)this.matchRotationConfig);
            this.aboveConfig = this.createAboveConfig();
            if (this.aboveConfig != null) {
                this.aboveConfig.setValue(piece.above);
                this.aboveLabel = new JLabel(this.aboveConfig.getName());
                this.aboveConfig.setName("");
                this.p.add(this.aboveLabel, (Configurer)this.aboveConfig);
                this.aboveConfig.getControls().setVisible(piece.matchRotation);
                this.aboveLabel.setVisible(piece.matchRotation);
                this.matchRotationConfig.addPropertyChangeListener(e -> {
                    this.aboveConfig.getControls().setVisible(this.matchRotationConfig.getValueBoolean());
                    this.aboveLabel.setVisible(this.matchRotationConfig.getValueBoolean());
                });
            }
            this.placementConfig = new TranslatingStringEnumConfigurer(new String[]{"0", "1", "2", "3"}, new String[]{"Editor.Placemarker.on_top_of_stack", "Editor.Placemarker.on_bottom_of_stack", "Editor.Placemarker.above_this_piece", "Editor.Placemarker.below_this_piece"}, String.valueOf(piece.placement));
            this.p.add("Editor.PlaceMarker.place_marker", (Configurer)this.placementConfig);
            this.afterBurner = new NamedHotKeyConfigurer(piece.afterBurnerKey);
            this.p.add("Editor.PlaceMarker.keystroke.after.placement", (Configurer)this.afterBurner);
            this.slotId = piece.getGpId();
        }

        private void adjustVisualiserSize() {
            if (this.pieceInput.getPiece() == null) {
                int s = (int)this.defineButton.getPreferredSize().getHeight();
                this.visPanel.setMinimumSize(new Dimension(s * 2, s));
            } else {
                this.visPanel.setMinimumSize(this.pieceInput.getPreferredSize());
            }
            Decorator.repack(this.visPanel);
        }

        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.PlaceMarker.match_rotation"));
        }

        protected BooleanConfigurer createAboveConfig() {
            return null;
        }

        @Override
        public Component getControls() {
            return this.p;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.commandInput.getValueString());
            se.append(this.keyInput.getValueString());
            if (this.pieceInput.getPiece() == null) {
                se.append("null");
            } else if (this.markerSlotPath != null) {
                se.append(this.markerSlotPath);
            } else {
                String spec = GameModule.getGameModule().encode(new AddPiece(this.pieceInput.getPiece()));
                se.append(spec);
            }
            se.append("null");
            se.append(this.xOffsetConfig.getValueString());
            se.append(this.yOffsetConfig.getValueString());
            se.append(this.matchRotationConfig.getValueString());
            se.append(this.afterBurner.getValueString());
            se.append(this.descConfig.getValueString());
            se.append(this.slotId);
            se.append(this.placementConfig.getSelectedIndex());
            se.append(this.aboveConfig == null ? "false" : this.aboveConfig.getValueString());
            return PlaceMarker.ID + se.getValue();
        }

        public static class ChoosePieceDialog
        extends ChooseComponentPathDialog {
            private static final long serialVersionUID = 1L;

            public ChoosePieceDialog(Frame owner, Class<PieceSlot> targetClass) {
                super(owner, targetClass);
            }

            @Override
            protected boolean isValidTarget(Object selected) {
                return super.isValidTarget(selected) || selected instanceof CardSlot;
            }
        }
    }
}

