/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.i18n.Resources;
import VASSAL.launch.ExtensionEditorWindow;
import VASSAL.launch.LoadModuleAction;
import VASSAL.launch.PlayerWindow;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

public class EditExtensionAction
extends LoadModuleAction {
    private static final long serialVersionUID = 1L;

    public EditExtensionAction(Component comp) {
        super(comp);
        this.putValue("Name", Resources.getString("Editor.edit_extension"));
    }

    public EditExtensionAction(File extFile) {
        super(extFile);
        this.putValue("Name", Resources.getString("Editor.edit_extension"));
    }

    @Override
    protected void loadModule(File f) throws IOException {
        ModuleExtension ext = new ModuleExtension(new ArchiveWriter(new ZipArchive(f), ".vmdx"));
        ext.build();
        PlayerWindow frame = GameModule.getGameModule().getPlayerWindow();
        ExtensionEditorWindow w = new ExtensionEditorWindow(GameModule.getGameModule(), ext);
        w.setLocation(0, frame.getY() + frame.getHeight());
        w.setSize(SwingUtils.getScreenBounds((Component)frame).width / 2, w.getHeight());
        w.setVisible(true);
    }
}

