/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.launch.Editor;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.Player;

public final class LaunchRequestHandler
implements Runnable {
    private final LaunchRequest lr;
    private String result;

    public LaunchRequestHandler(LaunchRequest lr) {
        this.lr = lr;
    }

    @Override
    public void run() {
        this.result = this.handle();
    }

    public String getResult() {
        return this.result;
    }

    private String handle() {
        ModuleManagerWindow window = ModuleManagerWindow.getInstance();
        switch (this.lr.mode) {
            case MANAGE: {
                window.toFront();
                break;
            }
            case LOAD: {
                AbstractMetaData data;
                if (Player.LaunchAction.isEditing(this.lr.module)) {
                    return "module open for editing";
                }
                if (this.lr.module == null && this.lr.game != null && (data = MetaDataFactory.buildMetaData(this.lr.game)) instanceof SaveMetaData) {
                    String moduleName = ((SaveMetaData)data).getModuleName();
                    if (moduleName != null && moduleName.length() > 0) {
                        this.lr.module = window.getModuleByName(moduleName);
                    } else {
                        return "cannot find module";
                    }
                }
                if (this.lr.module == null) {
                    return "cannot find module";
                }
                if (this.lr.game == null) {
                    new Player.LaunchAction(window, this.lr.module).actionPerformed(null);
                    break;
                }
                new Player.LaunchAction(window, this.lr.module, this.lr.game).actionPerformed(null);
                break;
            }
            case EDIT: {
                if (Editor.LaunchAction.isInUse(this.lr.module)) {
                    return "module open for play";
                }
                if (Editor.LaunchAction.isEditing(this.lr.module)) {
                    return "module open for editing";
                }
                new Editor.LaunchAction(window, this.lr.module).actionPerformed(null);
                break;
            }
            case IMPORT: {
                new Editor.ImportLaunchAction(window, this.lr.importFile).actionPerformed(null);
                break;
            }
            case NEW: {
                new Editor.NewModuleLaunchAction(window).actionPerformed(null);
                break;
            }
            case EDIT_EXT: {
                return "not yet implemented";
            }
            case NEW_EXT: {
                return "not yet implemented";
            }
            case UPDATE_MOD: {
                window.updateRequest(this.lr.module);
                break;
            }
            case UPDATE_EXT: {
                window.updateRequest(this.lr.extension);
                break;
            }
            case UPDATE_GAME: {
                window.updateRequest(this.lr.game);
                break;
            }
            default: {
                return "unrecognized mode";
            }
        }
        return null;
    }
}

