/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.ShutDownAction;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.DebugControls;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.WrapLayout;
import VASSAL.tools.menu.CheckBoxMenuItemProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.commons.lang3.SystemUtils;

public class PlayerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected final JToolBar toolBar = new JToolBar();
    protected final JPanel controlPanel = new JPanel();

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public PlayerWindow() {
        this.setTitle(Resources.getString("General.VASSAL"));
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        ApplicationIcons.setFor(this);
        this.setupMenubarAndActions();
        this.buildToolbar();
        this.buildCentralArea();
        this.pack();
    }

    private void setupMenubarAndActions() {
        URL url;
        MenuManager mm = MenuManager.getInstance();
        MenuBarProxy mb = mm.getMenuBarProxyFor(this);
        MenuProxy fileMenu = new MenuProxy(Resources.getString("General.file"));
        fileMenu.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
        fileMenu.add(mm.addMarker("PredefinedSetup.start"));
        fileMenu.add(mm.addMarker("PredefinedSetup.end"));
        fileMenu.add(mm.addKey("GameState.new_game"));
        fileMenu.add(mm.addKey("GameState.load_game_new"));
        fileMenu.add(mm.addKey("GameState.load_game_old"));
        fileMenu.add(mm.addKey("GameState.save_game"));
        fileMenu.add(mm.addKey("GameState.save_game_as"));
        fileMenu.add(mm.addKey("GameState.close_game"));
        fileMenu.addSeparator();
        fileMenu.add(mm.addKey("BasicLogger.begin_logfile"));
        fileMenu.add(mm.addKey("BasicLogger.end_logfile"));
        if (SystemUtils.IS_OS_MAC) {
            fileMenu.add(mm.addMarker("Editor.File.start"));
            fileMenu.add(mm.addMarker("Editor.File.end"));
        } else {
            fileMenu.addSeparator();
            fileMenu.add(mm.addKey("Prefs.edit_preferences"));
            fileMenu.addSeparator();
            fileMenu.add(mm.addKey("General.quit"));
        }
        mm.addAction("General.quit", new ShutDownAction());
        MenuProxy helpMenu = new MenuProxy(Resources.getString("General.help"));
        helpMenu.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
        helpMenu.add(mm.addMarker("Documentation.VASSAL.start"));
        helpMenu.add(mm.addKey("General.help"));
        helpMenu.add(mm.addKey("Help.user_guide"));
        helpMenu.add(mm.addMarker("Documentation.VASSAL.end"));
        helpMenu.addSeparator();
        helpMenu.add(mm.addMarker("Documentation.Module.start"));
        helpMenu.add(mm.addMarker("Documentation.Module.end"));
        helpMenu.add(mm.addKey("Documentation.about_module"));
        if (!SystemUtils.IS_OS_MAC) {
            helpMenu.add(mm.addKey("AboutScreen.about_vassal"));
        }
        MenuProxy toolsMenu = new MenuProxy(Resources.getString("General.tools"));
        toolsMenu.setMnemonic(Resources.getString("General.tools.shortcut").charAt(0));
        toolsMenu.add(mm.addKey("GameRefresher.refresh_counters"));
        toolsMenu.add(mm.addKey("GameState.load_continuation"));
        toolsMenu.addSeparator();
        toolsMenu.add(mm.addKey("GameState.load_and_fast_forward"));
        toolsMenu.add(mm.addKey("GameState.load_and_append"));
        toolsMenu.addSeparator();
        CheckBoxMenuItemProxy debugCheckbox = new CheckBoxMenuItemProxy(new AbstractAction(Resources.getString("Debug.show_debug_window")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugControls dc = GameModule.getGameModule().getDebugControls();
                if (dc != null) {
                    dc.toggleVisible();
                }
            }
        }, false);
        toolsMenu.add(debugCheckbox);
        DebugControls.setCheckBox(debugCheckbox);
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "README.html").toURI().toURL();
            mm.addAction("General.help", new ShowHelpAction(url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "userguide/userguide.pdf").toURI().toURL();
            mm.addAction("Help.user_guide", new ShowHelpAction("Help.user_guide", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        mm.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        mb.add(fileMenu);
        mb.add(toolsMenu);
        mb.add(mm.addMarker("Editor.MenuBar.start"));
        mb.add(mm.addMarker("Editor.MenuBar.end"));
        mb.add(helpMenu);
        this.setJMenuBar(mm.getMenuBarFor(this));
    }

    private void buildToolbar() {
        this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
    }

    private void buildCentralArea() {
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.controlPanel, "Center");
    }

    public void addChatter(Chatter chatter) {
        this.controlPanel.add((Component)chatter, "Center");
    }
}

