/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.PrefsEditor;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPrefs
extends Prefs {
    private boolean disableAutoWrite = false;
    private static final Logger log = LoggerFactory.getLogger(GameModule.class);

    public GlobalPrefs(PrefsEditor editor, String name) {
        super(editor, new File(Info.getPrefsDir(), GlobalPrefs.sanitize(name)));
    }

    public GlobalPrefs(PrefsEditor editor, File file) {
        super(editor, file);
    }

    @Override
    public boolean isDisableAutoWrite() {
        return this.disableAutoWrite;
    }

    @Override
    public void setDisableAutoWrite(boolean b) {
        this.disableAutoWrite = b;
    }

    public void saveGlobal() {
        block2: {
            try {
                this.save();
            }
            catch (IOException e) {
                log.error(Resources.getString("GlobalPrefs.failed_to_write"), (Throwable)e);
                GameModule gm = GameModule.getGameModule();
                if (gm == null) break block2;
                gm.warn(Resources.getString("GlobalPrefs.failed_to_write"));
            }
        }
    }

    @Override
    public void addOption(String category, Configurer o, String prompt) {
        super.addOption(category, o, prompt);
        o.addPropertyChangeListener(evt -> {
            if (!this.isDisableAutoWrite()) {
                this.saveGlobal();
            }
        });
    }
}

