/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.properties.PropertySource;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.tools.SequenceEncoder;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class FormattedStringExpression
extends Expression {
    public FormattedStringExpression(String s) {
        super(s);
    }

    @Override
    @Deprecated(since="2021-06-11")
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) {
        return this.evaluate(ps, properties, localized, null, null);
    }

    @Override
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) {
        StringBuilder buffer = new StringBuilder();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(this.getExpression(), '$');
        boolean isProperty = true;
        while (st.hasMoreTokens()) {
            Object value;
            String token = st.nextToken();
            boolean bl = isProperty = !isProperty;
            if (token.length() <= 0) continue;
            if (!isProperty || !st.hasMoreTokens()) {
                buffer.append(token);
                continue;
            }
            if (properties != null && properties.containsKey(token)) {
                value = properties.get(token);
                if (audit != null) {
                    audit.addMessage("$" + token + "$=" + (String)value);
                }
                if (value == null) continue;
                buffer.append((String)value);
                continue;
            }
            if (ps != null) {
                Object object = value = localized ? ps.getLocalizedProperty(token) : ps.getProperty(token);
                if (audit != null) {
                    audit.addMessage("$" + token + "$=" + value);
                }
                if (value != null) {
                    buffer.append(value);
                    continue;
                }
                if (localized) continue;
                buffer.append(token);
                continue;
            }
            buffer.append(token);
        }
        if (audit != null) {
            audit.addMessage(Resources.getString("Audit.updated_expression", buffer.toString()));
        }
        return buffer.toString();
    }

    @Override
    public String toBeanShellString() {
        String s = this.getExpression();
        try {
            Integer.parseInt(s);
            return s;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder buffer = new StringBuilder();
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '$');
            boolean isProperty = true;
            boolean first = true;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                boolean bl = isProperty = !isProperty;
                if (token.length() <= 0) continue;
                if (!first) {
                    buffer.append('+');
                }
                if (isProperty && st.hasMoreTokens()) {
                    buffer.append(BeanShellExpression.convertProperty(token));
                } else {
                    buffer.append('\"');
                    buffer.append(token);
                    buffer.append('\"');
                }
                first = false;
            }
            return buffer.toString();
        }
    }

    public static Expression instance(String s) {
        return CACHE.computeIfAbsent(Pair.of((Object)s, FormattedStringExpression.class), k -> new FormattedStringExpression(s));
    }
}

