/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.menu.CheckBoxMenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SplitPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public class DebugControls
extends AbstractBuildable
implements ActionListener {
    protected static final long MEGABYTE = 0x100000L;
    protected JButton launch;
    protected JPanel controlPanel;
    protected SplitPane splitPane;
    protected Point cursorLocation;
    protected JLabel cursorCoordsLabel;
    protected FlowLabel selectedNameLabel;
    protected JLabel selectedCoordsLabel;
    protected Timer timer = new Timer(100, this);
    private static CheckBoxMenuItemProxy checkbox;

    public static void setCheckBox(CheckBoxMenuItemProxy c) {
        checkbox = c;
    }

    public Point getCursorLocation() {
        return this.cursorLocation;
    }

    public void setCursorLocation(Point pt) {
        this.cursorLocation = pt;
        this.updateCoords();
        this.updateSelected();
    }

    public DebugControls() {
        JSplitPane split = new JSplitPane(1);
        split.setResizeWeight(0.1);
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("fill, nogrid, hidemode 3"));
        leftPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Debug.component_type")));
        Box leftBox = Box.createVerticalBox();
        Box cursorBox = Box.createVerticalBox();
        this.cursorCoordsLabel = new JLabel("");
        cursorBox.add(this.cursorCoordsLabel);
        Box selectedBox = Box.createVerticalBox();
        this.selectedNameLabel = new FlowLabel("");
        this.selectedCoordsLabel = new JLabel("");
        selectedBox.add(this.selectedNameLabel);
        selectedBox.add(this.selectedCoordsLabel);
        leftBox.add(cursorBox);
        leftBox.add(Box.createVerticalStrut(10));
        leftBox.add(selectedBox);
        leftPanel.add(leftBox);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add("Center", leftPanel);
        this.timer.addActionListener(this);
    }

    private void updateCoords() {
        this.cursorCoordsLabel.setText(Resources.getString("Debug.cursor", this.cursorLocation.x, this.cursorLocation.y));
    }

    private void updateSelected() {
        List<GamePiece> selected = KeyBuffer.getBuffer().asList();
        if (selected.isEmpty()) {
            this.selectedNameLabel.setText("");
            this.selectedCoordsLabel.setText("");
            return;
        }
        GamePiece piece = selected.get(0);
        this.selectedNameLabel.setText(piece.getName());
        this.selectedCoordsLabel.setText(piece.getPosition().x + "," + piece.getPosition().y);
    }

    private void updateHeap() {
    }

    @Override
    public void addTo(Buildable b) {
        GameModule gm = GameModule.getGameModule();
        this.launch = new JButton(Resources.getString("Debug.debug_controls"));
        this.launch.setFocusable(false);
        this.launch.setAlignmentY(0.0f);
        ActionListener al = evt -> this.toggleVisible();
        this.launch.addActionListener(al);
        NamedKeyStrokeListener l = new NamedKeyStrokeListener(al);
        URL iconURL = this.getClass().getResource("/images/connect.gif");
        if (iconURL != null) {
            this.launch.setIcon(new ImageIcon(iconURL));
            this.launch.setText(null);
        }
        IconConfigurer iconConfig = new IconConfigurer("debugControlsIcon", Resources.getString("Debug.debug_controls_button_icon"), "");
        iconConfig.setValue("");
        GlobalOptions.getInstance().addOption(iconConfig);
        iconConfig.addPropertyChangeListener(evt -> {
            this.launch.setIcon(iconConfig.getIconValue());
            this.launch.setText(this.launch.getIcon() == null ? " " : null);
            this.launch.setVisible(this.launch.getIcon() != null);
        });
        iconConfig.fireUpdate();
        NamedHotKeyConfigurer keyConfig = new NamedHotKeyConfigurer("debugControlsHotKey", Resources.getString("Debug.debug_controls_hotkey"), l.getNamedKeyStroke());
        GlobalOptions.getInstance().addOption(keyConfig);
        keyConfig.addPropertyChangeListener(evt -> {
            l.setKeyStroke(keyConfig.getValueNamedKeyStroke());
            this.launch.setToolTipText(Resources.getString("Debug.debug_controls_tooltip", NamedHotKeyConfigurer.getString(l.getKeyStroke())));
        });
        keyConfig.fireUpdate();
        gm.addKeyStrokeListener(l);
        gm.getToolBar().add(this.launch);
        this.launch.setText(this.launch.getIcon() == null ? " " : null);
        this.launch.setVisible(this.launch.getIcon() != null);
        if (checkbox != null) {
            checkbox.setSelected(this.isVisible());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.timer) {
            this.updateHeap();
            this.updateSelected();
        }
    }

    public boolean isVisible() {
        return this.splitPane != null ? this.splitPane.isRightVisible() : this.controlPanel != null && this.controlPanel.getTopLevelAncestor() != null && this.controlPanel.getTopLevelAncestor().isVisible();
    }

    private void updateVisible() {
        boolean visible;
        boolean bl = visible = this.splitPane != null ? this.splitPane.isRightVisible() : this.controlPanel.getTopLevelAncestor().isVisible();
        if (checkbox != null) {
            checkbox.setSelected(visible);
        }
        if (visible) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public void toggleVisible() {
        if (this.controlPanel.getTopLevelAncestor() == null) {
            if (GlobalOptions.getInstance().isUseSingleWindow()) {
                JComponent gmcp = GameModule.getGameModule().getControlPanel();
                Container gmcppar = gmcp.getParent();
                int i = SwingUtils.getIndexInParent(gmcp, gmcppar);
                this.splitPane = new SplitPane(1, gmcp, this.controlPanel);
                this.splitPane.setResizeWeight(1.0);
                gmcppar.add((Component)this.splitPane, i);
            } else {
                JFrame frame = new JFrame(Resources.getString("Debug.debug_controls"));
                frame.setDefaultCloseOperation(1);
                frame.add(this.controlPanel);
                frame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(frame));
                String key = "BoundsOfClientWindow";
                VisibilityOption pos = new VisibilityOption("BoundsOfClientWindow", frame);
                GameModule.getGameModule().getPrefs().addOption(pos);
                frame.setVisible(true);
            }
        } else if (this.splitPane != null) {
            this.splitPane.toggleRight();
        } else {
            this.controlPanel.getTopLevelAncestor().setVisible(!this.controlPanel.getTopLevelAncestor().isVisible());
        }
        this.updateVisible();
    }

    public JPanel getControls() {
        return this.controlPanel;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public String getAttributeValueString(String name) {
        return null;
    }
}

