/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;

    public ScrollPane() {
        this(null, 20, 30);
    }

    public ScrollPane(Component view) {
        this(view, 20, 30);
    }

    public ScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public ScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        MouseWheelListener[] listeners;
        for (MouseWheelListener value : listeners = this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(value);
        }
        for (MouseWheelListener wheelListener : listeners = this.viewport.getMouseWheelListeners()) {
            this.viewport.removeMouseWheelListener(wheelListener);
        }
        for (MouseWheelListener mouseWheelListener : listeners = this.verticalScrollBar.getMouseWheelListeners()) {
            this.verticalScrollBar.removeMouseWheelListener(mouseWheelListener);
        }
        for (MouseWheelListener listener : listeners = this.horizontalScrollBar.getMouseWheelListeners()) {
            this.horizontalScrollBar.removeMouseWheelListener(listener);
        }
        this.viewport.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0 && !e.isAltDown() && !SwingUtils.isSelectionToggle(e)) {
                JScrollBar bar;
                JScrollBar jScrollBar = bar = e.isShiftDown() ? this.horizontalScrollBar : this.verticalScrollBar;
                if (bar == null || !bar.isVisible()) {
                    return;
                }
                bar.setValue(bar.getValue() + e.getUnitsToScroll() * bar.getUnitIncrement());
            }
        });
        this.verticalScrollBar.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0) {
                this.verticalScrollBar.setValue(this.verticalScrollBar.getValue() + e.getUnitsToScroll() * this.verticalScrollBar.getUnitIncrement());
            }
        });
        this.horizontalScrollBar.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0) {
                this.horizontalScrollBar.setValue(this.horizontalScrollBar.getValue() + e.getUnitsToScroll() * this.horizontalScrollBar.getUnitIncrement());
            }
        });
    }
}

