/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.icon;

import VASSAL.build.IllegalBuildException;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.JarArchive;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.icon.IconFamily;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconFactory {
    private static final Logger logger = LoggerFactory.getLogger(IconFactory.class);
    static final String FILE = "file:";
    static final String JAR = "jar:";
    private static final JarArchive jar = new JarArchive();
    private static IconFactory instance = new IconFactory();
    private final Map<String, IconFamily> iconFamilies = new ConcurrentHashMap<String, IconFamily>();
    private static final Object preloadLock = new Object();
    private final Thread preloadThread = new Thread(() -> {
        Object object = preloadLock;
        synchronized (object) {
            try {
                this.initVassalIconFamilys();
            }
            catch (IllegalBuildException e) {
                ErrorDialog.bug(e);
            }
        }
    }, "IconFactory-preload");

    static void setInstance(IconFactory i) {
        instance = i;
    }

    static IconFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("No IconFactory instance");
        }
        return instance;
    }

    public IconFactory() {
        this.preloadThread.start();
    }

    public static Icon getIcon(String iconFamilyName, int size) {
        IconFamily family = IconFactory.getInstance().getFamily(iconFamilyName);
        if (family == null) {
            throw new IllegalStateException(Resources.getString("Error.not_found", IconFamily.getConfigureTypeName() + " " + iconFamilyName));
        }
        return family.getIcon(size);
    }

    public static BufferedImage getImage(String iconFamilyName, int size) {
        IconFamily family = IconFactory.getInstance().getFamily(iconFamilyName);
        if (family == null) {
            throw new IllegalStateException(Resources.getString("Error.not_found", IconFamily.getConfigureTypeName() + " " + iconFamilyName));
        }
        return family.getImage(size);
    }

    public static List<String> getIconFamilyNames() {
        return IconFactory.getInstance().getIconFamilyList();
    }

    public static void addIconFamily(IconFamily family) {
        IconFactory.getInstance().add(family);
    }

    public static void removeIconFamily(IconFamily family) {
        IconFactory.getInstance().remove(family);
    }

    public static void renameIconFamily(String oldName, IconFamily family) {
        IconFactory.getInstance().rename(oldName, family);
    }

    public static IconFamily getIconFamily(String name) {
        return IconFactory.getInstance().getFamily(name);
    }

    private void add(IconFamily family) {
        this.iconFamilies.putIfAbsent(family.getName(), family);
    }

    private void remove(IconFamily family) {
        IconFamily old = this.iconFamilies.get(family.getName());
        if (old != null && old == family) {
            this.iconFamilies.remove(family.getName());
        }
    }

    private void rename(String oldFamilyName, IconFamily iconFamily) {
        IconFamily oldFamily = this.iconFamilies.get(oldFamilyName);
        if (oldFamily != null && oldFamily == iconFamily) {
            this.iconFamilies.remove(oldFamilyName);
        }
        this.add(iconFamily);
    }

    IconFamily getFamily(String iconFamilyName) {
        try {
            if (this.preloadThread.isAlive()) {
                try {
                    this.preloadThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.iconFamilies.get(iconFamilyName);
        }
        catch (IllegalStateException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getIconFamilyList() {
        ArrayList<String> names;
        Object object = preloadLock;
        synchronized (object) {
            names = new ArrayList<String>(this.iconFamilies.keySet());
        }
        Collections.sort(names);
        return names;
    }

    private void initVassalIconFamilys() {
        block5: {
            URL imageUrl = null;
            try {
                imageUrl = jar.getURL("images/VASSAL-256x256.png");
                imageUrl = new URL(imageUrl.toString().substring(0, imageUrl.toString().length() - "VASSAL-256x256.png".length()));
                logger.debug("VASSAL images folder found at " + imageUrl);
                if (imageUrl.toString().startsWith(FILE)) {
                    this.findLocalScalableIcons();
                    for (int size = 0; size < IconFamily.SIZE_DIRS.length; ++size) {
                        this.findLocalSizedIcons(size);
                    }
                    break block5;
                }
                if (imageUrl.toString().startsWith(JAR)) {
                    this.findJarIcons();
                    break block5;
                }
                throw new IllegalBuildException("Unknown Vassal Image source type: " + imageUrl);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, imageUrl.toString());
            }
        }
    }

    private void findLocalSizedIcons(int size) throws IOException {
        String path = "icons/" + IconFamily.SIZE_DIRS[size];
        URL sizeURL = jar.getURL(path);
        try (InputStream in = sizeURL.openStream();
             InputStreamReader isr = new InputStreamReader(in, Charset.defaultCharset());
             BufferedReader br = new BufferedReader(isr);){
            String imageName = "";
            while (imageName != null) {
                imageName = br.readLine();
                if (imageName == null) continue;
                String familyName = imageName.split("\\.")[0];
                IconFamily family = this.iconFamilies.get(familyName);
                if (family == null) {
                    family = new IconFamily(familyName);
                    logger.debug("Icon family " + familyName + " created for " + imageName);
                }
                family.setSizeIconPath(size, "/" + path + imageName);
                this.iconFamilies.put(familyName, family);
            }
        }
    }

    private void findLocalScalableIcons() throws IOException {
        String scalablePath = "icons/scalable/";
        URL url = jar.getURL("icons/scalable/");
        try (InputStream in = url.openStream();
             InputStreamReader isr = new InputStreamReader(in, Charset.defaultCharset());
             BufferedReader br = new BufferedReader(isr);){
            String imageName = "";
            while (imageName != null) {
                imageName = br.readLine();
                if (imageName == null) continue;
                String familyName = imageName.split("\\.")[0];
                IconFamily family = this.iconFamilies.get(familyName);
                if (family == null) {
                    family = new IconFamily(familyName);
                    logger.debug("Icon family " + familyName + " created for " + imageName);
                }
                family.setScalableIconPath("/icons/scalable/" + imageName);
                this.iconFamilies.put(familyName, family);
            }
        }
    }

    private void findJarIcons() throws IOException {
        String scalablePath = "icons/scalable/";
        String[] sizePaths = new String[4];
        for (int size = 0; size < 4; ++size) {
            sizePaths[size] = "icons/" + IconFamily.SIZE_DIRS[size];
        }
        JarURLConnection j = (JarURLConnection)jar.getURL("images/").openConnection();
        JarFile vengine = j.getJarFile();
        Enumeration<JarEntry> e = vengine.entries();
        block1: while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("icons/")) continue;
            if (entryName.startsWith("icons/scalable/") && !entryName.equals("icons/scalable/")) {
                String imageName = entryName.substring("icons/scalable/".length());
                String familyName = imageName.split("\\.")[0];
                IconFamily family = this.iconFamilies.get(familyName);
                if (family == null) {
                    family = new IconFamily(familyName);
                    logger.debug("Icon family " + familyName + " created for " + imageName);
                }
                family.setScalableIconPath("/" + entryName);
                this.iconFamilies.put(familyName, family);
                continue;
            }
            for (int size = 0; size < 4; ++size) {
                if (!entryName.startsWith(sizePaths[size]) || entryName.equals(sizePaths[size])) continue;
                String imageName = entryName.substring(sizePaths[size].length());
                String familyName = imageName.split("\\.")[0];
                IconFamily family = this.iconFamilies.get(familyName);
                if (family == null) {
                    family = new IconFamily(familyName);
                    logger.debug("Icon family " + familyName + " created for " + imageName);
                }
                family.setSizeIconPath(size, "/" + entryName);
                this.iconFamilies.put(familyName, family);
                continue block1;
            }
        }
    }
}

