/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.ScaleOp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class ScaledImagePainter {
    protected ImageOp srcOp;
    protected ScaleOp scaleOp;

    public void setImageName(String imageName) {
        this.setSource(imageName == null || imageName.isBlank() ? null : Op.load(imageName));
    }

    public Dimension getImageSize() {
        return this.srcOp == null ? new Dimension() : this.srcOp.getSize();
    }

    public void draw(Graphics g, int x, int y, double scale, ImageObserver obs) {
        BufferedImage img;
        if (this.srcOp == null || scale <= 0.0) {
            return;
        }
        if (scale == 1.0) {
            img = this.srcOp.getImage();
        } else {
            if (this.scaleOp == null || this.scaleOp.getScale() != scale) {
                this.scaleOp = Op.scale(this.srcOp, scale);
            }
            img = this.scaleOp.getImage();
        }
        if (img == null) {
            return;
        }
        g.drawImage(img, x, y, obs);
    }

    public ImageOp getSource() {
        return this.srcOp;
    }

    public void setSource(ImageOp src) {
        this.srcOp = src;
        this.scaleOp = null;
    }
}

