/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.script.expression.Auditable;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.LoopControl;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DoActionButton
extends AbstractToolbarItem
implements RecursionLimiter.Loopable {
    public static final String DO_REPORT = "doReport";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String DO_SOUND = "doSound";
    public static final String SOUND_CLIP = "soundClip";
    public static final String DO_HOTKEY = "doHotkey";
    public static final String HOTKEYS = "hotkeys";
    public static final String DO_LOOP = "doLoop";
    public static final String LOOP_TYPE = "loopType";
    public static final String LOOP_COUNT = "loopCount";
    public static final String WHILE_EXPRESSION = "whileExpression";
    public static final String UNTIL_EXPRESSION = "untilExpression";
    public static final String PRE_LOOP_HOTKEY = "preLoopKey";
    public static final String POST_LOOP_HOTKEY = "postLoopKey";
    public static final String INDEX = "index";
    public static final String INDEX_PROPERTY = "indexProperty";
    public static final String INDEX_START = "indexStart";
    public static final String INDEX_STEP = "indexStep";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected boolean doReport = false;
    protected FormattedString reportFormat = new FormattedString(GameModule.getGameModule());
    protected boolean doSound = false;
    protected String soundClip = "";
    protected boolean doHotkey = false;
    protected List<NamedKeyStroke> hotkeys = new ArrayList<NamedKeyStroke>();
    protected boolean doLoop = false;
    protected String loopType = "counted";
    protected FormattedString loopCount = new FormattedString("1");
    protected PropertyExpression whileExpression = new PropertyExpression();
    protected PropertyExpression untilExpression = new PropertyExpression();
    protected NamedKeyStroke preLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected NamedKeyStroke postLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected boolean hasIndex = false;
    protected String indexProperty = "";
    protected int indexStart = 1;
    protected int indexStep = 1;
    protected int indexValue;
    protected MutableProperty.Impl loopIndexProperty = new MutableProperty.Impl("", this);
    protected boolean loopPropertyRegistered = false;

    public DoActionButton() {
        ActionListener rollAction = e -> {
            try {
                this.doActions();
            }
            catch (RecursionLimitException ex) {
                RecursionLimiter.infiniteLoop(ex);
            }
        };
        this.setLaunchButton(this.makeLaunchButton(DoActionButton.getConfigureTypeName(), DoActionButton.getConfigureTypeName(), "", rollAction));
        this.launch = this.getLaunchButton();
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DoAction.component_type");
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{DO_REPORT, REPORT_FORMAT, DO_SOUND, SOUND_CLIP, DO_HOTKEY, HOTKEYS, DO_LOOP, LOOP_TYPE, LOOP_COUNT, WHILE_EXPRESSION, UNTIL_EXPRESSION, PRE_LOOP_HOTKEY, POST_LOOP_HOTKEY, INDEX, INDEX_PROPERTY, INDEX_START, INDEX_STEP});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.DoAction.display_message"), Resources.getString("Editor.report_format"), Resources.getString("Editor.DoAction.play_sound"), Resources.getString("Editor.DoAction.sound_clip"), Resources.getString("Editor.DoAction.send_hotkeys"), Resources.getString("Editor.DoAction.hotkeys"), Resources.getString("Editor.DoAction.repeat_actions"), Resources.getString("Editor.LoopControl.type_of_loop"), Resources.getString("Editor.LoopControl.loop_how_many"), Resources.getString("Editor.LoopControl.looping_continues"), Resources.getString("Editor.LoopControl.looping_ends"), Resources.getString("Editor.DoAction.perform_before"), Resources.getString("Editor.DoAction.perform_after"), Resources.getString("Editor.LoopControl.loop_index"), Resources.getString("Editor.LoopControl.index_name"), Resources.getString("Editor.LoopControl.index_start"), Resources.getString("Editor.LoopControl.index_step")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{Boolean.class, ReportFormatConfig.class, Boolean.class, SoundConfig.class, Boolean.class, HotkeyConfig.class, Boolean.class, LoopConfig.class, LoopCountConfig.class, PropertyExpression.class, PropertyExpression.class, NamedKeyStroke.class, NamedKeyStroke.class, Boolean.class, String.class, Integer.class, Integer.class});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (DO_REPORT.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.doReport = (Boolean)o;
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)o);
        } else if (DO_SOUND.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.doSound = (Boolean)o;
        }
        if (SOUND_CLIP.equals(key)) {
            if (o instanceof File) {
                o = ((File)o).getName();
            }
            this.soundClip = (String)o;
        } else if (DO_HOTKEY.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.doHotkey = (Boolean)o;
        } else if (HOTKEYS.equals(key)) {
            if (o instanceof String) {
                o = this.decodeHotkeys((String)o);
            } else if (o instanceof NamedKeyStroke[]) {
                o = Arrays.asList((NamedKeyStroke[])o);
            }
            this.hotkeys = o;
        } else if (DO_LOOP.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.doLoop = (Boolean)o;
            this.updateLoopPropertyRegistration();
        } else if (LOOP_TYPE.equals(key)) {
            this.loopType = LoopControl.loopDescToType((String)o);
        } else if (LOOP_COUNT.equals(key)) {
            this.loopCount.setFormat((String)o);
        } else if (WHILE_EXPRESSION.equals(key)) {
            this.whileExpression.setExpression((String)o);
        } else if (UNTIL_EXPRESSION.equals(key)) {
            this.untilExpression.setExpression((String)o);
        } else if (PRE_LOOP_HOTKEY.equals(key)) {
            if (o instanceof String) {
                o = NamedHotKeyConfigurer.decode((String)o);
            }
            this.preLoopKey = (NamedKeyStroke)o;
        } else if (POST_LOOP_HOTKEY.equals(key)) {
            if (o instanceof String) {
                o = NamedHotKeyConfigurer.decode((String)o);
            }
            this.postLoopKey = (NamedKeyStroke)o;
        } else if (INDEX.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.hasIndex = (Boolean)o;
            this.updateLoopPropertyRegistration();
        } else if (INDEX_PROPERTY.equals(key)) {
            this.indexProperty = (String)o;
            this.loopIndexProperty.setPropertyName(this.indexProperty);
            this.updateLoopPropertyRegistration();
        } else if (INDEX_START.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.indexStart = (Integer)o;
        } else if (INDEX_STEP.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.indexStep = (Integer)o;
        } else {
            super.setAttribute(key, o);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (DO_REPORT.equals(key)) {
            return String.valueOf(this.doReport);
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (DO_SOUND.equals(key)) {
            return String.valueOf(this.doSound);
        }
        if (SOUND_CLIP.equals(key)) {
            return this.soundClip;
        }
        if (DO_HOTKEY.equals(key)) {
            return String.valueOf(this.doHotkey);
        }
        if (HOTKEYS.equals(key)) {
            return this.encodeHotkeys();
        }
        if (DO_LOOP.equals(key)) {
            return String.valueOf(this.doLoop);
        }
        if (LOOP_TYPE.equals(key)) {
            return this.loopType;
        }
        if (LOOP_COUNT.equals(key)) {
            return this.loopCount.getFormat();
        }
        if (WHILE_EXPRESSION.equals(key)) {
            return this.whileExpression.getExpression();
        }
        if (UNTIL_EXPRESSION.equals(key)) {
            return this.untilExpression.getExpression();
        }
        if (PRE_LOOP_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.preLoopKey);
        }
        if (POST_LOOP_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.postLoopKey);
        }
        if (INDEX.equals(key)) {
            return String.valueOf(this.hasIndex);
        }
        if (INDEX_PROPERTY.equals(key)) {
            return this.indexProperty;
        }
        if (INDEX_START.equals(key)) {
            return String.valueOf(this.indexStart);
        }
        if (INDEX_STEP.equals(key)) {
            return String.valueOf(this.indexStep);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (REPORT_FORMAT.equals(name)) {
            return () -> this.doReport;
        }
        if (SOUND_CLIP.equals(name)) {
            return () -> this.doSound;
        }
        if (HOTKEYS.equals(name)) {
            return () -> this.doHotkey;
        }
        if (LOOP_COUNT.equals(name)) {
            return () -> this.doLoop && "counted".equals(this.loopType);
        }
        if (WHILE_EXPRESSION.equals(name)) {
            return () -> this.doLoop && "while".equals(this.loopType);
        }
        if (UNTIL_EXPRESSION.equals(name)) {
            return () -> this.doLoop && "until".equals(this.loopType);
        }
        if (List.of(LOOP_TYPE, PRE_LOOP_HOTKEY, POST_LOOP_HOTKEY, INDEX).contains(name)) {
            return () -> this.doLoop;
        }
        if (List.of(INDEX_PROPERTY, INDEX_START, INDEX_STEP).contains(name)) {
            return () -> this.doLoop && this.hasIndex;
        }
        return super.getAttributeVisibility(name);
    }

    protected String encodeHotkeys() {
        SequenceEncoder se = new SequenceEncoder(',');
        for (NamedKeyStroke key : this.hotkeys) {
            se.append(NamedHotKeyConfigurer.encode(key));
        }
        String val = se.getValue();
        return val == null ? "" : val;
    }

    protected List<NamedKeyStroke> decodeHotkeys(String s) {
        ArrayList<NamedKeyStroke> list = new ArrayList<NamedKeyStroke>();
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        while (sd.hasMoreTokens()) {
            NamedKeyStroke key = NamedHotKeyConfigurer.decode(sd.nextToken());
            list.add(key);
        }
        return list;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DoActionButton.html");
    }

    protected void updateLoopPropertyRegistration() {
        boolean shouldBeRegistered;
        boolean bl = shouldBeRegistered = this.doLoop && this.hasIndex && this.indexProperty.length() > 0;
        if (shouldBeRegistered && !this.loopPropertyRegistered) {
            this.loopIndexProperty.addTo(GameModule.getGameModule());
            this.loopPropertyRegistered = true;
        } else if (!shouldBeRegistered && this.loopPropertyRegistered) {
            this.loopIndexProperty.removeFromContainer();
            this.loopPropertyRegistered = false;
        }
    }

    protected void setIndexPropertyValue() {
        this.loopIndexProperty.setPropertyValue(String.valueOf(this.indexValue));
    }

    protected void doActions() throws RecursionLimitException {
        NullCommand c = new NullCommand();
        GameModule mod = GameModule.getGameModule();
        if (!this.doLoop) {
            this.executeActions(c);
            mod.sendAndLog(c);
            return;
        }
        this.indexValue = this.indexStart;
        this.setIndexPropertyValue();
        this.doHotKey(c, this.preLoopKey);
        int loopCounter = 0;
        int loopCountLimit = 0;
        if ("counted".equals(this.loopType)) {
            loopCountLimit = this.loopCount.getTextAsInt((PropertySource)mod, Resources.getString("Editor.LoopControl.loop_count"), this);
        }
        RecursionLimitException loopException = null;
        while (!"while".equals(this.loopType) || this.whileExpression.isTrue(mod)) {
            try {
                this.executeActions(c);
            }
            catch (RecursionLimitException ex) {
                loopException = ex;
                break;
            }
            if ("until".equals(this.loopType) && this.untilExpression.isTrue(mod)) break;
            ++loopCounter;
            if ("counted".equals(this.loopType)) {
                if (loopCounter >= loopCountLimit) {
                    break;
                }
            } else if (loopCounter >= 500) {
                loopException = new RecursionLimitException(this);
                break;
            }
            this.indexValue += this.indexStep;
            this.setIndexPropertyValue();
        }
        this.doHotKey(c, this.postLoopKey);
        mod.sendAndLog(c);
        if (loopException != null) {
            throw loopException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeActions(Command command) throws RecursionLimitException {
        GameModule mod = GameModule.getGameModule();
        boolean loggingPaused = mod.pauseLogging();
        try {
            Command c;
            RecursionLimiter.startExecution(this);
            if (this.doReport) {
                String report = "* " + this.reportFormat.getLocalizedText((PropertySource)mod, (Auditable)this, "Editor.report_format");
                c = new Chatter.DisplayText(mod.getChatter(), report);
                c.execute();
                mod.sendAndLog(c);
            }
            if (this.doSound) {
                String clipName = new FormattedString(this.soundClip).getText((PropertySource)mod, (Auditable)this, "Editor.DoAction.sound_clip");
                c = new PlayAudioClipCommand(clipName);
                c.execute();
                mod.sendAndLog(c);
            }
            if (this.doHotkey) {
                for (NamedKeyStroke key : this.hotkeys) {
                    mod.fireKeyStroke(key);
                }
            }
        }
        finally {
            RecursionLimiter.endExecution();
            if (loggingPaused) {
                command.append(mod.resumeLogging());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHotKey(Command c, NamedKeyStroke key) {
        if (!key.isNull()) {
            GameModule mod = GameModule.getGameModule();
            boolean loggingPaused = mod.pauseLogging();
            try {
                mod.fireKeyStroke(key);
            }
            finally {
                if (loggingPaused) {
                    c.append(mod.resumeLogging());
                }
            }
        }
    }

    @Override
    public String getComponentTypeName() {
        return DoActionButton.getConfigureTypeName();
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.doLoop && this.hasIndex) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.indexProperty);
            return l;
        }
        return super.getPropertyNames();
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.doLoop) {
            if ("while".equals(this.loopType)) {
                l.add(this.whileExpression.getExpression());
            } else if ("until".equals(this.loopType)) {
                l.add(this.untilExpression.getExpression());
            } else if ("counted".equals(this.loopType)) {
                l.add(this.loopCount.getFormat());
            }
        }
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.reportFormat.getFormat());
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.indexProperty);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>(super.getNamedKeyStrokeList());
        l.addAll(this.hotkeys);
        Collections.addAll(l, this.preLoopKey, this.postLoopKey);
        return l;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.reportFormat.getFormat());
        h.addImageNames(s);
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[0]);
        }
    }

    public static class SoundConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new AudioClipConfigurer(key, name, GameModule.getGameModule().getArchiveWriter());
        }
    }

    public static class HotkeyConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new NamedKeyStrokeArrayConfigurer(key, name, ((DoActionButton)c).hotkeys);
        }
    }

    public static class LoopConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new LoopTypeConfig(key, name, ((DoActionButton)c).loopType);
        }
    }

    public static class LoopCountConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedExpressionConfigurer(key, name, ((DoActionButton)c).loopCount);
        }
    }

    public static class LoopTypeConfig
    extends StringEnumConfigurer {
        public LoopTypeConfig(String key, String name, String loopType) {
            super(key, name, LoopControl.LOOP_TYPE_DESCS);
            this.setValue(LoopControl.loopTypeToDesc(loopType));
        }

        public String[] getValidValues(AutoConfigurable target) {
            return LoopControl.LOOP_TYPE_DESCS;
        }

        @Override
        public String getValueString() {
            return LoopControl.loopDescToType(super.getValueString());
        }
    }

    @Deprecated(since="2020-10-21", forRemoval=true)
    public static class NamedHotkeyListConfigurer
    extends ListConfigurer {
        public NamedHotkeyListConfigurer(String key, String name, List<NamedKeyStroke> list) {
            super(key, name, list);
        }

        @Override
        protected Configurer buildChildConfigurer() {
            return new NamedHotKeyConfigurer(null, Resources.getString("Editor.hotkey_label"));
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, null);
        }
    }
}

