/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.turn.CounterTurnLevel;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnComponent;
import VASSAL.build.module.turn.TurnGlobalHotkey;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.IconButton;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TurnTracker
extends TurnComponent
implements CommandEncoder,
GameComponent,
ActionListener,
UniqueIdManager.Identifyable,
RecursionLimiter.Loopable,
ComponentDescription {
    protected static final UniqueIdManager idMgr = new UniqueIdManager("TurnTracker");
    protected static final String COMMAND_PREFIX = "TURN";
    protected static final String DEFAULT_FONT_SIZE_PROPERTY = "TurnTracker.defaultFontSize";
    protected static final String DEFAULT_FONT_BOLD_PROPERTY = "TurnTracker.defaultFontBold";
    protected static final String DEFAULT_DOCKED_PROPERTY = "TurnTracker.defaultDocked";
    public static final String NAME = "name";
    public static final String HOT_KEY = "hotkey";
    public static final String NEXT_HOT_KEY = "nexthotkey";
    public static final String PREV_HOT_KEY = "prevhotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String BUTTON_TOOLTIP = "buttonTooltip";
    public static final String TURN_FORMAT = "turnFormat";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String TOOLTIP = "tooltip";
    public static final String LENGTH = "length";
    public static final String LENGTH_STYLE = "lengthStyle";
    public static final String PLUS_BUTTON_WIDTH = "plusButtonSize";
    public static final String TURN_BUTTON_HEIGHT = "turnButtonHeight";
    private static final int DEFAULT_SIZE = 22;
    protected static final String FONT_SIZE = "turnFontSize";
    protected static final String FONT_BOLD = "turnFontBold";
    protected static final String DOCKED = "turnDocked";
    protected static final String OLD_TURN = "oldTurn";
    protected static final String NEW_TURN = "newTurn";
    protected static final String LEVEL = "level";
    protected static final String TURN_FONT = "Dialog";
    protected static String SET_COMMAND;
    protected static String DOCK_COMMAND;
    protected static String UNDOCK_COMMAND;
    protected static final String NEXT = "Next";
    protected static final String PREV = "Prev";
    protected static final String SET = "Set";
    protected static final String PROP_VALUE = "_value";
    protected static final String PROP_COMMAND = "_command";
    protected static final String LENGTH_VARIABLE = "Variable";
    protected static final String LENGTH_MAXIMUM = "Maximum";
    protected static final String LENGTH_FIXED = "Fixed";
    protected FormattedString turnFormat = new FormattedString(String.join((CharSequence)"level", "$", "1$ $", "2$ $", "3$ $", "4$"));
    protected FormattedString reportFormat = new FormattedString(Resources.getString("Editor.TurnTracker.report_default"));
    protected TurnWindow turnWindow;
    protected TurnWidget turnWidget;
    protected JPanel launchWidget;
    protected SetDialog setDialog;
    protected LaunchButton launch;
    protected NamedKeyStrokeListener nextListener;
    protected NamedKeyStrokeListener prevListener;
    protected String toolTip;
    protected String savedState = "";
    protected String savedSetState = "";
    protected String savedTurn = "";
    protected JPopupMenu popup;
    protected int currentLevel = 0;
    protected String id;
    protected int width = -1;
    protected String lengthStyle = "Maximum";
    protected int plusButtonWidth = 22;
    protected int turnButtonHeight = 22;
    protected MutableProperty.Impl lastCommand = new MutableProperty.Impl("Set", this);
    protected MutableProperty.Impl lastTurn = new MutableProperty.Impl("", this);
    private static final Dimension FILLER;

    public TurnTracker() {
        ActionListener al = e -> {
            if (!this.isDocked()) {
                this.turnWindow.setControls();
                this.turnWindow.setVisible(!this.turnWindow.isShowing());
                this.turnWindow.setFocusable(true);
            }
        };
        this.setConfigureName(Resources.getString("TurnTracker.turn"));
        this.launch = new LaunchButton(Resources.getString("TurnTracker.turn"), "", BUTTON_TEXT, HOT_KEY, ICON, al);
        this.launch.setToolTipText(Resources.getString("TurnTracker.turn_tracker"));
        SET_COMMAND = Resources.getString("TurnTracker.set_turn");
        DOCK_COMMAND = Resources.getString("General.dock");
        UNDOCK_COMMAND = Resources.getString("General.undock");
        GameModule gm = GameModule.getGameModule();
        Object sizeProp = gm.getProperty(DEFAULT_FONT_SIZE_PROPERTY);
        int sizeDefault = sizeProp instanceof String ? NumberUtils.toInt((String)((String)sizeProp)) : 14;
        Object boldProp = gm.getProperty(DEFAULT_FONT_BOLD_PROPERTY);
        boolean boldDefault = boldProp instanceof String ? BooleanUtils.toBoolean((String)((String)boldProp)) : Boolean.FALSE;
        Object dockedProp = gm.getProperty(DEFAULT_DOCKED_PROPERTY);
        boolean dockedDefault = dockedProp instanceof String ? BooleanUtils.toBoolean((String)((String)dockedProp)) : Boolean.FALSE;
        IntConfigurer size = new IntConfigurer(FONT_SIZE, Resources.getString("TurnTracker.size_pref"), (Integer)sizeDefault);
        BooleanConfigurer bold = new BooleanConfigurer(FONT_BOLD, Resources.getString("TurnTracker.bold_pref"), boldDefault);
        BooleanConfigurer docked = new BooleanConfigurer(DOCKED, Resources.getString("TurnTracker.docked_pref"), dockedDefault);
        String prefTab = Resources.getString("TurnTracker.turn_counter");
        GameModule.getGameModule().getPrefs().addOption(prefTab, size);
        GameModule.getGameModule().getPrefs().addOption(prefTab, bold);
        GameModule.getGameModule().getPrefs().addOption(prefTab, docked);
        size.addPropertyChangeListener(e -> this.setDisplayFont());
        bold.addPropertyChangeListener(e -> this.setDisplayFont());
        docked.addPropertyChangeListener(e -> this.setDocked(this.isDocked()));
        this.nextListener = new NamedKeyStrokeListener(e -> this.turnWidget.doNext());
        GameModule.getGameModule().addKeyStrokeListener(this.nextListener);
        this.prevListener = new NamedKeyStrokeListener(e -> this.turnWidget.doPrev());
        GameModule.getGameModule().addKeyStrokeListener(this.prevListener);
        this.turnWidget = new TurnWidget();
    }

    public String getState() {
        SequenceEncoder se = new SequenceEncoder('|');
        se.append(this.currentLevel);
        Iterator<TurnLevel> i = this.getTurnLevels();
        while (i.hasNext()) {
            TurnLevel level = i.next();
            se.append(level.getState());
        }
        return se.getValue();
    }

    public void setState(String newState) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(newState, '|');
        this.currentLevel = sd.nextInt(0);
        Iterator<TurnLevel> i = this.getTurnLevels();
        while (i.hasNext()) {
            TurnLevel level = i.next();
            level.setState(sd.nextToken(""));
        }
        this.setLaunchToolTip();
        this.updateTurnDisplay(SET);
    }

    protected void setLaunchToolTip() {
        this.launch.setToolTipText(this.getTurnString());
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, "description", BUTTON_TEXT, ICON, HOT_KEY, NEXT_HOT_KEY, PREV_HOT_KEY, TURN_FORMAT, REPORT_FORMAT, TOOLTIP, LENGTH_STYLE, LENGTH, PLUS_BUTTON_WIDTH, TURN_BUTTON_HEIGHT};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.clearGlobalProperties();
            this.setConfigureName((String)value);
            this.lastCommand.setPropertyName(this.getConfigureName() + PROP_COMMAND);
            this.lastTurn.setPropertyName(this.getConfigureName() + PROP_VALUE);
        } else if ("description".equals(key)) {
            this.description = (String)value;
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)value);
        } else if (TURN_FORMAT.equals(key)) {
            this.turnFormat.setFormat((String)value);
        } else if (TOOLTIP.equals(key)) {
            this.toolTip = (String)value;
            this.turnWidget.setLabelToolTipText(this.toolTip);
        } else if (LENGTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.width = (Integer)value;
        } else if (LENGTH_STYLE.equals(key)) {
            this.lengthStyle = (String)value;
            if (LENGTH_VARIABLE.equals(this.lengthStyle)) {
                this.width = 0;
            } else if (LENGTH_MAXIMUM.equals(this.lengthStyle)) {
                this.width = -1;
            }
        } else if (NEXT_HOT_KEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.nextListener.setKeyStroke((NamedKeyStroke)value);
            this.turnWidget.setNextStroke((NamedKeyStroke)value);
        } else if (PREV_HOT_KEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.prevListener.setKeyStroke((NamedKeyStroke)value);
            this.turnWidget.setPrevStroke((NamedKeyStroke)value);
        } else if (PLUS_BUTTON_WIDTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.plusButtonWidth = (Integer)value;
        } else if (TURN_BUTTON_HEIGHT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.turnButtonHeight = (Integer)value;
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    protected void setWidgetWidth() {
        if (LENGTH_FIXED.equals(this.lengthStyle)) {
            this.turnWidget.setWidth(this.width);
        } else if (LENGTH_MAXIMUM.equals(this.lengthStyle)) {
            this.turnWidget.setWidth(this.getMaximumWidth());
        } else {
            this.turnWidget.setWidth(0);
        }
    }

    protected int getMaximumWidth() {
        String maxString = this.getMaximumTurnString();
        int max = this.turnWidget.getWidth(maxString);
        return max + 2;
    }

    protected void setDisplayFont() {
        this.turnWidget.setLabelFont(this.getDisplayFont());
        if (!this.isDocked() && this.turnWindow != null) {
            this.turnWindow.pack();
        }
    }

    protected Font getDisplayFont() {
        return new Font(TURN_FONT, this.getFontStyle(), this.getFontSize());
    }

    protected void setFontSize() {
        this.setDisplayFont();
    }

    protected int getFontSize() {
        return (Integer)GameModule.getGameModule().getPrefs().getValue(FONT_SIZE);
    }

    protected int getFontStyle() {
        return (Boolean)GameModule.getGameModule().getPrefs().getValue(FONT_BOLD) != false ? 1 : 0;
    }

    protected boolean isDocked() {
        return (Boolean)GameModule.getGameModule().getPrefs().getValue(DOCKED);
    }

    protected void setDocked(boolean dock) {
        GameModule g = GameModule.getGameModule();
        g.getPrefs().setValue(DOCKED, dock);
        this.launch.setVisible(!dock && (this.getAttributeValueString(BUTTON_TEXT).length() > 0 || this.getAttributeValueString(ICON).length() > 0));
        if (dock) {
            this.turnWindow.setWidget(null);
            this.turnWindow.setVisible(false);
            this.launchWidget.add((Component)this.turnWidget, "Center");
            this.launchWidget.setVisible(g.getGameState().isGameStarted());
        } else {
            this.launchWidget.setVisible(false);
            this.launchWidget.remove(this.turnWidget);
            this.turnWindow.setWidget(this.turnWidget);
            this.turnWindow.setVisible(g.getGameState().isGameStarted());
            this.turnWindow.setFocusable(true);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if ("description".equals(key)) {
            return this.description;
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (TURN_FORMAT.equals(key)) {
            return this.turnFormat.getFormat();
        }
        if (TOOLTIP.equals(key)) {
            return this.toolTip;
        }
        if (LENGTH.equals(key)) {
            return String.valueOf(this.width);
        }
        if (LENGTH_STYLE.equals(key)) {
            return this.lengthStyle;
        }
        if (NEXT_HOT_KEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.nextListener.getNamedKeyStroke());
        }
        if (PREV_HOT_KEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.prevListener.getNamedKeyStroke());
        }
        if (PLUS_BUTTON_WIDTH.equals(key)) {
            return String.valueOf(this.plusButtonWidth);
        }
        if (TURN_BUTTON_HEIGHT.equals(key)) {
            return String.valueOf(this.turnButtonHeight);
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.TurnTracker.show_hotkey"), Resources.getString("Editor.TurnTracker.next_hotkey"), Resources.getString("Editor.TurnTracker.prev_hotkey"), Resources.getString("Editor.TurnTracker.turn_name_format"), Resources.getString("Editor.report_format"), Resources.getString("Editor.TurnTracker.turn_tooltip"), Resources.getString("Editor.TurnTracker.turn_length"), Resources.getString("Editor.TurnTracker.turn_display"), Resources.getString("Editor.TurnTracker.plus_button_width"), Resources.getString("Editor.TurnTracker.turn_button_height")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, NamedKeyStroke.class, NamedKeyStroke.class, TurnFormatConfig.class, ReportFormatConfig.class, String.class, LengthStyleConfig.class, Integer.class, Integer.class, Integer.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (LENGTH.equals(name)) {
            return () -> LENGTH_FIXED.equals(this.lengthStyle);
        }
        return null;
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CounterTurnLevel.class, ListTurnLevel.class, TurnGlobalHotkey.class};
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.TurnTracker.component_type");
    }

    @Override
    public void addTo(Buildable b) {
        this.turnWindow = new TurnWindow();
        this.turnWindow.pack();
        this.turnWindow.setVisible(false);
        this.launchWidget = new JPanel();
        this.launchWidget.setLayout(new BorderLayout());
        this.launchWidget.setBorder(BorderFactory.createEtchedBorder());
        GameModule.getGameModule().getToolBar().add(this.launchWidget);
        this.launchWidget.setAlignmentY(0.0f);
        this.launchWidget.setVisible(false);
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        this.launch.setEnabled(false);
        this.setDocked(this.isDocked());
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        idMgr.add(this);
        this.lastCommand.addTo((MutablePropertiesContainer)((Object)b));
        this.lastTurn.addTo((MutablePropertiesContainer)((Object)b));
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().getToolBar().remove(this.launchWidget);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.lastCommand.removeFromContainer();
        this.lastTurn.removeFromContainer();
        this.clearGlobalProperties();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.html");
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void captureState() {
        this.savedState = this.getState();
        this.savedTurn = this.getTurnString();
    }

    protected void save() {
        if (!this.savedState.equals(this.getState())) {
            Command c;
            this.reportFormat.setProperty(OLD_TURN, this.savedTurn);
            this.reportFormat.setProperty(NEW_TURN, this.getTurnString());
            String report = this.reportFormat.getText(this, "Editor.report_format");
            SetTurn c2 = new SetTurn(this, this.savedState);
            if (!report.isEmpty()) {
                String s = this.updateString(report, new String[]{"\\n", "\\t"}, new String[]{" - ", " "});
                c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + s);
                c.execute();
                c.append(c2);
            } else {
                c = c2;
            }
            GameModule.getGameModule().sendAndLog(c);
            this.setLaunchToolTip();
        }
        this.captureState();
    }

    protected String getMaximumTurnString() {
        ArrayList<String> levels = new ArrayList<String>();
        for (Buildable b : this.getBuildables()) {
            if (!(b instanceof TurnLevel)) continue;
            ((TurnLevel)b).findMaximumStrings(levels, 0);
        }
        this.turnFormat.clearProperties();
        for (int i = 0; i < levels.size(); ++i) {
            this.turnFormat.setProperty(LEVEL + (i + 1), (String)levels.get(i));
        }
        return this.turnFormat.getText((PropertySource)GameModule.getGameModule(), (Auditable)this, "Editor.TurnTracker.turn_name_format");
    }

    protected String getTurnString() {
        this.turnFormat.clearProperties();
        List<TurnLevel> turnDesc = this.getActiveChildLevels();
        for (int i = 0; i < 15; ++i) {
            this.turnFormat.setProperty(LEVEL + (i + 1), i < turnDesc.size() ? turnDesc.get(i).getTurnString() : "");
        }
        return this.turnFormat.getText((PropertySource)GameModule.getGameModule(), (Auditable)this, "Editor.TurnTracker.turn_name_format");
    }

    protected List<TurnLevel> getActiveChildLevels() {
        ArrayList<TurnLevel> levels = new ArrayList<TurnLevel>();
        TurnLevel level = this.getTurnLevel(this.currentLevel);
        if (level != null) {
            levels.add(level);
            levels.addAll(level.getActiveChildLevels());
        }
        return levels;
    }

    protected int getLevelCount() {
        return this.getActiveChildLevels().size();
    }

    protected void next() {
        if (this.getTurnLevelCount() == 0) {
            return;
        }
        TurnLevel level = this.getTurnLevel(this.currentLevel);
        level.advance();
        if (level.hasRolledOver()) {
            ++this.currentLevel;
            if (this.currentLevel >= this.getTurnLevelCount()) {
                this.currentLevel = 0;
            }
            this.getTurnLevel(this.currentLevel).setLow();
        }
        this.updateTurnDisplay(NEXT);
        this.doGlobalkeys();
    }

    protected void prev() {
        if (this.getTurnLevelCount() == 0) {
            return;
        }
        TurnLevel level = this.getTurnLevel(this.currentLevel);
        level.retreat();
        if (level.hasRolledOver()) {
            --this.currentLevel;
            if (this.currentLevel < 0) {
                this.currentLevel = this.getTurnLevelCount() - 1;
            }
            this.getTurnLevel(this.currentLevel).setHigh();
        }
        this.updateTurnDisplay(PREV);
        this.doGlobalkeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGlobalkeys() {
        for (TurnGlobalHotkey key : this.getComponentsOf(TurnGlobalHotkey.class)) {
            try {
                RecursionLimiter.startExecution(this);
                key.apply();
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            finally {
                RecursionLimiter.endExecution();
            }
        }
    }

    @Override
    public String getComponentTypeName() {
        return TurnTracker.getConfigureTypeName();
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(SET_COMMAND)) {
            this.set();
        } else if (command.equals(DOCK_COMMAND)) {
            this.setDocked(true);
        } else if (command.equals(UNDOCK_COMMAND)) {
            this.setDocked(false);
        }
    }

    protected void set() {
        this.savedSetState = this.getState();
        if (this.setDialog == null) {
            this.setDialog = new SetDialog();
            this.setDialog.setTitle(Resources.getString("TurnTracker.set_turn2", this.getConfigureName()));
        }
        this.setDialog.setControls(this);
        this.setDialog.setVisible(true);
    }

    protected void updateTurnDisplay(String command) {
        this.lastCommand.setPropertyValue(command);
        this.lastTurn.setPropertyValue(this.getTurnString());
        this.turnWidget.setControls();
        this.turnWidget.repaint();
        this.turnWindow.pack();
        this.turnWindow.setFocusable(true);
        this.turnWindow.requestFocus();
    }

    public void updateWidget() {
        this.turnWidget.setControls();
        this.turnWidget.repaint();
    }

    protected void clearGlobalProperties() {
        this.lastCommand.setPropertyValue(null);
        this.lastTurn.setPropertyValue(null);
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX + this.getId())) {
            return null;
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(command, '\t');
        sd.nextToken("");
        return new SetTurn(sd.nextToken(""), this);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof SetTurn)) {
            return null;
        }
        SetTurn com = (SetTurn)c;
        SequenceEncoder se = new SequenceEncoder('\t');
        se.append(COMMAND_PREFIX + com.getTurn().getId());
        se.append(com.newState);
        return se.getValue();
    }

    @Override
    public void setup(boolean gameStarting) {
        this.launch.setEnabled(gameStarting);
        this.turnWindow.setVisible(false);
        this.launchWidget.setVisible(this.isDocked() && gameStarting);
        if (gameStarting) {
            this.lastCommand.setPropertyValue(SET);
            this.lastTurn.setPropertyValue("");
            this.turnWidget.setControls();
            this.setWidgetWidth();
        } else {
            this.reset();
        }
    }

    protected void reset() {
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).reset();
        }
        this.currentLevel = 0;
        this.setLaunchToolTip();
        this.clearGlobalProperties();
    }

    public String updateString(String str, String[] from, String[] to) {
        StringBuilder s = new StringBuilder(str);
        for (int i = 0; i < from.length; ++i) {
            this.replace(s, from[i], to[i]);
        }
        return s.toString();
    }

    public void replace(StringBuilder s, String from, String to) {
        int i = s.indexOf(from);
        while (i >= 0) {
            s = s.replace(i, i + 2, to);
            i = s.indexOf(from);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new SetTurn(this.getState(), this);
    }

    protected void buildPopup() {
        this.popup = new JPopupMenu();
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                TurnTracker.this.turnWidget.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                TurnTracker.this.turnWidget.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        JMenuItem item = this.isDocked() ? new JMenuItem(UNDOCK_COMMAND) : new JMenuItem(DOCK_COMMAND);
        item.addActionListener(this);
        this.popup.add(item);
        item = new JMenuItem(SET_COMMAND);
        item.addActionListener(this);
        this.popup.add(item);
        JMenu config = new JMenu(Resources.getString("TurnTracker.configure"));
        for (int i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).buildConfigMenu(config);
        }
        if (config.getItemCount() > 0) {
            this.popup.add(config);
        }
    }

    protected void addItem(JMenu menu, String command) {
        JMenuItem item = new JMenuItem(command);
        item.addActionListener(this);
        menu.add(item);
    }

    protected void cancelSet() {
        this.setState(this.savedSetState);
        this.turnWindow.setVisible(true);
        this.turnWindow.setFocusable(true);
    }

    protected void saveSet() {
        this.save();
        this.updateTurnDisplay(SET);
        this.doGlobalkeys();
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.turnFormat.getFormat(), this.reportFormat.getFormat());
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.getAttributeValueString(BUTTON_TEXT), this.getAttributeValueString(TOOLTIP));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOT_KEY)), NamedHotKeyConfigurer.decode(this.getAttributeValueString(NEXT_HOT_KEY)), NamedHotKeyConfigurer.decode(this.getAttributeValueString(PREV_HOT_KEY)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String fileName = this.launch.getAttributeValueString(ICON);
        if (fileName != null) {
            s.add(fileName);
        }
    }

    static {
        FILLER = new Dimension(0, 3);
    }

    protected class TurnWidget
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private IconButton nextButton;
        private IconButton prevButton;
        private boolean initialized = false;
        @Deprecated
        protected final int BUTTON_SIZE = 22;
        protected JLabel turnLabel = new JLabel();

        protected TurnWidget() {
            this.initComponents();
        }

        public void setLabelFont(Font displayFont) {
            this.turnLabel.setFont(displayFont);
        }

        public void setWidth(int length) {
            if (length > 0) {
                this.turnLabel.setMinimumSize(new Dimension(length, TurnTracker.this.turnButtonHeight));
                this.turnLabel.setPreferredSize(new Dimension(length, TurnTracker.this.turnButtonHeight));
            } else {
                this.turnLabel.setMinimumSize(null);
                this.turnLabel.setPreferredSize(null);
            }
            if (!this.initialized) {
                this.setLayout(new BorderLayout(5, 5));
                this.nextButton = new IconButton(0, TurnTracker.this.plusButtonWidth > 0 ? TurnTracker.this.plusButtonWidth : 22);
                this.setNextStroke(TurnTracker.this.nextListener.getNamedKeyStroke());
                this.nextButton.setAlignmentY(0.0f);
                this.nextButton.addActionListener(e -> this.doNext());
                this.prevButton = new IconButton(1, TurnTracker.this.plusButtonWidth > 0 ? TurnTracker.this.plusButtonWidth : 22);
                this.setPrevStroke(TurnTracker.this.prevListener.getNamedKeyStroke());
                this.prevButton.setAlignmentY(0.0f);
                this.prevButton.addActionListener(e -> this.doPrev());
                this.turnLabel.setFont(TurnTracker.this.getDisplayFont());
                this.turnLabel.setFocusable(false);
                this.turnLabel.setHorizontalTextPosition(0);
                this.turnLabel.setHorizontalAlignment(0);
                this.turnLabel.addMouseListener(this);
                this.turnLabel.setBackground(Color.WHITE);
                this.add((Component)this.prevButton, "Before");
                this.add((Component)this.turnLabel, "Center");
                this.add((Component)this.nextButton, "After");
                this.addMouseListener(this);
                this.initialized = true;
            }
        }

        public void setLabelToolTipText(String tooltip) {
            this.turnLabel.setToolTipText(tooltip);
        }

        public String getLabelToolTipText() {
            return this.turnLabel.getToolTipText();
        }

        public Color getColor() {
            return this.turnLabel.getBackground();
        }

        public int getWidth(String text) {
            Graphics g = this.turnLabel.getGraphics();
            if (g != null) {
                return g.getFontMetrics().stringWidth(text);
            }
            Font f = TurnTracker.this.getDisplayFont();
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            return (int)f.getStringBounds(text, frc).getWidth();
        }

        protected void doNext() {
            TurnTracker.this.captureState();
            TurnTracker.this.next();
            TurnTracker.this.save();
        }

        protected void doPrev() {
            TurnTracker.this.captureState();
            TurnTracker.this.prev();
            TurnTracker.this.save();
        }

        protected void initComponents() {
        }

        public void setNextStroke(NamedKeyStroke key) {
            String tooltip = Resources.getString("TurnTracker.next_turn") + (String)(key == null ? "" : " " + NamedHotKeyConfigurer.getFancyString(key));
            if (this.nextButton != null) {
                this.nextButton.setToolTipText(tooltip);
            }
        }

        public void setPrevStroke(NamedKeyStroke key) {
            String tooltip = Resources.getString("TurnTracker.prev_turn") + (String)(key == null ? "" : " " + NamedHotKeyConfigurer.getFancyString(key));
            if (this.prevButton != null) {
                this.prevButton.setToolTipText(tooltip);
            }
        }

        public void setControls() {
            String s = TurnTracker.this.updateString(TurnTracker.this.getTurnString(), new String[]{"\\n", "\\t"}, new String[]{"\n", "    "});
            this.turnLabel.setText(s);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        public void doPopup(Point p) {
            TurnTracker.this.buildPopup();
            if (this.isShowing()) {
                TurnTracker.this.popup.show(this, p.x, p.y);
            }
        }
    }

    protected class TurnWindow
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected TurnWidget widget;

        protected TurnWindow() {
            super(GameModule.getGameModule().getPlayerWindow());
            this.setTitle(TurnTracker.this.getConfigureName());
            this.pack();
            this.setLocation(100, 100);
            this.setFocusable(true);
        }

        protected void setWidget(TurnWidget t) {
            if (t == null) {
                if (this.widget != null) {
                    this.remove(this.widget);
                }
            } else {
                this.add(t);
            }
            this.pack();
        }

        protected void setControls() {
            if (this.widget != null) {
                this.widget.setControls();
            }
            this.pack();
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((TurnTracker)c).launch.getAttributeValueString(TurnTracker.ICON));
        }
    }

    public static class TurnFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            TurnTracker t = (TurnTracker)c;
            String[] s = new String[t.getLevelCount()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = TurnTracker.LEVEL + (i + 1);
            }
            return new FormattedStringConfigurer(key, name, s);
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[]{TurnTracker.OLD_TURN, TurnTracker.NEW_TURN});
        }
    }

    public static class LengthStyleConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{TurnTracker.LENGTH_VARIABLE, TurnTracker.LENGTH_FIXED, TurnTracker.LENGTH_MAXIMUM};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{Resources.getString("Editor.TurnTracker.length_variable"), Resources.getString("Editor.TurnTracker.length_fixed"), Resources.getString("Editor.TurnTracker.length_maximum")};
        }
    }

    public static class SetTurn
    extends Command {
        private final String oldState;
        private final String newState;
        private final TurnTracker turn;

        public SetTurn(String newState, TurnTracker t) {
            this.newState = newState;
            this.oldState = t.getState();
            this.turn = t;
        }

        public SetTurn(TurnTracker t, String oldState) {
            this.newState = t.getState();
            this.oldState = oldState;
            this.turn = t;
        }

        public TurnTracker getTurn() {
            return this.turn;
        }

        @Override
        protected void executeCommand() {
            this.turn.setState(this.newState);
        }

        @Override
        protected Command myUndoCommand() {
            return new SetTurn(this.oldState, this.turn);
        }
    }

    protected class SetDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected JPanel panel;
        protected JPanel controls;
        protected JPanel levelControls;
        protected Component childControls;
        protected TurnTracker turn;
        protected JDialog me;

        protected SetDialog() {
            super(GameModule.getGameModule().getPlayerWindow());
            this.controls = null;
            this.levelControls = null;
            this.childControls = null;
            this.initComponents();
            this.setLocation(100, 100);
            this.me = this;
        }

        protected void initComponents() {
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TurnTracker.this.cancelSet();
                    SetDialog.this.setVisible(false);
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.add(this.panel);
            JPanel p = new JPanel();
            JButton saveButton = new JButton(Resources.getString("General.save"));
            saveButton.setToolTipText(Resources.getString("TurnTracker.save_changes"));
            p.add(saveButton);
            saveButton.addActionListener(e -> {
                TurnTracker.this.saveSet();
                this.setVisible(false);
            });
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.setToolTipText(Resources.getString("TurnTracker.discard_changes"));
            cancelButton.addActionListener(e -> {
                TurnTracker.this.cancelSet();
                this.setVisible(false);
            });
            p.add(cancelButton);
            this.add(p);
        }

        public void setControls(TurnTracker turn) {
            this.turn = turn;
            if (this.controls != null) {
                this.panel.remove(this.controls);
            }
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.levelControls = new JPanel();
            this.levelControls.setLayout(new BoxLayout(this.levelControls, 1));
            if (TurnTracker.this.getTurnLevelCount() > 1) {
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 1));
                p.setBorder(BorderFactory.createLineBorder(Color.black));
                String[] s = new String[TurnTracker.this.getTurnLevelCount()];
                for (int i = 0; i < s.length; ++i) {
                    s[i] = TurnTracker.this.getTurnLevel(i).getConfigureName();
                }
                StringEnumConfigurer e = new StringEnumConfigurer(null, Resources.getString("TurnTracker.select"), s);
                e.setValue(TurnTracker.this.getTurnLevel(TurnTracker.this.currentLevel).getConfigureName());
                e.addPropertyChangeListener(e1 -> {
                    String option = ((StringEnumConfigurer)e1.getSource()).getValueString();
                    for (int i = 0; i < TurnTracker.this.getTurnLevelCount(); ++i) {
                        if (!option.equals(TurnTracker.this.getTurnLevel(i).getConfigureName())) continue;
                        TurnTracker.this.currentLevel = i;
                        TurnTracker.this.updateTurnDisplay(TurnTracker.SET);
                        this.addChildControls();
                    }
                });
                p.add(Box.createRigidArea(FILLER));
                p.add(e.getControls());
                p.add(Box.createRigidArea(FILLER));
                this.levelControls.add(p);
                this.levelControls.add(Box.createRigidArea(FILLER));
            }
            this.addChildControls();
            this.controls.add(this.levelControls);
            this.panel.add(this.controls);
            this.pack();
        }

        protected void addChildControls() {
            if (this.childControls != null) {
                this.levelControls.remove(this.childControls);
            }
            this.childControls = TurnTracker.this.getTurnLevel(TurnTracker.this.currentLevel).getSetControls(this.me, this.turn);
            this.levelControls.add(this.childControls);
            this.pack();
        }
    }
}

