/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.ImageSelector;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.Op;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.tuple.Pair;

public class NonRectangular
extends Decorator
implements EditablePiece {
    public static final String ID = "nonRect2;";
    public static final String OLD_ID = "nonRect;";
    private static final Map<String, Pair<String, Shape>> cache = new HashMap<String, Pair<String, Shape>>();
    private String shapeSpec;
    private Shape shape;
    private Shape scaledShape = null;
    private String imageName = "";
    private double scale = 1.0;

    public NonRectangular() {
        this("nonRect2;1.0;", null);
    }

    public NonRectangular(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        if (this.scale == 1.0) {
            return OLD_ID + this.shapeSpec;
        }
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.scale).append(this.shapeSpec);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        if (this.shape == null) {
            return this.piece.getShape();
        }
        if (this.scale == 1.0) {
            return this.shape;
        }
        if (this.scaledShape == null) {
            AffineTransform tx = new AffineTransform();
            tx.scale(this.scale, this.scale);
            this.scaledShape = tx.createTransformedShape(this.shape);
        }
        return this.scaledShape;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.scaledShape = null;
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.NonRectangular.trait_description", this.imageName);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.NonRectangular.trait_description");
    }

    @Override
    public void mySetType(String type) {
        if (type.startsWith(OLD_ID)) {
            this.setScale(1.0);
            this.shapeSpec = type.substring(OLD_ID.length());
        } else {
            type = type.substring(ID.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
            this.setScale(st.nextDouble(1.0));
            this.shapeSpec = st.getRemaining();
        }
        this.shape = this.buildPath(this.shapeSpec);
    }

    private Shape buildPath(String spec) {
        Pair<String, Shape> p = cache.get(spec);
        Shape sh = p == null ? null : (Shape)p.getRight();
        String string = this.imageName = p == null ? "" : (String)p.getLeft();
        if (sh == null) {
            GeneralPath path = new GeneralPath();
            StringTokenizer st = new StringTokenizer(spec, ",");
            if (st.hasMoreTokens()) {
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    switch (token.charAt(0)) {
                        case 'c': {
                            path.closePath();
                            break;
                        }
                        case 'm': {
                            path.moveTo(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            break;
                        }
                        case 'l': {
                            path.lineTo(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            break;
                        }
                        case 'n': {
                            this.imageName = token.length() > 1 ? token.substring(1) : "";
                        }
                    }
                }
                sh = new Area(path);
                cache.put(spec, (Pair<String, Shape>)Pair.of((Object)this.imageName, (Object)sh));
            }
        }
        return sh;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        Collections.addAll(s, this.imageName);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonRectangular.html");
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof NonRectangular)) {
            return false;
        }
        NonRectangular c = (NonRectangular)o;
        if (!Objects.equals(this.scale, c.scale)) {
            return false;
        }
        return Objects.equals(this.shapeSpec, c.shapeSpec);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private class Ed
    implements PieceEditor {
        private Shape shape;
        private final JPanel controls;
        private final ImageSelector picker;
        final DoubleConfigurer scaleConfig;

        private Ed(NonRectangular p) {
            this.shape = p.shape;
            this.controls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow][]", "[grow]"));
            this.controls.add(new JLabel(Resources.getString("Editor.NonRectangular.scale")));
            this.scaleConfig = new DoubleConfigurer(p.scale);
            this.controls.add(this.scaleConfig.getControls(), "wrap");
            JPanel shapePanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(Color.white);
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (Ed.this.shape != null) {
                        g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
                        g2d.setColor(Color.black);
                        g2d.fill(Ed.this.shape);
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = Ed.this.shape == null ? new Dimension(60, 60) : Ed.this.shape.getBounds().getSize();
                    d.width = Math.max(d.width, 60);
                    d.height = Math.max(d.height, 60);
                    return d;
                }
            };
            this.controls.add((Component)shapePanel, "grow");
            this.picker = new ImageSelector(p.imageName);
            this.picker.addPropertyChangeListener(e -> {
                String imageName = this.picker.getImageName();
                if (imageName == null || imageName.isEmpty()) {
                    this.shape = null;
                    this.controls.revalidate();
                    Decorator.repack(this.controls);
                } else {
                    BufferedImage img = Op.load(this.picker.getImageName()).getImage();
                    if (img != null) {
                        this.setShapeFromImage(img);
                    }
                }
            });
            this.controls.add(this.picker.getControls());
        }

        public void setShapeFromImage(Image im) {
            this.controls.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
            BufferedImage bi = ImageUtils.toBufferedImage(im);
            int w = bi.getWidth();
            int h = bi.getHeight();
            int[] pixels = bi.getRGB(0, 0, w, h, new int[w * h], 0, w);
            Area outline = new Area();
            for (int y = 0; y < h; ++y) {
                int left = -1;
                for (int x = 0; x < w; ++x) {
                    if ((pixels[x + y * w] >>> 24 & 0xFF) > 0) {
                        if (left >= 0) continue;
                        left = x;
                        continue;
                    }
                    if (left <= -1) continue;
                    outline.add(new Area(new Rectangle(left, y, x - left, 1)));
                    left = -1;
                }
                if (left <= -1) continue;
                outline.add(new Area(new Rectangle(left, y, w - left, 1)));
            }
            this.shape = AffineTransform.getTranslateInstance((double)(-w) / 2.0, (double)(-h) / 2.0).createTransformedShape(outline);
            Decorator.repack(this.controls);
            this.controls.getTopLevelAncestor().setCursor(null);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            StringBuilder buffer = new StringBuilder();
            if (this.shape != null) {
                PathIterator it = this.shape.getPathIterator(new AffineTransform());
                float[] pts = new float[6];
                buffer.append('n');
                buffer.append(this.picker.getImageName());
                buffer.append(',');
                while (!it.isDone()) {
                    switch (it.currentSegment(pts)) {
                        case 0: {
                            buffer.append("m,").append(Math.round(pts[0])).append(',').append(Math.round(pts[1]));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            buffer.append("l,").append(Math.round(pts[0])).append(',').append(Math.round(pts[1]));
                            break;
                        }
                        case 4: {
                            buffer.append('c');
                        }
                    }
                    it.next();
                    if (it.isDone()) continue;
                    buffer.append(',');
                }
            }
            if ("1.0".equals(this.scaleConfig.getValueString())) {
                return NonRectangular.OLD_ID + buffer.toString();
            }
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.scaleConfig.getValueString()).append(buffer.toString());
            return NonRectangular.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

