/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.BrowserSupport;
import VASSAL.tools.DialogUtils;
import VASSAL.tools.swing.FlowLabel;
import java.awt.Component;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class Dialogs {
    private Dialogs() {
    }

    public static void showMessageDialog(Component parent, String title, String heading, String message, int messageType) {
        Dialogs.showMessageDialog(parent, title, heading, message, messageType, null, null);
    }

    public static void showMessageDialog(Component parent, String title, String heading, String message, int messageType, Object key, String disableMsg) {
        Dialogs.showMessageDialog(parent, title, heading, message, messageType, null, key, disableMsg);
    }

    public static void showMessageDialog(Component parent, String title, String heading, String message, int messageType, Icon icon, Object key, String disableMsg) {
        Dialogs.showDialog(parent, title, Dialogs.buildContents(heading, message), messageType, icon, -1, null, null, key, disableMsg);
    }

    public static int showConfirmDialog(Component parent, String title, String heading, String message, int messageType, int optionType) {
        return Dialogs.showConfirmDialog(parent, title, heading, message, messageType, null, optionType, null, null);
    }

    public static int showConfirmDialog(Component parent, String title, String heading, String message, int messageType, int optionType, Object key, String disableMsg) {
        return Dialogs.showConfirmDialog(parent, title, heading, message, messageType, null, optionType, key, disableMsg);
    }

    public static int showConfirmDialog(Component parent, String title, String heading, String message, int messageType, Icon icon, int optionType, Object key, String disableMsg) {
        Object o = Dialogs.showDialog(parent, title, Dialogs.buildContents(heading, message), messageType, icon, optionType, null, null, key, disableMsg);
        if (!(o instanceof Integer)) {
            return -1;
        }
        return (Integer)o;
    }

    public static Object showDialog(Component parent, String title, Component content, int messageType, Icon icon, int optionType, Object[] options, Object initialValue, Object key, String disableMsg) {
        JCheckBox disableCheck;
        if (key != null) {
            if (DialogUtils.isDisabled(key)) {
                return null;
            }
            disableCheck = new JCheckBox(disableMsg);
            JPanel panel = new JPanel();
            GroupLayout layout = new GroupLayout(panel);
            panel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(content).addComponent(disableCheck));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(content).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addComponent(disableCheck));
            content = panel;
        } else {
            disableCheck = null;
        }
        JOptionPane opt = new JOptionPane(content, messageType, optionType, icon, options, initialValue);
        JDialog dialog = opt.createDialog(parent, title);
        dialog.setModal(true);
        dialog.setLocationRelativeTo(parent);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        if (disableCheck != null && disableCheck.isSelected()) {
            DialogUtils.setDisabled(key, true);
        }
        return opt.getValue();
    }

    private static Component buildContents(String title, String description) {
        JLabel titleLabel = new JLabel(title);
        Font f = titleLabel.getFont();
        titleLabel.setFont(f.deriveFont(1, (float)f.getSize() * 1.2f));
        FlowLabel descriptionLabel = new FlowLabel(description);
        descriptionLabel.addHyperlinkListener(BrowserSupport.getListener());
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(titleLabel).addComponent(descriptionLabel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(descriptionLabel));
        return panel;
    }

    public static void main(String[] args) {
        String loremIpsum = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        Dialogs.showMessageDialog(null, "Message Dialog", "This Is the Header", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", 1);
        Dialogs.showMessageDialog(null, "Message Dialog", "This Is the Header", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", 1, Boolean.TRUE, "Don't show this again");
        Dialogs.showMessageDialog(null, "Message Dialog", "This Is the Header", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", 1, Boolean.TRUE, "Don't show this again");
        Dialogs.showConfirmDialog(null, "Confirmation Dialog", "This Is the Header", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", 1, 0);
        System.exit(0);
    }
}

