/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SwatchComboBox
extends JComboBox<String> {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> colorMap = new HashMap<String, String>();

    public SwatchComboBox() {
        String[] s;
        for (String value : s = ColorManager.getColorManager().getColorNames()) {
            this.addItem(value);
        }
        SwatchRenderer renderer = new SwatchRenderer();
        this.setRenderer(renderer);
        if (colorMap.isEmpty()) {
            String[] displayNames = ColorManager.getColorManager().getColorDisplayNames();
            for (int i = 0; i < s.length; ++i) {
                colorMap.put(s[i], displayNames[i]);
            }
        }
    }

    public SwatchComboBox(ItemListener l) {
        this();
        this.addItemListener(l);
    }

    public SwatchComboBox(ItemListener l, String colorName) {
        this();
        this.setSelectedItem(colorName);
        this.addItemListener(l);
    }

    public class SwatchRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = 1L;

        public SwatchRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            ColorSwatch swatch = ColorManager.getColorManager().getColorSwatch(value);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            BufferedImage img = ImageUtils.createCompatibleImage(25, 12);
            Graphics2D g = img.createGraphics();
            g.setColor(swatch.getColor());
            g.fillRect(0, 0, 25, 12);
            g.setColor(Color.black);
            g.drawRect(0, 0, 24, 11);
            g.dispose();
            this.setIcon(new ImageIcon(img));
            this.setText(colorMap.get(value));
            this.setFont(list.getFont());
            return this;
        }
    }

    public class SwatchTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public SwatchTableRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ColorSwatch swatch = (ColorSwatch)value;
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            BufferedImage img = ImageUtils.createCompatibleImage(25, 12);
            Graphics2D g = img.createGraphics();
            g.setColor(swatch.getColor());
            g.fillRect(0, 0, 25, 12);
            g.setColor(Color.black);
            g.drawRect(0, 0, 24, 11);
            g.dispose();
            this.setIcon(new ImageIcon(img));
            this.setText(swatch.getConfigureName());
            this.setFont(table.getFont());
            return this;
        }
    }
}

