/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.turn.TurnLevel;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class ListTurnLevel
extends TurnLevel
implements ActionListener {
    protected static final String LIST = "list";
    protected static final String CONFIG_LIST = "configList";
    protected static final String CONFIG_FIRST = "configFirst";
    protected static final String PROMPT = "prompt";
    protected int first = 0;
    protected String[] list = new String[0];
    protected boolean[] active = new boolean[0];
    protected boolean configList = false;
    protected boolean configFirst = false;
    protected String prompt = null;
    protected JDialog configDialog;
    protected Component setControls;
    private final VisibilityCondition promptCond = () -> this.configFirst;

    public ListTurnLevel() {
        this.turnFormat = new FormattedString("$value$");
    }

    @Override
    protected void reset() {
        super.reset();
        Arrays.fill(this.active, true);
        this.setLow();
    }

    @Override
    protected void setLow() {
        this.current = this.first;
        super.setLow();
    }

    @Override
    protected void setHigh() {
        this.current = this.first;
        --this.current;
        if (this.current < 0) {
            this.current = this.list.length - 1;
        }
        super.setHigh();
    }

    @Override
    protected String getState() {
        int i;
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.current);
        se.append(this.currentSubLevel);
        se.append(this.first);
        String[] s = new String[this.active.length];
        for (i = 0; i < s.length; ++i) {
            s[i] = Boolean.toString(this.active[i]);
        }
        se.append(s);
        for (i = 0; i < this.getTurnLevelCount(); ++i) {
            se.append(this.getTurnLevel(i).getState());
        }
        return se.getValue();
    }

    @Override
    protected void setState(String code) {
        int i;
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.current = sd.nextInt(this.start);
        this.currentSubLevel = sd.nextInt(0);
        this.first = sd.nextInt(0);
        String[] s = sd.nextStringArray(0);
        this.active = new boolean[this.list.length];
        int l = Math.min(s.length, this.active.length);
        for (i = 0; i < l; ++i) {
            this.active[i] = s[i].equals("true");
        }
        for (i = 0; i < this.getTurnLevelCount(); ++i) {
            this.getTurnLevel(i).setState(sd.nextToken(""));
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected String getValueString() {
        if (this.current >= 0 && this.current <= this.list.length - 1) {
            return this.list[this.current];
        }
        return "";
    }

    @Override
    protected String getLongestValueName() {
        String s = "X";
        for (String value : this.list) {
            if (value.length() <= s.length()) continue;
            s = value;
        }
        return s;
    }

    @Override
    protected void advance() {
        super.advance();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            int idx = this.current;
            boolean done = false;
            for (int i = 0; i < this.list.length && !done; ++i) {
                if (++idx >= this.list.length) {
                    idx = 0;
                }
                if (idx == this.first) {
                    this.rolledOver = true;
                }
                done = this.active[idx];
            }
            this.current = idx;
            if (!done) {
                this.rolledOver = true;
            }
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected void retreat() {
        super.retreat();
        if (this.getTurnLevelCount() == 0 || this.getTurnLevelCount() > 0 && this.hasSubLevelRolledOver()) {
            int idx = this.current;
            boolean done = false;
            for (int i = 0; i < this.list.length && !done; ++i) {
                if (idx == this.first) {
                    this.rolledOver = true;
                }
                if (--idx < 0 || idx > this.list.length - 1) {
                    idx = this.list.length - 1;
                }
                done = this.active[idx];
            }
            this.current = idx;
        }
        this.myValue.setPropertyValue(this.getValueString());
    }

    @Override
    protected boolean isActive() {
        for (boolean b : this.active) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void buildConfigMenu(JMenu configMenu) {
        JMenu menu = this.getConfigMenu();
        if (menu != null) {
            configMenu.add(menu);
        }
        if (this.configFirst || this.configList) {
            JMenuItem item = new JMenuItem(Resources.getString("TurnTracker.configure2", this.getConfigureName()));
            item.addActionListener(this);
            configMenu.add(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.configDialog = new ConfigDialog();
        this.configDialog.setVisible(true);
    }

    @Override
    protected Component getSetControl() {
        StringEnumConfigurer config = new StringEnumConfigurer("", " " + this.getConfigureName() + ":  ", this.list);
        config.setValue(this.list[this.current]);
        config.addPropertyChangeListener(e -> {
            String option = ((StringEnumConfigurer)e.getSource()).getValueString();
            for (int i = 0; i < this.list.length; ++i) {
                if (!option.equals(this.list[i])) continue;
                this.current = i;
                this.myValue.setPropertyValue(this.getValueString());
            }
        });
        return config.getControls();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.ListTurnLevel.list_of_items"), Resources.getString("Editor.ListTurnLevel.allow_hide"), Resources.getString("Editor.ListTurnLevel.allow_reorder"), Resources.getString("Editor.ListTurnLevel.prompt_reorder")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{String[].class, Boolean.class, Boolean.class, String.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{LIST, CONFIG_LIST, CONFIG_FIRST, PROMPT});
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (LIST.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.list = value;
            this.active = new boolean[this.list.length];
            Arrays.fill(this.active, true);
        } else if (CONFIG_LIST.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.configList = (Boolean)value;
        } else if (CONFIG_FIRST.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.configFirst = (Boolean)value;
        } else if (PROMPT.equals(key)) {
            this.prompt = (String)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (LIST.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.list);
        }
        if (CONFIG_LIST.equals(key)) {
            return Boolean.toString(this.configList);
        }
        if (CONFIG_FIRST.equals(key)) {
            return Boolean.toString(this.configFirst);
        }
        if (PROMPT.equals(key)) {
            return this.prompt;
        }
        return super.getAttributeValueString(key);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ListTurnLevel.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.html", "List");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (PROMPT.equals(name)) {
            return this.promptCond;
        }
        return null;
    }

    @Override
    public boolean isConfigurable() {
        if (this.configFirst || this.configList) {
            return true;
        }
        return super.isConfigurable();
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(LIST, true);
        return myI18nData;
    }

    protected class ConfigDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public ConfigDialog() {
            super((Frame)GameModule.getGameModule().getPlayerWindow(), Resources.getString("TurnTracker.configure2", ListTurnLevel.this.getConfigureName()));
            this.setLayout((LayoutManager)new MigLayout("wrap 2", "[center]rel[left]"));
            if (ListTurnLevel.this.configFirst) {
                if (ListTurnLevel.this.prompt == null) {
                    ListTurnLevel.this.prompt = Resources.getString("Editor.ListTurnLevel.first_each", ListTurnLevel.this.getConfigureName(), ListTurnLevel.this.parent.getConfigureName());
                }
                StringEnumConfigurer firstItem = new StringEnumConfigurer("", ListTurnLevel.this.prompt + " :  ", ListTurnLevel.this.list);
                firstItem.setValue(ListTurnLevel.this.list[ListTurnLevel.this.first]);
                firstItem.addPropertyChangeListener(e -> {
                    String option = ((StringEnumConfigurer)e.getSource()).getValueString();
                    for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                        if (!ListTurnLevel.this.list[i].equals(option)) continue;
                        ListTurnLevel.this.first = i;
                    }
                });
                this.add(firstItem.getControls(), "span 2");
            }
            if (ListTurnLevel.this.configList) {
                this.add((Component)new JLabel(Resources.getString("TurnTracker.turn_off")), "span 2");
                for (int i = 0; i < ListTurnLevel.this.list.length; ++i) {
                    BooleanConfigurer b = new BooleanConfigurer(null, ListTurnLevel.this.list[i], ListTurnLevel.this.active[i]);
                    b.addPropertyChangeListener(e -> {
                        BooleanConfigurer b1 = (BooleanConfigurer)e.getSource();
                        String option = b1.getName();
                        for (int i1 = 0; i1 < ListTurnLevel.this.list.length; ++i1) {
                            if (!ListTurnLevel.this.list[i1].equals(option)) continue;
                            ListTurnLevel.this.active[i1] = b1.booleanValue();
                        }
                    });
                    this.add(b.getControls());
                    this.add(new JLabel(ListTurnLevel.this.list[i]));
                }
            }
            JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]push"));
            JButton saveButton = new JButton(Resources.getString("General.save"));
            saveButton.setToolTipText(Resources.getString("TurnTracker.save_changes"));
            p.add(saveButton);
            saveButton.addActionListener(e -> this.setVisible(false));
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.setToolTipText(Resources.getString("TurnTracker.discard_changes"));
            cancelButton.addActionListener(e -> this.setVisible(false));
            p.add(cancelButton);
            this.add((Component)p, "span 2, growx");
            this.pack();
        }
    }
}

