/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.configure.HintTextField;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class PropertySheet
extends Decorator
implements TranslatablePiece {
    public static final String ID = "propertysheet;";
    protected String oldState;
    protected String menuName;
    protected NamedKeyStroke launchKeyStroke;
    protected KeyCommand launch;
    protected Color backgroundColor;
    protected String m_definition;
    protected PropertySheetDialog frame;
    protected JButton applyButton;
    static final String[] COMMIT_VALUES = new String[]{"Every Keystroke", "Apply Button or Enter Key", "Close Window or Enter Key"};
    static final String[] COMMIT_KEYS = new String[]{"Editor.PropertySheet.commit_every", "Editor.PropertySheet.commit_apply", "Editor.PropertySheet.commit_close"};
    static final int COMMIT_IMMEDIATELY = 0;
    static final int COMMIT_ON_APPLY = 1;
    static final int COMMIT_ON_CLOSE = 2;
    static final int COMMIT_DEFAULT = 0;
    static final String[] TYPE_VALUES = new String[]{"Text", "Multi-line text", "Label Only", "Tick Marks", "Tick Marks with Max Field", "Tick Marks with Value Field", "Tick Marks with Value & Max", "Spinner"};
    static final String[] TYPE_KEYS = new String[]{"Editor.PropertySheet.field_text", "Editor.PropertySheet.field_multiline", "Editor.PropertySheet.field_label", "Editor.PropertySheet.field_tick", "Editor.PropertySheet.field_tick_max", "Editor.PropertySheet.field_tick_value", "Editor.PropertySheet.field_tick_value_max"};
    static final int TEXT_FIELD = 0;
    static final int TEXT_AREA = 1;
    static final int LABEL_ONLY = 2;
    static final int TICKS = 3;
    static final int TICKS_MAX = 4;
    static final int TICKS_VAL = 5;
    static final int TICKS_VALMAX = 6;
    static final int SPINNER = 7;
    protected int commitStyle = 0;
    protected boolean isUpdating;
    protected String state;
    protected java.util.Map<String, Object> properties = new HashMap<String, Object>();
    protected List<JComponent> m_fields;
    protected String description = "";
    static final char TYPE_DELIMITOR = ';';
    static final char DEF_DELIMITOR = '~';
    static final char STATE_DELIMITOR = '~';
    static final char LINE_DELIMINATOR = '|';
    static final char VALUE_DELIMINATOR = '/';

    public PropertySheet() {
        this("propertysheet;;" + Resources.getString("Editor.PropertySheet.default_command") + ";P;;;;", null);
    }

    public PropertySheet(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.m_definition = st.nextToken();
        this.menuName = st.nextToken();
        String launchKeyToken = st.nextToken("");
        this.commitStyle = st.nextInt(0);
        String red = st.hasMoreTokens() ? st.nextToken() : "";
        String green = st.hasMoreTokens() ? st.nextToken() : "";
        String blue = st.hasMoreTokens() ? st.nextToken() : "";
        String launchKeyStrokeToken = st.nextToken("");
        this.description = st.nextToken("");
        this.backgroundColor = red.equals("") ? null : new Color(this.atoi(red), this.atoi(green), this.atoi(blue));
        this.frame = null;
        this.launchKeyStroke = launchKeyStrokeToken.length() > 0 ? NamedHotKeyConfigurer.decode(launchKeyStrokeToken) : NamedKeyStroke.of(launchKeyToken.length() > 0 ? (char)launchKeyToken.charAt(0) : (char)'P', 128);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetState() {
        return this.state;
    }

    @Override
    public void mySetState(String state) {
        this.state = state;
        this.updateFieldsFromState();
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        String red = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getRed());
        String green = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getGreen());
        String blue = this.backgroundColor == null ? "" : Integer.toString(this.backgroundColor.getBlue());
        String commit = Integer.toString(this.commitStyle);
        se.append(this.m_definition).append(this.menuName).append("").append(commit).append(red).append(green).append(blue).append(this.launchKeyStroke).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        this.launch = new KeyCommand(this.menuName, this.launchKeyStroke, Decorator.getOutermost(this), (TranslatablePiece)this);
        return new KeyCommand[]{this.launch};
    }

    int atoi(String s) {
        int value = 0;
        if (s != null) {
            for (int i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
                value = value * 10 + s.charAt(i) - 48;
            }
        }
        return value;
    }

    int atoiRight(String s) {
        int value = 0;
        if (s != null) {
            int base = 1;
            int i = s.length() - 1;
            while (i >= 0 && Character.isDigit(s.charAt(i))) {
                value += base * (s.charAt(i) - 48);
                --i;
                base *= 10;
            }
        }
        return value;
    }

    private void updateStateFromFields() {
        SequenceEncoder encoder = new SequenceEncoder('~');
        for (JComponent field : this.m_fields) {
            if (field instanceof JTextComponent) {
                encoder.append(((JTextComponent)field).getText().replace('\n', '|'));
                continue;
            }
            if (field instanceof TickPanel) {
                encoder.append(((TickPanel)field).getValue());
                continue;
            }
            encoder.append("Unknown");
        }
        if (encoder.getValue() != null && !encoder.getValue().equals(this.state)) {
            this.mySetState(encoder.getValue());
            GamePiece outer = Decorator.getOutermost(this);
            if (outer.getId() != null) {
                GameModule.getGameModule().sendAndLog(new ChangePiece(outer.getId(), this.oldState, outer.getState()));
            }
        }
    }

    private void updateFieldsFromState() {
        this.isUpdating = true;
        this.properties.clear();
        SequenceEncoder.Decoder defDecoder = new SequenceEncoder.Decoder(this.m_definition, '~');
        SequenceEncoder.Decoder stateDecoder = new SequenceEncoder.Decoder(this.state, '~');
        int iField = 0;
        while (defDecoder.hasMoreTokens()) {
            String name = defDecoder.nextToken();
            if (name.length() != 0) {
                int type = name.charAt(0) - 48;
                name = name.substring(1);
                String value = stateDecoder.nextToken("");
                switch (type) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int index = value.indexOf(47);
                        this.properties.put(name, index > 0 ? value.substring(0, index) : value);
                        break;
                    }
                    default: {
                        this.properties.put(name, value);
                    }
                }
                value = value.replace('|', '\n');
                if (this.frame != null) {
                    JComponent field = this.m_fields.get(iField);
                    if (field instanceof JTextComponent) {
                        JTextComponent tf = (JTextComponent)field;
                        int pos = Math.min(tf.getCaretPosition(), value.length());
                        tf.setText(value);
                        tf.setCaretPosition(pos);
                    } else if (field instanceof TickPanel) {
                        ((TickPanel)field).updateValue(value);
                    }
                }
            }
            ++iField;
        }
        if (this.applyButton != null) {
            this.applyButton.setEnabled(false);
        }
        this.isUpdating = false;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (!this.launch.matches(stroke)) {
            return null;
        }
        if (this.frame == null) {
            String code;
            Map map = this.getMap();
            JComponent view = map != null ? map.getView() : null;
            this.m_fields = new ArrayList<JComponent>();
            Frame parent = null;
            if (map != null) {
                Container topWin = view.getTopLevelAncestor();
                if (topWin instanceof JFrame) {
                    parent = (Frame)topWin;
                }
            } else {
                parent = GameModule.getGameModule().getPlayerWindow();
            }
            this.frame = new PropertySheetDialog(parent);
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane, 20, 30);
            this.frame.add(scroll);
            if (this.commitStyle == 1) {
                this.applyButton = new JButton(Resources.getString("Editor.PropertySheet.apply"));
                this.applyButton.addActionListener(event -> {
                    if (this.applyButton != null) {
                        this.applyButton.setEnabled(false);
                    }
                    this.updateStateFromFields();
                });
                this.applyButton.setMnemonic(65);
                this.applyButton.setEnabled(false);
            }
            DocumentListener changeListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                public void update() {
                    if (PropertySheet.this.isUpdating) {
                        return;
                    }
                    switch (PropertySheet.this.commitStyle) {
                        case 0: {
                            SwingUtilities.invokeLater(() -> PropertySheet.this.updateStateFromFields());
                            break;
                        }
                        case 1: {
                            PropertySheet.this.applyButton.setEnabled(true);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            };
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(1, 3, 1, 3);
            c.gridx = 0;
            c.gridy = 0;
            SequenceEncoder.Decoder defDecoder = new SequenceEncoder.Decoder(this.m_definition, '~');
            SequenceEncoder.Decoder stateDecoder = new SequenceEncoder.Decoder(this.state, '~');
            while (defDecoder.hasMoreTokens() && (code = defDecoder.nextToken()).length() != 0) {
                JComponent field;
                int type = code.charAt(0) - 48;
                String name = code.substring(1);
                switch (type) {
                    case 0: {
                        field = new JTextField(stateDecoder.nextToken(""));
                        ((JTextComponent)field).getDocument().addDocumentListener(changeListener);
                        ((JTextField)field).addActionListener(this.frame);
                        this.m_fields.add(field);
                        break;
                    }
                    case 1: {
                        field = new JTextArea(stateDecoder.nextToken("").replace('|', '\n'));
                        ((JTextComponent)field).getDocument().addDocumentListener(changeListener);
                        this.m_fields.add(field);
                        field = new ScrollPane(field);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        field = new TickPanel(stateDecoder.nextToken(""), type);
                        ((TickPanel)field).addDocumentListener(changeListener);
                        ((TickPanel)field).addActionListener(this.frame);
                        if (this.backgroundColor != null) {
                            field.setBackground(this.backgroundColor);
                        }
                        this.m_fields.add(field);
                        break;
                    }
                    case 7: {
                        JSpinner spinner = new JSpinner();
                        JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
                        textField.setText(stateDecoder.nextToken(""));
                        textField.getDocument().addDocumentListener(changeListener);
                        this.m_fields.add(textField);
                        field = spinner;
                        break;
                    }
                    default: {
                        stateDecoder.nextToken("");
                        field = null;
                        this.m_fields.add(field);
                    }
                }
                int n = c.gridwidth = type == 1 || type == 2 ? 2 : 1;
                if (!name.equals("")) {
                    c.gridx = 0;
                    c.weighty = 0.0;
                    c.weightx = c.gridwidth == 2 ? 1.0 : 0.0;
                    pane.add((Component)new JLabel(this.getTranslation(name)), c);
                    if (c.gridwidth == 2) {
                        ++c.gridy;
                    }
                }
                if (field == null) continue;
                c.weightx = 1.0;
                c.weighty = type == 1 ? 1.0 : 0.0;
                c.gridx = type == 1 ? 0 : 1;
                pane.add((Component)field, c);
                ++c.gridy;
            }
            if (this.backgroundColor != null) {
                pane.setBackground(this.backgroundColor);
            }
            if (this.commitStyle == 1) {
                JButton closeButton = new JButton(Resources.getString("Editor.PropertySheet.close"));
                closeButton.setMnemonic(67);
                closeButton.addActionListener(e -> {
                    this.updateStateFromFields();
                    this.frame.setVisible(false);
                });
                c.gridwidth = 1;
                c.weighty = 0.0;
                c.anchor = 14;
                c.gridwidth = 2;
                c.gridx = 0;
                c.weightx = 0.0;
                JPanel buttonRow = new JPanel();
                buttonRow.add(this.applyButton);
                buttonRow.add(closeButton);
                if (this.backgroundColor != null) {
                    this.applyButton.setBackground(this.backgroundColor);
                    closeButton.setBackground(this.backgroundColor);
                    buttonRow.setBackground(this.backgroundColor);
                }
                pane.add((Component)buttonRow, c);
            }
            Point p = GameModule.getGameModule().getPlayerWindow().getLocation();
            if (map != null && view.isShowing()) {
                p = view.getLocationOnScreen();
                Point p2 = map.mapToComponent(this.getPosition());
                p.translate(p2.x, p2.y);
            }
            this.frame.setLocation(p.x, p.y);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PropertySheet.this.updateStateFromFields();
                }
            });
            this.frame.pack();
        }
        this.frame.setTitle(this.getLocalizedName());
        this.oldState = Decorator.getOutermost(this).getState();
        this.frame.setVisible(true);
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        Object value = this.properties.get(key);
        return value == null ? super.getLocalizedProperty(key) : value;
    }

    @Override
    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        return value == null ? super.getProperty(key) : value;
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.PropertySheet.trait_description", this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.PropertySheet.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PropertySheet.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        ArrayList<String> items = new ArrayList<String>();
        SequenceEncoder.Decoder defDecoder = new SequenceEncoder.Decoder(this.m_definition, '~');
        while (defDecoder.hasMoreTokens()) {
            String item = defDecoder.nextToken();
            items.add(item.length() == 0 ? "" : item.substring(1));
        }
        String[] menuNames = new String[items.size() + 1];
        String[] descriptions = new String[items.size() + 1];
        menuNames[0] = this.menuName;
        descriptions[0] = Resources.getString("Editor.PropertySheet.property_sheet_command");
        int j = 1;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            String s;
            menuNames[j] = s = (String)iterator.next();
            descriptions[j] = Resources.getString("Editor.PropertySheet.property_sheet_item") + " " + j;
            ++j;
        }
        return this.getI18nData(menuNames, descriptions);
    }

    @Override
    public List<String> getPropertyNames() {
        return List.copyOf(this.properties.keySet());
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.launchKeyStroke);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.menuName);
    }

    class PropertySheetDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public PropertySheetDialog(Frame owner) {
            super(owner, false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (PropertySheet.this.applyButton != null) {
                PropertySheet.this.applyButton.setEnabled(false);
            }
            PropertySheet.this.updateStateFromFields();
        }
    }

    class TickPanel
    extends JPanel
    implements ActionListener,
    FocusListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private int numTicks;
        private int maxTicks;
        private final int panelType;
        private JTextField valField;
        private JTextField maxField;
        private final TickLabel ticks;
        private final List<ActionListener> actionListeners;
        private final List<DocumentListener> documentListeners;

        public TickPanel(String value, int type) {
            Dimension minSize;
            super(new GridBagLayout());
            this.actionListeners = new ArrayList<ActionListener>();
            this.documentListeners = new ArrayList<DocumentListener>();
            this.set(value);
            this.panelType = type;
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.ipadx = 1;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            if (this.panelType == 5 || this.panelType == 6) {
                this.valField = new JTextField(Integer.toString(this.numTicks));
                minSize = this.valField.getMinimumSize();
                minSize.width = 24;
                this.valField.setMinimumSize(minSize);
                this.valField.setPreferredSize(minSize);
                this.valField.addActionListener(this);
                this.valField.addFocusListener(this);
                this.add((Component)this.valField, c);
                ++c.gridx;
            }
            if (this.panelType == 4 || this.panelType == 6) {
                this.maxField = new JTextField(Integer.toString(this.maxTicks));
                minSize = this.maxField.getMinimumSize();
                minSize.width = 24;
                this.maxField.setMinimumSize(minSize);
                this.maxField.setPreferredSize(minSize);
                this.maxField.addActionListener(this);
                this.maxField.addFocusListener(this);
                if (this.panelType == 6) {
                    this.add((Component)new JLabel("/"), c);
                    ++c.gridx;
                }
                this.add((Component)this.maxField, c);
                ++c.gridx;
            }
            this.ticks = new TickLabel(this.numTicks, this.maxTicks, this.panelType);
            this.ticks.addActionListener(this);
            c.weightx = 1.0;
            this.add((Component)this.ticks, c);
            this.doLayout();
        }

        public void updateValue(String value) {
            this.set(value);
            this.updateFields();
        }

        private void set(String value) {
            this.set(PropertySheet.this.atoi(value), PropertySheet.this.atoiRight(value));
        }

        private boolean set(int num, int max) {
            boolean changed = false;
            if (this.numTicks == 0 && this.maxTicks == 0 && num == 0 && max > 0) {
                changed = true;
            }
            if (this.numTicks == 0 && this.maxTicks == 0 && max == 0 && num > 0) {
                max = num;
                changed = true;
            }
            this.numTicks = Math.min(max, num);
            this.maxTicks = max;
            return changed;
        }

        public String getValue() {
            this.commitTextFields();
            return Integer.toString(this.numTicks) + "/" + this.maxTicks;
        }

        private void commitTextFields() {
            if ((this.valField != null || this.maxField != null) && this.set(this.valField != null ? PropertySheet.this.atoi(this.valField.getText()) : this.numTicks, this.maxField != null ? PropertySheet.this.atoi(this.maxField.getText()) : this.maxTicks)) {
                this.updateFields();
            }
        }

        private void updateFields() {
            if (this.valField != null) {
                this.valField.setText(Integer.toString(this.numTicks));
            }
            if (this.maxField != null) {
                this.maxField.setText(Integer.toString(this.maxTicks));
            }
            this.ticks.set(this.numTicks, this.maxTicks);
        }

        private boolean areFieldValuesValid() {
            int max = this.maxField == null ? this.maxTicks : PropertySheet.this.atoi(this.maxField.getText());
            int val = this.valField == null ? this.numTicks : PropertySheet.this.atoi(this.valField.getText());
            return val < max && val >= 0;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.maxField || event.getSource() == this.valField) {
                this.commitTextFields();
                this.ticks.set(this.numTicks, this.maxTicks);
                this.fireActionEvent();
            } else if (event.getSource() == this.ticks) {
                this.commitTextFields();
                this.numTicks = this.ticks.getNumTicks();
                if (this.maxField == null) {
                    this.maxTicks = this.ticks.getMaxTicks();
                }
                this.updateFields();
                this.fireDocumentEvent();
            }
        }

        public void addActionListener(ActionListener listener) {
            this.actionListeners.add(listener);
        }

        public void fireActionEvent() {
            for (ActionListener l : this.actionListeners) {
                l.actionPerformed(new ActionEvent(this, 0, null));
            }
        }

        void addDocumentListener(DocumentListener listener) {
            if (this.valField != null) {
                this.valField.getDocument().addDocumentListener(this);
            }
            if (this.maxField != null) {
                this.maxField.getDocument().addDocumentListener(this);
            }
            this.documentListeners.add(listener);
        }

        public void fireDocumentEvent() {
            for (DocumentListener l : this.documentListeners) {
                l.changedUpdate(null);
            }
        }

        @Override
        public void focusLost(FocusEvent event) {
            this.commitTextFields();
            this.ticks.set(this.numTicks, this.maxTicks);
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            if (this.areFieldValuesValid()) {
                this.fireDocumentEvent();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.changedUpdate(event);
        }
    }

    private static class Ed
    implements PieceEditor {
        private final PropertyPanel m_panel = new PropertyPanel();
        private final JTextField descCtrl;
        private final JTextField menuNameCtrl;
        private final NamedHotKeyConfigurer keyStrokeConfig;
        private final JButton colorCtrl;
        private final JTable propertyTable;
        private final JComboBox commitCtrl;
        static final String[] COLUMN_NAMES = new String[]{Resources.getString("Editor.PropertySheet.name"), Resources.getString("Editor.PropertySheet.type")};
        static final String[] DEFAULT_ROW = new String[]{Resources.getString("Editor.PropertySheet.new_property"), Resources.getString("Editor.PropertySheet.text")};

        public Ed(PropertySheet propertySheet) {
            this.descCtrl = this.m_panel.addStringCtrl(Resources.getString("Editor.description_label"), propertySheet.description, "Editor.description_hint");
            this.menuNameCtrl = this.m_panel.addStringCtrl(Resources.getString("Editor.menu_command"), propertySheet.menuName, "Editor.menu_command_hint");
            this.keyStrokeConfig = this.m_panel.addKeyStrokeConfig(propertySheet.launchKeyStroke);
            this.commitCtrl = this.m_panel.addComboBox(Resources.getString("Editor.PropertySheet.commit_on"), COMMIT_VALUES, propertySheet.commitStyle);
            this.colorCtrl = this.m_panel.addColorCtrl(Resources.getString("Editor.PropertySheet.background_color"), propertySheet.backgroundColor);
            DefaultTableModel dataModel = new DefaultTableModel(this.getTableData(propertySheet.m_definition), COLUMN_NAMES);
            this.AddCreateRow(dataModel);
            this.propertyTable = this.m_panel.addTableCtrl(Resources.getString("Editor.PropertySheet.properties"), dataModel, DEFAULT_ROW);
            DefaultCellEditor typePicklist = new DefaultCellEditor(new JComboBox<String>(TYPE_VALUES));
            this.propertyTable.getColumnModel().getColumn(1).setCellEditor(typePicklist);
        }

        protected void AddCreateRow(DefaultTableModel data) {
            data.addRow(DEFAULT_ROW);
        }

        protected String[][] getTableData(String definition) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(definition, '~');
            int numRows = !definition.equals("") && decoder.hasMoreTokens() ? 1 : 0;
            int iDef = -1;
            while ((iDef = definition.indexOf(126, iDef + 1)) >= 0) {
                ++numRows;
            }
            String[][] rows = new String[numRows][2];
            for (int iRow = 0; decoder.hasMoreTokens() && iRow < numRows; ++iRow) {
                String token = decoder.nextToken();
                rows[iRow][0] = token.substring(1);
                rows[iRow][1] = TYPE_VALUES[token.charAt(0) - 48];
            }
            return rows;
        }

        @Override
        public Component getControls() {
            return this.m_panel;
        }

        @Override
        public String getType() {
            String blue;
            String green;
            String red;
            if (this.propertyTable.isEditing()) {
                this.propertyTable.getCellEditor().stopCellEditing();
            }
            SequenceEncoder defEncoder = new SequenceEncoder('~');
            block0: for (int iRow = 0; iRow < this.propertyTable.getRowCount(); ++iRow) {
                String typeString = (String)this.propertyTable.getValueAt(iRow, 1);
                for (int iType = 0; iType < TYPE_VALUES.length; ++iType) {
                    if (!typeString.matches(TYPE_VALUES[iType]) || DEFAULT_ROW[0].equals(this.propertyTable.getValueAt(iRow, 0))) continue;
                    defEncoder.append(Integer.toString(iType) + this.propertyTable.getValueAt(iRow, 0));
                    continue block0;
                }
            }
            SequenceEncoder typeEncoder = new SequenceEncoder(';');
            if (this.colorCtrl.getText().equals(Resources.getString("Editor.PropertySheet.default"))) {
                red = "";
                green = "";
                blue = "";
            } else {
                red = Integer.toString(this.colorCtrl.getBackground().getRed());
                green = Integer.toString(this.colorCtrl.getBackground().getGreen());
                blue = Integer.toString(this.colorCtrl.getBackground().getBlue());
            }
            String definitionString = defEncoder.getValue();
            typeEncoder.append(definitionString == null ? "" : definitionString).append(this.menuNameCtrl.getText()).append("").append(Integer.toString(this.commitCtrl.getSelectedIndex())).append(red).append(green).append(blue).append(this.keyStrokeConfig.getValueString()).append(this.descCtrl.getText());
            return PropertySheet.ID + typeEncoder.getValue();
        }

        @Override
        public String getState() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf('~').repeat(Math.max(0, this.propertyTable.getRowCount())));
            return buf.toString();
        }
    }

    class TickLabel
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        private int numTicks;
        private int maxTicks;
        protected int panelType;
        private final List<ActionListener> actionListeners;
        protected int topMargin;
        protected int leftMargin;
        protected int numRows;
        protected int numCols;
        protected int dx;

        public int getNumTicks() {
            return this.numTicks;
        }

        public int getMaxTicks() {
            return this.maxTicks;
        }

        public void addActionListener(ActionListener listener) {
            this.actionListeners.add(listener);
        }

        public TickLabel(int numTicks, int maxTicks, int panelType) {
            super(" ");
            this.numTicks = 0;
            this.maxTicks = 0;
            this.actionListeners = new ArrayList<ActionListener>();
            this.topMargin = 2;
            this.leftMargin = 2;
            this.dx = 1;
            this.set(numTicks, maxTicks);
            this.panelType = panelType;
            this.addMouseListener(this);
        }

        @Override
        public void paint(Graphics g) {
            int tick;
            if (this.maxTicks <= 0) {
                return;
            }
            ((Graphics2D)g).addRenderingHints(SwingUtils.FONT_HINTS);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int displayWidth = this.getWidth() - 2;
            this.dx = Math.min(displayWidth / this.maxTicks, 10);
            this.numRows = this.dx < 3 ? 3 : (this.dx < 6 ? 2 : 1);
            this.dx = Math.min(displayWidth * this.numRows / this.maxTicks, Math.min(this.getHeight() / this.numRows, 10));
            if (this.dx < 1) {
                this.dx = 1;
            }
            this.numCols = (this.maxTicks + this.numRows - 1) / this.numRows;
            int dy = this.dx;
            this.topMargin = (this.getHeight() - dy * this.numRows + 2) / 2;
            if (this.dx > 4) {
                for (tick = 0; tick < this.maxTicks; ++tick) {
                    int row = tick / this.numCols;
                    int col = tick % this.numCols;
                    g.setColor(Color.BLACK);
                    g.drawRect(this.leftMargin + col * this.dx, this.topMargin + row * dy, this.dx - 3, dy - 3);
                    g.setColor(tick < this.numTicks ? Color.BLACK : Color.WHITE);
                    g.fillRect(this.leftMargin + 1 + col * this.dx, this.topMargin + 1 + row * dy, this.dx - 4, dy - 4);
                }
            } else {
                g.setColor(Color.GRAY);
                g.fillRect(0, this.topMargin - 2, this.numCols * this.dx + this.leftMargin * 2, this.numRows * dy + 4);
                while (tick < this.maxTicks) {
                    int row = tick / this.numCols;
                    int col = tick % this.numCols;
                    g.setColor(tick < this.numTicks ? Color.BLACK : Color.WHITE);
                    g.fillRect(this.leftMargin + col * this.dx, this.topMargin + row * dy, this.dx - 1, dy - 1);
                    ++tick;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.panelType != 6 && (SwingUtils.isMainMouseButtonDown(e) && e.isShiftDown() || SwingUtils.isContextMouseButtonDown(e))) {
                new EditTickLabelValueDialog(this);
            } else if (SwingUtils.isMainMouseButtonDown(e)) {
                int col = Math.min((e.getX() - this.leftMargin + 1) / this.dx, this.numCols - 1);
                int row = Math.min((e.getY() - this.topMargin + 1) / this.dx, this.numRows - 1);
                int num = row * this.numCols + col + 1;
                this.numTicks = num == this.numTicks ? num - 1 : num;
                this.fireActionEvent();
                this.repaint();
            }
        }

        public void fireActionEvent() {
            for (ActionListener l : this.actionListeners) {
                l.actionPerformed(new ActionEvent(this, 0, null));
            }
        }

        public void set(int newNumTicks, int newMaxTicks) {
            this.numTicks = newNumTicks;
            this.maxTicks = newMaxTicks;
            String tip = this.numTicks + "/" + this.maxTicks;
            if (this.panelType != 6) {
                tip = tip + " " + Resources.getString("Editor.PropertySheet.right_edit");
            }
            this.setToolTipText(tip);
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        public class EditTickLabelValueDialog
        extends JPanel
        implements ActionListener,
        DocumentListener,
        FocusListener {
            private static final long serialVersionUID = 1L;
            TickLabel theTickLabel;
            JLayeredPane editorParent;
            JTextField valueField;

            public EditTickLabelValueDialog(TickLabel owner) {
                Container theDialog;
                super(new BorderLayout());
                this.theTickLabel = owner;
                for (theDialog = this.theTickLabel.getParent(); !(theDialog instanceof JDialog) && theDialog != null; theDialog = theDialog.getParent()) {
                }
                if (theDialog != null) {
                    this.editorParent = ((JDialog)theDialog).getLayeredPane();
                    Rectangle newBounds = SwingUtilities.convertRectangle(this.theTickLabel.getParent(), this.theTickLabel.getBounds(), this.editorParent);
                    this.setBounds(newBounds);
                    JButton okButton = new JButton(Resources.getString("General.ok"));
                    switch (TickLabel.this.panelType) {
                        case 5: {
                            this.valueField = new JTextField(Integer.toString(owner.getMaxTicks()));
                            this.valueField.setToolTipText(Resources.getString("Editor.PropertySheet.max_value"));
                            break;
                        }
                        case 4: {
                            this.valueField = new JTextField(Integer.toString(owner.getNumTicks()));
                            this.valueField.setToolTipText(Resources.getString("Editor.PropertySheet.current_value"));
                            break;
                        }
                        default: {
                            this.valueField = new JTextField(owner.numTicks + "/" + owner.maxTicks);
                            this.valueField.setToolTipText(Resources.getString("Editor.PropertySheet.current_max_value"));
                        }
                    }
                    this.valueField.addActionListener(this);
                    this.valueField.addFocusListener(this);
                    this.valueField.getDocument().addDocumentListener(this);
                    this.add((Component)this.valueField, "Center");
                    okButton.addActionListener(this);
                    this.add((Component)okButton, "East");
                    this.editorParent.add((Component)this, JLayeredPane.MODAL_LAYER);
                    this.setVisible(true);
                    this.valueField.grabFocus();
                }
            }

            public void storeValues() {
                String value = this.valueField.getText();
                switch (TickLabel.this.panelType) {
                    case 5: {
                        this.theTickLabel.set(this.theTickLabel.getNumTicks(), PropertySheet.this.atoi(value));
                        break;
                    }
                    case 4: {
                        this.theTickLabel.set(PropertySheet.this.atoi(value), this.theTickLabel.getMaxTicks());
                        break;
                    }
                    default: {
                        this.theTickLabel.set(PropertySheet.this.atoi(value), PropertySheet.this.atoiRight(value));
                    }
                }
                this.theTickLabel.fireActionEvent();
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                this.storeValues();
                this.editorParent.remove(this);
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                this.theTickLabel.fireActionEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                this.theTickLabel.fireActionEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                this.theTickLabel.fireActionEvent();
            }

            @Override
            public void focusGained(FocusEvent event) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                this.storeValues();
            }
        }
    }

    static class PropertyPanel
    extends JPanel
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        GridBagConstraints c = new GridBagConstraints();
        DefaultTableModel tableModel;
        String[] defaultValues;

        public PropertyPanel() {
            super(new GridBagLayout());
            this.c.insets = new Insets(0, 4, 0, 4);
            this.c.anchor = 17;
        }

        public NamedHotKeyConfigurer addKeyStrokeConfig(NamedKeyStroke value) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.add((Component)new JLabel(Resources.getString("Editor.keyboard_command")), this.c);
            ++this.c.gridx;
            this.c.fill = 2;
            this.c.anchor = 17;
            NamedHotKeyConfigurer config = new NamedHotKeyConfigurer(null, "", value);
            Component field = config.getControls();
            this.add(field, this.c);
            return config;
        }

        public JTextField addStringCtrl(String name, String value, String hintKey) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.add((Component)new JLabel(name), this.c);
            this.c.weightx = 1.0;
            HintTextField field = new HintTextField(Resources.getString(hintKey));
            field.setText(value);
            ++this.c.gridx;
            this.c.anchor = 17;
            this.c.fill = 2;
            this.add((Component)field, this.c);
            return field;
        }

        public JButton addColorCtrl(String name, Color value) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.add((Component)new JLabel(name), this.c);
            this.c.weightx = 0.0;
            JButton button = new JButton(Resources.getString("Editor.PropertySheet.default"));
            if (value != null) {
                button.setBackground(value);
                button.setText(Resources.getString("Editor.PropertySheet.sample"));
            }
            button.addActionListener(event -> {
                JButton button1 = (JButton)event.getSource();
                Color value1 = button1.getBackground();
                Color newColor = JColorChooser.showDialog(this, Resources.getString("Editor.PropertySheet.chooser"), value1);
                if (newColor != null) {
                    button1.setBackground(newColor);
                    button1.setText(Resources.getString("Editor.PropertySheet.sample"));
                } else {
                    button1.setBackground(this.getBackground());
                    button1.setText(Resources.getString("Editor.PropertySheet.default"));
                }
            });
            ++this.c.gridx;
            this.c.anchor = 17;
            this.add((Component)button, this.c);
            return button;
        }

        public JComboBox<String> addComboBox(String name, String[] values, int initialRow) {
            JComboBox<String> comboBox = new JComboBox<String>(values);
            comboBox.setEditable(false);
            comboBox.setSelectedIndex(initialRow);
            this.addCtrl(name, comboBox);
            return comboBox;
        }

        public void addCtrl(String name, JComponent ctrl) {
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weightx = 0.0;
            this.c.fill = 0;
            this.add((Component)new JLabel(name), this.c);
            this.c.weightx = 0.0;
            ++this.c.gridx;
            this.add((Component)ctrl, this.c);
        }

        public JTable addTableCtrl(String name, DefaultTableModel theTableModel, String[] theDefaultValues) {
            this.tableModel = theTableModel;
            this.defaultValues = theDefaultValues;
            ++this.c.gridy;
            this.c.gridx = 0;
            this.c.weighty = 0.0;
            this.c.weightx = 1.0;
            this.c.gridwidth = 2;
            this.c.fill = 2;
            this.add((Component)new JLabel(name), this.c);
            ++this.c.gridy;
            this.c.weighty = 1.0;
            this.c.fill = 1;
            SmartTable table = new SmartTable(this.tableModel);
            this.add((Component)new ScrollPane(table), this.c);
            this.c.gridwidth = 1;
            ++this.c.gridy;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.c.gridwidth = 2;
            this.c.weighty = 0.0;
            this.c.weightx = 1.0;
            JPanel buttonPanel = new JPanel();
            JButton addButton = new JButton(Resources.getString("Editor.PropertySheet.insert_row"));
            buttonPanel.add(addButton);
            addButton.addActionListener(e -> {
                int iSelection;
                ListSelectionModel selection;
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
                if ((selection = table.getSelectionModel()).isSelectionEmpty()) {
                    this.tableModel.addRow(this.defaultValues);
                    iSelection = this.tableModel.getRowCount() - 1;
                } else {
                    iSelection = selection.getMaxSelectionIndex();
                    this.tableModel.insertRow(iSelection, this.defaultValues);
                }
                this.tableModel.fireTableDataChanged();
                selection.setSelectionInterval(iSelection, iSelection);
                table.grabFocus();
                table.editCellAt(iSelection, 0);
                Component comp = table.getCellEditor().getTableCellEditorComponent(table, null, true, iSelection, 0);
                if (comp instanceof JComponent) {
                    ((JComponent)comp).grabFocus();
                }
            });
            JButton deleteButton = new JButton(Resources.getString("Editor.PropertySheet.delete_row"));
            deleteButton.setEnabled(false);
            buttonPanel.add(deleteButton);
            deleteButton.addActionListener(e -> {
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
                ListSelectionModel selection = table.getSelectionModel();
                for (int i = selection.getMaxSelectionIndex(); i >= selection.getMinSelectionIndex(); --i) {
                    if (!selection.isSelectedIndex(i)) continue;
                    this.tableModel.removeRow(i);
                }
                this.tableModel.fireTableDataChanged();
            });
            table.getSelectionModel().addListSelectionListener(event -> {
                if (!event.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)event.getSource();
                    deleteButton.setEnabled(!lsm.isSelectionEmpty());
                }
            });
            this.add((Component)buttonPanel, this.c);
            this.c.anchor = 17;
            this.c.weightx = 0.0;
            return table;
        }

        @Override
        public void focusGained(FocusEvent event) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            JTable table;
            if (event.getComponent() instanceof JTable && (table = (JTable)event.getComponent()).isEditing()) {
                table.getCellEditor().stopCellEditing();
            }
        }

        public static class SmartTable
        extends JTable {
            private static final long serialVersionUID = 1L;

            SmartTable(TableModel m) {
                super(m);
                this.setSurrendersFocusOnKeystroke(true);
            }

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Component component;
                if (row == this.getRowCount() - 1) {
                    ((DefaultTableModel)this.getModel()).addRow(Ed.DEFAULT_ROW);
                }
                if ((component = super.prepareEditor(editor, row, column)) instanceof JTextComponent) {
                    ((JTextComponent)component).grabFocus();
                    ((JTextComponent)component).selectAll();
                }
                return component;
            }
        }
    }
}

