/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.KeyStroke;

public class TranslatableMessage
extends Decorator
implements TranslatablePiece {
    public static final char DELIMITER = ';';
    public static final String ID = "locmsg;";
    protected String key;
    protected String description;
    protected String message;
    protected String localisedMessage;

    public TranslatableMessage() {
        this(ID, null);
    }

    public TranslatableMessage(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    @Override
    public void mySetType(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.description = sd.nextToken("");
        this.message = sd.nextToken("");
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Object getProperty(Object key) {
        if (this.key.equals(key)) {
            return this.message;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.key.equals(key)) {
            if (this.localisedMessage != null) {
                return this.localisedMessage;
            }
            this.localisedMessage = this.getI18nData().translate(this.message);
            return this.localisedMessage;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.description);
        se.append(this.message);
        return ID + se.getValue();
    }

    @Override
    public void mySetState(String state) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.TranslatableMessage.trait_description", this.key, this.description);
        if (this.message.length() > 0) {
            s = (String)s + " - " + this.message;
        }
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.TranslatableMessage.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TranslatableMessage.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        return List.of(this.key);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof TranslatableMessage)) {
            return false;
        }
        TranslatableMessage c = (TranslatableMessage)o;
        if (!this.key.equals(c.key)) {
            return false;
        }
        if (!this.description.equals(c.description)) {
            return false;
        }
        return this.message.equals(c.message);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.message}, new String[]{Resources.getString("Editor.TranslatableMessage.message")});
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.message);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.key);
    }

    private static class Ed
    implements PieceEditor {
        private final StringConfigurer propName;
        private final StringConfigurer propDesc;
        private final StringConfigurer propValue;
        private final TraitConfigPanel panel = new TraitConfigPanel();

        private Ed(TranslatableMessage m) {
            this.propDesc = new StringConfigurer(m.description);
            this.panel.add("Editor.TranslatableMessage.description", (Configurer)this.propDesc);
            this.propName = new StringConfigurer(m.key);
            this.panel.add("Editor.TranslatableMessage.property_name", (Configurer)this.propName);
            this.propValue = new StringConfigurer(m.message);
            this.panel.add("Editor.TranslatableMessage.message", (Configurer)this.propValue);
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.propName.getValueString());
            se.append(this.propDesc.getValueString());
            se.append(this.propValue.getValueString());
            return TranslatableMessage.ID + se.getValue();
        }
    }
}

