/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeersSupport;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.PendingPeersSupport;
import org.litesoft.p2pchat.UserDialog;

public class ActivePeerManager
implements ActivePeersSupport,
PendingPeersSupport {
    private MyInfo zMyInfo;
    private UserDialog zUserDialog;
    private PendingPeerManager zPendingPeerManager;
    private Vector<ActivePeer> zListofPeers = new Vector();
    private int zPeerCnt = 0;

    public ActivePeerManager(MyInfo pMyInfo, UserDialog pUserDialog, PendingPeerManager pPendingPeerManager) {
        this.zMyInfo = pMyInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zUserDialog = pUserDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zPendingPeerManager = pPendingPeerManager;
        IllegalArgument.ifNull("PendingPeerManager", this.zPendingPeerManager);
        this.zUserDialog.setActivePeerManager(this);
        this.zPendingPeerManager.start(this);
    }

    @Override
    public synchronized void removeActivePeer(ActivePeer pRequester) {
        IllegalArgument.ifNull("Requester", pRequester);
        this.zListofPeers.removeElement(pRequester);
        pRequester.close();
    }

    public synchronized void clear() {
        while (!this.zListofPeers.isEmpty()) {
            ActivePeer p = this.zListofPeers.lastElement();
            this.zListofPeers.removeElement(p);
            p.close();
        }
    }

    @Override
    public synchronized PeerInfo[] getPeerInfos() {
        PeerInfo[] retval = new PeerInfo[this.zListofPeers.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.zListofPeers.elementAt(i).getPeerInfo();
        }
        return retval;
    }

    public synchronized void sendToAllCHAT(String pMessage) {
        IllegalArgument.ifNull("Message", pMessage);
        Enumeration<ActivePeer> it = this.zListofPeers.elements();
        while (it.hasMoreElements()) {
            it.nextElement().sendCHAT(pMessage);
        }
    }

    public synchronized void sendToAllNAME() {
        Enumeration<ActivePeer> it = this.zListofPeers.elements();
        while (it.hasMoreElements()) {
            it.nextElement().sendNAME();
        }
    }

    public synchronized ActivePeer getPeerListenerByID(String pID) {
        if (pID != null) {
            Enumeration<ActivePeer> it = this.zListofPeers.elements();
            while (it.hasMoreElements()) {
                ActivePeer peer = it.nextElement();
                if (!pID.equals(peer.getPeerInfo().getID())) continue;
                return peer;
            }
        }
        return null;
    }

    public synchronized ActivePeer getPeerListenerByInfo(PeerInfo info) {
        if (info != null) {
            Enumeration<ActivePeer> it = this.zListofPeers.elements();
            while (it.hasMoreElements()) {
                ActivePeer peer = it.nextElement();
                if (!info.equals(peer.getPeerInfo())) continue;
                return peer;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean isAlreadyConnected(PeerInfo pPeerInfo) {
        if (pPeerInfo != null) {
            Enumeration<ActivePeer> it = this.zListofPeers.elements();
            while (it.hasMoreElements()) {
                if (!it.nextElement().getPeerInfo().equals(pPeerInfo)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void addActivePeer(PeerInfo pPeerInfo, InputStream pInputStream, OutputStream pOutputStream) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("InputStream", pInputStream);
        IllegalArgument.ifNull("OutputStream", pOutputStream);
        pPeerInfo.setID(String.valueOf(++this.zPeerCnt));
        this.zListofPeers.addElement(new ActivePeer(this.zMyInfo, this.zUserDialog, (ActivePeersSupport)this, (NewPeersSupport)this.zPendingPeerManager, pPeerInfo, pInputStream, pOutputStream));
    }

    @Override
    public synchronized void addActivePeer(PeerInfo pPeerInfo, PeerReader reader, PeerWriter writer) {
        IllegalArgument.ifNull("PeerInfo", pPeerInfo);
        IllegalArgument.ifNull("PeerReader", reader);
        IllegalArgument.ifNull("PeerWriter", writer);
        pPeerInfo.setID(String.valueOf(++this.zPeerCnt));
        this.zListofPeers.addElement(new ActivePeer(this.zMyInfo, this.zUserDialog, (ActivePeersSupport)this, (NewPeersSupport)this.zPendingPeerManager, pPeerInfo, reader, writer));
    }
}

