/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.Widget;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.search.ImageSearchTarget;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PieceSlot
extends Widget
implements MouseListener,
KeyListener {
    public static final String GP_ID = "gpid";
    public static final String PIECE_PALETTE_SCALE = "ppScale";
    private static final int DEFAULT_SIZE = 64;
    private static final BufferedImage noImage = LabelUtils.noImageBoxImage(64, 64, 1.0);
    protected GamePiece c;
    protected GamePiece expanded;
    protected String pieceDefinition;
    protected static final Font FONT = new Font("Dialog", 2, 12);
    protected final JPanel panel = new Panel(this);
    protected int width;
    protected int height;
    protected String gpId = "";
    protected GpIdSupport gpidSupport;

    public PieceSlot() {
        this.panel.addMouseListener(this);
        this.panel.addKeyListener(this);
    }

    public PieceSlot(PieceSlot piece) {
        this();
        this.copyFrom(piece);
    }

    public PieceSlot(CardSlot card) {
        this((PieceSlot)card);
    }

    public String getName() {
        return this.name;
    }

    public String getPieceDefinition() {
        return this.pieceDefinition;
    }

    @Override
    public double getScale() {
        Widget w = this;
        while ((w = w.getParent()) != null) {
            if (!w.hasScale()) continue;
            return w.getScale();
        }
        return 1.0;
    }

    protected void copyFrom(PieceSlot piece) {
        this.c = piece.c;
        this.name = piece.name;
        this.pieceDefinition = piece.pieceDefinition;
        this.gpidSupport = piece.gpidSupport;
        this.gpId = piece.gpId;
    }

    public boolean isValid() {
        return this.panel.isValid() && this.panel.getGraphics() != null;
    }

    public PieceSlot(GamePiece p) {
        this();
        this.setPiece(p);
    }

    public void setPiece(GamePiece p) {
        this.c = p;
        this.clearExpandedPiece();
        if (this.c != null) {
            Dimension size = this.panel.getSize();
            this.c.setPosition(new Point(size.width / 2, size.height / 2));
            this.name = Decorator.getInnermost(this.c).getName();
        }
        this.panel.revalidate();
        this.panel.repaint();
        this.pieceDefinition = this.c == null ? null : GameModule.getGameModule().encode(new AddPiece(this.c));
    }

    protected GamePiece getExpandedPiece() {
        GamePiece p;
        if (this.expanded == null && (p = this.getPiece()) != null) {
            if (Localization.getInstance().isTranslationComplete()) {
                this.expanded = PieceCloner.getInstance().clonePiece(p);
                return this.expanded;
            }
            return PieceCloner.getInstance().clonePiece(p);
        }
        return this.expanded;
    }

    protected void clearExpandedPiece() {
        this.expanded = null;
    }

    public void clearCache() {
        this.c = null;
        this.expanded = null;
    }

    public GamePiece getPiece() {
        if (this.c == null && this.pieceDefinition != null) {
            AddPiece comm;
            Command raw = GameModule.getGameModule().decode(this.pieceDefinition);
            AddPiece addPiece = comm = raw instanceof AddPiece ? (AddPiece)raw : null;
            if (comm == null || comm.isNull()) {
                ErrorDialog.dataWarning(new BadDataReport("GamePiece - couldn't build piece -", this.pieceDefinition));
                this.pieceDefinition = null;
            } else {
                this.c = comm.getTarget();
                this.c.setState(comm.getState());
                Map map = this.c.getMap();
                if (map != null) {
                    map.removePiece(this.c);
                    this.c.setMap(null);
                }
                Dimension size = this.panel.getSize();
                this.c.setPosition(new Point(size.width / 2, size.height / 2));
            }
        }
        if (this.c != null) {
            this.c.setProperty("PieceId", this.getGpId());
        }
        return this.c;
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        super.addImageNamesRecursively(s);
        GamePiece p = this.getPiece();
        if (p instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)p)).addImageNamesRecursively(s);
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        AffineTransform orig_t = g2d.getTransform();
        g2d.setTransform(SwingUtils.descaleTransform(orig_t));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension size = this.panel.getSize();
        size.width = (int)((double)size.width * os_scale);
        size.height = (int)((double)size.height * os_scale);
        Color c = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c);
        if (this.getExpandedPiece() == null || this.getExpandedPiece().boundingBox().width == 0) {
            BufferedImage noimg = this.getNullImage(os_scale);
            g2d.drawImage((Image)noimg, (size.width - noimg.getWidth()) / 2, (size.height - noimg.getHeight()) / 2, null);
        } else {
            this.getExpandedPiece().draw(g, size.width / 2, size.height / 2, this.panel, os_scale * this.getScale());
            if (Boolean.TRUE.equals(this.getPiece().getProperty("Selected"))) {
                BasicPiece.getHighlighter().draw(this.getExpandedPiece(), g, size.width / 2, size.height / 2, this.panel, os_scale * this.getScale());
            }
        }
        g2d.setTransform(orig_t);
    }

    private BufferedImage getNullImage(double scale) {
        return scale == 1.0 ? noImage : LabelUtils.noImageBoxImage((int)(64.0 * scale), (int)(64.0 * scale), scale);
    }

    public Dimension getPreferredSize() {
        if (this.c != null && this.panel.getGraphics() != null) {
            Dimension bound = this.c.boundingBox().getSize();
            bound.width = (int)((double)(bound.width == 0 ? this.getNullImage(1.0).getWidth() : bound.width) * this.getScale());
            bound.height = (int)((double)(bound.height == 0 ? this.getNullImage(1.0).getHeight() : bound.height) * this.getScale());
            return bound;
        }
        return new Dimension((int)((double)this.getNullImage(1.0).getWidth() * this.getScale()), (int)((double)this.getNullImage(1.0).getHeight() * this.getScale()));
    }

    protected void startDrag() {
        GamePiece p = this.getPiece();
        if (p == null) {
            return;
        }
        KeyBuffer.getBuffer().addFromPalette(p, this);
        DragBuffer.getBuffer().clear();
        if (!this.panel.isShowing()) {
            return;
        }
        Point base = this.panel.getLocationOnScreen();
        for (GamePiece dragPiece : KeyBuffer.getBuffer().asList()) {
            PieceSlot slot = KeyBuffer.getBuffer().getSlotForPiece(dragPiece);
            if (slot == null || !slot.getComponent().isShowing()) continue;
            Dimension size = slot.getComponent().getSize();
            GamePiece piece = slot.getPiece();
            Point loc = slot.getComponent().getLocationOnScreen();
            piece.setPosition(new Point((int)((loc.getX() - base.getX()) / this.getScale()) + size.width / 2, (int)((loc.getY() - base.getY()) / this.getScale()) + size.height / 2));
            GamePiece inner = Decorator.getInnermost(piece);
            if (inner instanceof BasicPiece) {
                ((BasicPiece)inner).setPersistentProperty(PIECE_PALETTE_SCALE, this.getScale());
            }
            GamePiece newPiece = PieceCloner.getInstance().clonePiece(piece);
            newPiece.setProperty("PieceId", this.getGpId());
            DragBuffer.getBuffer().add(newPiece);
        }
    }

    protected void doPopup(MouseEvent e) {
        JPopupMenu popup = MenuDisplayer.createPopup(this.getPiece());
        if (popup != null) {
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    PieceSlot.this.panel.repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    PieceSlot.this.clearExpandedPiece();
                    PieceSlot.this.panel.repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            popup.show(this.panel, e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        } else if (SwingUtils.isMainMouseButtonDown(e)) {
            Map.clearActiveMap();
            if (this.getPiece() != null) {
                if (!SwingUtils.isSelectionToggle(e) && !e.isShiftDown()) {
                    if (!KeyBuffer.getBuffer().contains(this.getPiece())) {
                        KeyBuffer.getBuffer().clear();
                    }
                    KeyBuffer.getBuffer().addFromPalette(this.getPiece(), this);
                } else if (e.isShiftDown()) {
                    KeyBuffer.getBuffer().addFromPalette(this.getPiece(), this);
                } else if (SwingUtils.isSelectionToggle(e)) {
                    if (KeyBuffer.getBuffer().contains(this.getPiece())) {
                        KeyBuffer.getBuffer().removeFromPalette(this.getPiece(), this);
                    } else {
                        KeyBuffer.getBuffer().addFromPalette(this.getPiece(), this);
                    }
                }
            } else if (!e.isShiftDown() && !SwingUtils.isSelectionToggle(e)) {
                KeyBuffer.getBuffer().clear();
            }
            this.clearExpandedPiece();
            this.panel.requestFocus();
            this.panel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean doClear = false;
        if (e.isPopupTrigger()) {
            if (this.getPiece() != null) {
                this.doPopup(e);
            }
            doClear = true;
        } else if (SwingUtils.isMainMouseButtonDown(e)) {
            doClear = true;
        }
        if (doClear) {
            this.clearExpandedPiece();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
            return;
        }
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PieceSlot.component_type");
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void build(Element e) {
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
        if (e != null) {
            this.name = e.getAttribute("entryName");
            this.gpId = e.getAttribute(GP_ID);
            if (this.name.length() == 0) {
                this.name = null;
            }
            try {
                this.width = Integer.parseInt(e.getAttribute("width"));
                this.height = Integer.parseInt(e.getAttribute("height"));
            }
            catch (NumberFormatException ex) {
                this.width = 64;
                this.height = 64;
            }
            this.pieceDefinition = Builder.getText(e);
            this.c = null;
        }
    }

    @Override
    public void addTo(Buildable par) {
        if (par instanceof Widget) {
            this.parent = (Widget)par;
        }
        this.panel.setDropTarget(PieceMover.AbstractDragHandler.makeDropTarget(this.panel, 2, null));
        DragGestureListener dragGestureListener = dge -> {
            if (SwingUtils.isDragTrigger(dge)) {
                this.startDrag();
                PieceMover.AbstractDragHandler.getTheDragHandler().dragGestureRecognized(dge);
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.panel, 2, dragGestureListener);
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String s = this.getConfigureName();
        if (s != null) {
            el.setAttribute("entryName", s);
        }
        el.setAttribute(GP_ID, this.gpId);
        el.setAttribute("width", Integer.toString(this.getPreferredSize().width));
        el.setAttribute("height", Integer.toString(this.getPreferredSize().height));
        if (this.c != null || this.pieceDefinition != null) {
            el.appendChild(doc.createTextNode(this.c == null ? this.pieceDefinition : GameModule.getGameModule().encode(new AddPiece(this.c))));
        }
        return el;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public String getConfigureName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.getPiece() != null) {
            return Decorator.getOutermost(this.getExpandedPiece()).getName();
        }
        return this.name;
    }

    @Override
    public String getLocalizedConfigureName() {
        String translatedName = Decorator.getOutermost(this.getExpandedPiece()).getLocalizedName();
        return translatedName == null || translatedName.isBlank() ? super.getLocalizedConfigureName() : translatedName;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.html");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String getAttributeValueString(String attr) {
        return this.getI18nData().getLocalUntranslatedValue(attr);
    }

    @Override
    public ComponentI18nData getI18nData() {
        return new ComponentI18nData((Configurable)this, this.getPiece());
    }

    @Override
    public Configurer getConfigurer() {
        return new MyConfigurer(this);
    }

    public void updateGpId(GpIdSupport s) {
        this.gpidSupport = s;
        this.updateGpId();
    }

    public void setGpidSupport(GpIdSupport s) {
        this.gpidSupport = s;
    }

    public void updateGpId() {
        this.gpId = this.gpidSupport.generateGpId();
        GamePiece piece = this.getPiece();
        this.updateGpId(piece);
        this.setPiece(piece);
    }

    public void updateGpId(GamePiece piece) {
        if (piece == null || piece instanceof BasicPiece) {
            return;
        }
        if (piece instanceof PlaceMarker) {
            ((PlaceMarker)piece).setGpId(this.gpidSupport.generateGpId());
        }
        this.updateGpId(((Decorator)piece).getInner());
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String id) {
        this.gpId = id;
    }

    public class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected final PieceSlot pieceSlot;

        public Panel(PieceSlot slot) {
            this.setFocusTraversalKeysEnabled(false);
            this.pieceSlot = slot;
        }

        public PieceSlot getPieceSlot() {
            return this.pieceSlot;
        }

        @Override
        public void paint(Graphics g) {
            PieceSlot.this.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return PieceSlot.this.getPreferredSize();
        }
    }

    private static class MyConfigurer
    extends Configurer {
        private final PieceDefiner definer;

        public MyConfigurer(PieceSlot slot) {
            super(null, slot.getConfigureName(), slot);
            this.definer = new PieceDefiner(slot.getGpId(), slot.gpidSupport);
            this.definer.setPiece(slot.getPiece());
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
            throw new UnsupportedOperationException("Cannot set from String");
        }

        @Override
        public Object getValue() {
            PieceSlot slot = (PieceSlot)super.getValue();
            if (slot != null) {
                slot.setPiece(this.definer.getPiece());
            }
            return slot;
        }

        @Override
        public Component getControls() {
            return this.definer;
        }

        @Override
        public void initCustomControls(JDialog d, Configurable target) {
            if (this.definer != null) {
                this.definer.initCustomControls(d, target);
            }
        }
    }
}

