/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang3.SystemUtils;

public class SwingUtils {
    private static boolean macLegacy = true;
    public static final Map<?, ?> FONT_HINTS = GraphicsEnvironment.isHeadless() || Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints") == null ? Collections.emptyMap() : (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private static final InputClassifier INPUT_CLASSIFIER = SystemUtils.IS_OS_MAC ? new MacInputClassifier() : new DefaultInputClassifier();

    public static boolean isMacLegacy() {
        return macLegacy;
    }

    public static void setMacLegacy(boolean b) {
        macLegacy = b;
    }

    public static AffineTransform descaleTransform(AffineTransform t) {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, t.getTranslateX(), t.getTranslateY());
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static boolean isLeftMouseButton(MouseEvent e) {
        return INPUT_CLASSIFIER.isMainMouseButtonDown(e);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static boolean isRightMouseButton(MouseEvent e) {
        return INPUT_CLASSIFIER.isContextMouseButtonDown(e);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static boolean isControlDown(MouseEvent e) {
        return INPUT_CLASSIFIER.isSelectionToggle(e);
    }

    public static boolean isContextMouseButtonDown(MouseEvent e) {
        return INPUT_CLASSIFIER.isContextMouseButtonDown(e);
    }

    public static boolean isMainMouseButtonDown(MouseEvent e) {
        return INPUT_CLASSIFIER.isMainMouseButtonDown(e);
    }

    public static boolean isSelectionToggle(MouseEvent e) {
        return INPUT_CLASSIFIER.isSelectionToggle(e);
    }

    public static boolean isModifierKeyDown(KeyEvent e) {
        return INPUT_CLASSIFIER.isModifierKeyDown(e);
    }

    public static int getModifierKeyMask() {
        return INPUT_CLASSIFIER.getModifierKeyMask();
    }

    public static KeyStroke systemToGeneric(KeyStroke k) {
        return INPUT_CLASSIFIER.systemToGeneric(k);
    }

    public static KeyStroke genericToSystem(KeyStroke k) {
        return INPUT_CLASSIFIER.genericToSystem(k);
    }

    public static KeyStroke getKeyStrokeForEvent(KeyEvent e) {
        return SwingUtils.systemToGeneric(KeyStroke.getKeyStrokeForEvent(e));
    }

    public static boolean isDragTrigger(DragGestureEvent e) {
        InputEvent te = e.getTriggerEvent();
        return !(te instanceof MouseEvent) || SwingUtils.isMainMouseButtonDown((MouseEvent)te);
    }

    public static KeyEvent convertKeyEvent(KeyEvent e) {
        if (SystemUtils.IS_OS_MAC && e.isAltGraphDown()) {
            return new KeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), (e.getModifiersEx() | 0x200) & 0xFFFFDFFF, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
        }
        return e;
    }

    public static Rectangle getScreenBounds(Component c) {
        Rectangle bounds = new Rectangle(SwingUtils.getScreenSize());
        Insets insets = SwingUtils.getScreenInsets(c);
        bounds.translate(insets.left, insets.top);
        bounds.setSize(bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        return bounds;
    }

    public static int getIndexInParent(Component child, Container parent) {
        if (parent != null) {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (child != parent.getComponent(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Dimension getScreenSize() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(1920, 1280);
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Insets getScreenInsets(Component c) {
        if (GraphicsEnvironment.isHeadless()) {
            return new Insets(0, 0, 0, 0);
        }
        return Toolkit.getDefaultToolkit().getScreenInsets(c.getGraphicsConfiguration());
    }

    public static void ensureOnScreen(Window window) {
        if (window == null) {
            return;
        }
        Rectangle screenBounds = SwingUtils.getScreenBounds(window);
        window.setMaximumSize(new Dimension(screenBounds.width, screenBounds.height));
        Dimension windowSize = window.getSize();
        if (windowSize.width > screenBounds.width || windowSize.height > screenBounds.height) {
            windowSize.width = Math.min(screenBounds.width, windowSize.width);
            windowSize.height = Math.min(screenBounds.height, windowSize.height);
            window.setSize(windowSize);
        }
        Rectangle bounds = new Rectangle(window.getX(), window.getY(), windowSize.width, windowSize.height);
        if (bounds.y < screenBounds.y) {
            bounds.y = screenBounds.y;
        }
        if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
            bounds.y = screenBounds.y + screenBounds.height - bounds.height;
        }
        if (bounds.x < screenBounds.x) {
            bounds.x = screenBounds.x;
        }
        if (bounds.x + bounds.width > screenBounds.x + screenBounds.width) {
            bounds.x = screenBounds.x + screenBounds.width - bounds.width;
        }
        window.setLocation(bounds.x, bounds.y);
    }

    public static void repack(Component c) {
        if (c != null) {
            SwingUtils.repack(SwingUtilities.getWindowAncestor(c));
        }
    }

    public static void repack(Window w) {
        SwingUtils.repack(w, false);
    }

    public static void repack(Window w, boolean mayBecomeNarrower) {
        if (w != null) {
            Dimension min = w.getSize();
            min.height = 1;
            min.width = mayBecomeNarrower ? 1 : min.width;
            w.setMinimumSize(min);
            w.pack();
            w.setMinimumSize(new Dimension(0, 0));
            SwingUtils.ensureOnScreen(w);
        }
    }

    public static void setDefaultButtons(JRootPane rp, JButton ok, final JButton cancel) {
        if (ok != null) {
            rp.setDefaultButton(ok);
        }
        if (cancel != null) {
            rp.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
            rp.getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cancel.doClick();
                }
            });
        }
    }

    public static UndoManager allowUndo(JTextComponent field) {
        final UndoManager um = new UndoManager();
        field.getDocument().addUndoableEditListener(um);
        field.getInputMap(0).put(KeyStroke.getKeyStroke(90, SwingUtils.getModifierKeyMask()), "Undo");
        field.getActionMap().put("Undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (um.canUndo()) {
                    um.undo();
                }
            }
        });
        field.getInputMap(0).put(KeyStroke.getKeyStroke(90, SwingUtils.getModifierKeyMask() + 64), "Redo");
        field.getActionMap().put("Redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (um.canRedo()) {
                    um.redo();
                }
            }
        });
        return um;
    }

    private static interface InputClassifier {
        public boolean isContextMouseButtonDown(MouseEvent var1);

        public boolean isMainMouseButtonDown(MouseEvent var1);

        public boolean isSelectionToggle(MouseEvent var1);

        public boolean isModifierKeyDown(KeyEvent var1);

        public int getModifierKeyMask();

        public KeyStroke systemToGeneric(KeyStroke var1);

        public KeyStroke genericToSystem(KeyStroke var1);
    }

    private static class MacInputClassifier
    implements InputClassifier {
        private static final int B1_MASK = 1152;

        private MacInputClassifier() {
        }

        @Override
        public boolean isContextMouseButtonDown(MouseEvent e) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: {
                    return e.getButton() == 3 || e.getButton() == 1 && (e.getModifiersEx() & (macLegacy ? 256 : 128)) != 0;
                }
                case 504: 
                case 505: 
                case 506: {
                    return (e.getModifiersEx() & 0x1000) != 0 || (e.getModifiersEx() & 0x480) == 1152;
                }
            }
            return (e.getModifiersEx() & 0x1000) != 0 || (e.getModifiersEx() & 0x480) == 1152 || e.getButton() == 3 || e.getButton() == 1 && (e.getModifiersEx() & (macLegacy ? 256 : 128)) != 0;
        }

        @Override
        public boolean isMainMouseButtonDown(MouseEvent e) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: {
                    return e.getButton() == 1 && (e.getModifiersEx() & (macLegacy ? 256 : 128)) == 0;
                }
                case 504: 
                case 505: 
                case 506: {
                    return (e.getModifiersEx() & 0x480) == 1024;
                }
            }
            return (e.getModifiersEx() & 0x480) == 1024 || e.getButton() == 1 && (e.getModifiersEx() & (macLegacy ? 256 : 128)) == 0;
        }

        @Override
        public boolean isSelectionToggle(MouseEvent e) {
            return e.isMetaDown();
        }

        @Override
        public boolean isModifierKeyDown(KeyEvent e) {
            return e.isMetaDown();
        }

        @Override
        public int getModifierKeyMask() {
            return 256;
        }

        @Override
        public KeyStroke systemToGeneric(KeyStroke k) {
            if (macLegacy) {
                return k;
            }
            int modifiers = k.getModifiers();
            if ((modifiers & 0x100) != 0) {
                modifiers &= 0xFFFFFEFB;
                return KeyStroke.getKeyStroke(k.getKeyCode(), modifiers |= 0x80, k.isOnKeyRelease());
            }
            if ((modifiers & 0x80) != 0) {
                return KeyStroke.getKeyStroke(k.getKeyCode(), modifiers &= 0xFFFFFF7D, k.isOnKeyRelease());
            }
            return k;
        }

        @Override
        public KeyStroke genericToSystem(KeyStroke k) {
            if (macLegacy) {
                return k;
            }
            int modifiers = k.getModifiers();
            if ((modifiers & 0x80) != 0) {
                modifiers &= 0xFFFFFF7D;
                return KeyStroke.getKeyStroke(k.getKeyCode(), modifiers |= 0x100, k.isOnKeyRelease());
            }
            return k;
        }
    }

    private static class DefaultInputClassifier
    implements InputClassifier {
        private DefaultInputClassifier() {
        }

        @Override
        public boolean isContextMouseButtonDown(MouseEvent e) {
            return SwingUtilities.isRightMouseButton(e);
        }

        @Override
        public boolean isMainMouseButtonDown(MouseEvent e) {
            return SwingUtilities.isLeftMouseButton(e);
        }

        @Override
        public boolean isSelectionToggle(MouseEvent e) {
            return e.isControlDown();
        }

        @Override
        public boolean isModifierKeyDown(KeyEvent e) {
            return e.isControlDown();
        }

        @Override
        public int getModifierKeyMask() {
            return 128;
        }

        @Override
        public KeyStroke systemToGeneric(KeyStroke k) {
            return k;
        }

        @Override
        public KeyStroke genericToSystem(KeyStroke k) {
            return k;
        }
    }
}

