/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.Info;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Translation;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.ZipWriter;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMetaData.class);
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String NAME_ATTR = "name";
    protected static final String VERSION_ATTR = "version";
    protected static final String VASSAL_VERSION_ATTR = "vassalVersion";
    protected static final String DESCRIPTION_ATTR = "description";
    protected static final String EXTENSION_ATTR = "extension";
    protected static final String MODULE_NAME_ATTR = "moduleName";
    protected static final String MODULE_VERSION_ATTR = "moduleVersion";
    protected static final String LANG_ATTR = "lang";
    protected static final String ROOT_ELEMENT = "data";
    protected static final String VERSION_ELEMENT = "version";
    protected static final String VASSAL_VERSION_ELEMENT = "VassalVersion";
    protected static final String MODULE_NAME_ELEMENT = "moduleName";
    protected static final String MODULE_VERSION_ELEMENT = "moduleVersion";
    protected static final String DESCRIPTION_ELEMENT = "description";
    protected static final String NAME_ELEMENT = "name";
    protected static final String DATE_SAVED_ELEMENT = "dateSaved";
    protected static final String CHECKSUM_ELEMENT = "checksum";
    protected static final String BUILDFILE_MODULE_ELEMENT1 = "VASSAL.launch.BasicModule";
    protected static final String BUILDFILE_MODULE_ELEMENT2 = "VASSAL.build.GameModule";
    protected static final String BUILDFILE_EXTENSION_ELEMENT = "VASSAL.build.module.ModuleExtension";
    protected String version;
    protected String vassalVersion;
    protected Attribute descriptionAttr;
    protected String lastSaved;
    protected static final XMLReader parser = AbstractMetaData.createParser();

    public AbstractMetaData() {
        this.setVassalVersion(Info.getVersion());
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    public String getVassalVersion() {
        return this.vassalVersion == null ? "" : this.vassalVersion;
    }

    public void setVassalVersion(String s) {
        this.vassalVersion = s;
    }

    public void setDescription(Attribute desc) {
        this.descriptionAttr = desc;
    }

    public void setDescription(String desc) {
        this.descriptionAttr = new Attribute("description", desc);
    }

    public String getDescription() {
        return this.descriptionAttr == null ? "" : this.descriptionAttr.getValue();
    }

    public String getLocalizedDescription() {
        return this.descriptionAttr == null ? "" : this.descriptionAttr.getLocalizedValue();
    }

    public String getLastSaved() {
        return this.lastSaved;
    }

    public void setLastSaved(String lastSaved) {
        this.lastSaved = lastSaved;
    }

    public String formatLastSaved() {
        try {
            Date date = new Date(Long.parseLong(this.getLastSaved()));
            SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yy", Locale.getDefault());
            format.setTimeZone(TimeZone.getDefault());
            return format.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void save(FileArchive archive) throws IOException {
        try (OutputStream out = archive.getOutputStream(this.getZipEntryName());){
            this.save(out);
        }
    }

    protected void save(OutputStream out) throws IOException {
        Document doc;
        try {
            Element e;
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(ROOT_ELEMENT);
            root.setAttribute("version", this.getMetaDataVersion());
            doc.appendChild(root);
            if (this.getVersion() != null) {
                e = doc.createElement("version");
                e.appendChild(doc.createTextNode(this.getVersion()));
                root.appendChild(e);
            }
            if (this.getVassalVersion() != null) {
                e = doc.createElement(VASSAL_VERSION_ELEMENT);
                e.appendChild(doc.createTextNode(this.getVassalVersion()));
                root.appendChild(e);
            }
            e = doc.createElement(DATE_SAVED_ELEMENT);
            e.appendChild(doc.createTextNode(String.valueOf(System.currentTimeMillis())));
            root.appendChild(e);
            if (this.descriptionAttr != null) {
                this.descriptionAttr.generateXML(doc, root, "description");
            }
            this.addElements(doc, root);
        }
        catch (ParserConfigurationException ex) {
            ErrorDialog.bug(ex);
            throw new IOException(ex);
        }
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError ex) {
            ErrorDialog.bug(ex);
            throw new IOException(ex);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    public void save(ArchiveWriter archive) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.save(out);
        archive.addFile(this.getZipEntryName(), out.toInputStream());
    }

    public void save(ZipWriter zw) throws IOException {
        try (OutputStream out = zw.write(this.getZipEntryName());){
            this.save(out);
        }
    }

    public void copyModuleMetadata(ArchiveWriter archive) throws IOException {
        this.copyModuleMetadata(archive.getArchive());
    }

    public void copyModuleMetadata(FileArchive archive) throws IOException {
        DataArchive mda = GameModule.getGameModule().getDataArchive();
        try (InputStream inner = mda.getInputStream("moduledata");
             BufferedInputStream in = new BufferedInputStream(inner);){
            archive.add("moduledata", in);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            new ModuleMetaData(GameModule.getGameModule()).save(archive);
        }
    }

    public void copyModuleMetadata(ZipWriter zw) throws IOException {
        DataArchive mda = GameModule.getGameModule().getDataArchive();
        try (InputStream in = mda.getInputStream("moduledata");){
            zw.write(in, "moduledata");
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            new ModuleMetaData(GameModule.getGameModule()).save(zw);
        }
    }

    public abstract String getZipEntryName();

    public abstract String getMetaDataVersion();

    protected abstract void addElements(Document var1, Element var2);

    private static XMLReader createParser() {
        try {
            return SAXParserFactory.newDefaultInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    static class Attribute {
        protected String attributeName;
        protected String value;
        protected Map<String, String> translations = new HashMap<String, String>();

        public Attribute(Configurable target, String name) {
            this.attributeName = name;
            this.value = target.getAttributeValueString(this.attributeName);
            Object key = target.getI18nData().getFullPrefix();
            if (((String)key).length() > 0) {
                key = (String)key + ".";
            }
            key = (String)key + this.attributeName;
            for (Translation t : GameModule.getGameModule().getAllDescendantComponentsOf(Translation.class)) {
                this.addTranslation(t.getLanguageCode(), t.translate((String)key));
            }
        }

        public Attribute(String attributeName, String value) {
            this.attributeName = attributeName;
            this.value = value;
        }

        public void addTranslation(String language, String value) {
            if (value != null) {
                this.translations.put(language, value);
            }
        }

        public String getValue() {
            return this.value;
        }

        public String getLocalizedValue() {
            String lang = Locale.getDefault().getLanguage();
            String tx = this.translations.get(lang);
            return tx == null ? this.getValue() : tx;
        }

        public void generateXML(Document doc, Element root, String prefix) {
            if (this.value == null) {
                return;
            }
            Element e = doc.createElement(prefix);
            e.appendChild(doc.createTextNode(this.value));
            root.appendChild(e);
            for (Map.Entry<String, String> en : this.translations.entrySet()) {
                e = doc.createElement(prefix);
                e.setAttribute(AbstractMetaData.LANG_ATTR, en.getValue());
                e.appendChild(doc.createTextNode(en.getKey()));
                root.appendChild(e);
            }
        }
    }

    class BuildFileXMLHandler
    extends DefaultHandler {
        final StringBuilder accumulator = new StringBuilder();

        BuildFileXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXEndException {
            this.accumulator.setLength(0);
        }

        protected String getAttr(Attributes attrs, String qName) {
            String value = attrs.getValue(qName);
            return value == null ? "" : value;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            logger.warn("", (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            logger.error("", (Throwable)e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    class XMLHandler
    extends DefaultHandler {
        final StringBuilder accumulator = new StringBuilder();
        protected String language = "";

        XMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) {
            this.accumulator.setLength(0);
            this.language = this.getAttr(attrs, AbstractMetaData.LANG_ATTR);
        }

        protected String getAttr(Attributes attrs, String qName) {
            String value = attrs.getValue(qName);
            return value == null ? "" : value;
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String value = this.accumulator.toString().trim();
            if ("version".equals(qName)) {
                AbstractMetaData.this.setVersion(value);
            } else if (AbstractMetaData.VASSAL_VERSION_ELEMENT.equals(qName)) {
                AbstractMetaData.this.setVassalVersion(value);
            } else if ("description".equals(qName)) {
                if (AbstractMetaData.this.descriptionAttr == null) {
                    AbstractMetaData.this.setDescription(new Attribute("description", value));
                } else {
                    AbstractMetaData.this.descriptionAttr.addTranslation(this.language, value);
                }
            } else if (AbstractMetaData.DATE_SAVED_ELEMENT.equals(qName)) {
                AbstractMetaData.this.setLastSaved(value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.accumulator.append(ch, start, length);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            logger.warn("", (Throwable)e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            logger.error("", (Throwable)e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    static class SAXEndException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        SAXEndException() {
        }
    }
}

