/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.commons.lang3.SystemUtils;

public class ApplicationIcons {
    public static final String VASSAL_ICON_LARGE = "VASSAL-256x256.png";
    private static final List<BufferedImage> icons;

    private ApplicationIcons() {
    }

    public static void setFor(JFrame w) {
        if (icons != null) {
            w.setIconImages(icons);
        }
    }

    public static void setFor(JDialog w) {
        if (icons != null) {
            w.setIconImages(icons);
        }
    }

    static {
        if (SystemUtils.IS_OS_MAC) {
            icons = null;
        } else {
            List<BufferedImage> l = null;
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    BufferedImage src = ImageUtils.getImageResource("/icons/22x22/VASSAL.png");
                    BufferedImage dst = ImageUtils.createCompatibleTranslucentImage(24, 24);
                    Graphics2D g = dst.createGraphics();
                    g.drawImage((Image)src, 1, 1, null);
                    g.dispose();
                    l = Arrays.asList(ImageUtils.getImageResource("/icons/16x16/VASSAL.png"), dst, ImageUtils.getImageResource("/icons/32x32/VASSAL.png"), ImageUtils.getImageResource("/icons/48x48/VASSAL.png"), ImageUtils.getImageResource("/images/VASSAL-256x256.png"));
                } else {
                    l = Arrays.asList(ImageUtils.getImageResource("/icons/16x16/VASSAL.png"), ImageUtils.getImageResource("/icons/22x22/VASSAL.png"), ImageUtils.getImageResource("/icons/32x32/VASSAL.png"), ImageUtils.getImageResource("/icons/48x48/VASSAL.png"));
                }
            }
            catch (ImageIOException e) {
                ReadErrorDialog.error((IOException)e, e.getFile());
            }
            icons = l;
        }
    }
}

