/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractToolbarItem
extends AbstractConfigurable
implements GameComponent,
PropertyChangeListener {
    public static final String NAME = "name";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "text";
    public static final String HOTKEY = "hotkey";
    public static final String ICON = "icon";
    public static final String CAN_DISABLE = "canDisable";
    public static final String PROPERTY_GATE = "propertyGate";
    public static final String DISABLED_ICON = "disabledIcon";
    public static final String HIDE_WHEN_DISABLED = "hideWhenDisabled";
    protected LaunchButton launch;
    protected IconConfigurer disabledIconConfig = new IconConfigurer("disabledIcon", null, null);
    protected boolean showDisabledOptions = true;
    protected boolean canDisable = false;
    protected boolean hideWhenDisabled = false;
    protected String propertyGate = "";
    protected MutableProperty.Impl property;
    private String nameKey = "name";
    private String tooltipKey = "tooltip";
    private String buttonTextKey = "text";
    private String hotKeyKey = "hotkey";
    private String iconKey = "icon";
    private String namePrompt = "";

    protected void setNamePrompt(String namePrompt) {
        this.namePrompt = namePrompt;
    }

    protected void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    protected String getNameKey() {
        return this.nameKey;
    }

    protected void setTooltipKey(String tooltipKey) {
        this.tooltipKey = tooltipKey;
    }

    protected void setButtonTextKey(String buttonTextKey) {
        this.buttonTextKey = buttonTextKey;
    }

    protected void setHotKeyKey(String hotKeyKey) {
        this.hotKeyKey = hotKeyKey;
    }

    protected void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    protected void setShowDisabledOptions(boolean show) {
        this.showDisabledOptions = show;
    }

    public boolean isShowDisabledOptions() {
        return this.showDisabledOptions;
    }

    protected LaunchButton makeLaunchButton(String tooltip, String button_text, String iconFile, ActionListener action) {
        this.launch = new LaunchButton(button_text, this.tooltipKey, this.buttonTextKey, this.hotKeyKey, this.iconKey, action, true);
        if (!tooltip.isEmpty()) {
            this.setAttribute(this.tooltipKey, tooltip);
        }
        if (!button_text.isEmpty()) {
            if (!this.nameKey.isEmpty()) {
                this.setAttribute(this.nameKey, button_text);
            }
            this.launch.setAttribute(this.buttonTextKey, button_text);
        }
        if (!iconFile.isEmpty()) {
            this.setAttribute(this.iconKey, iconFile);
        }
        this.launch.setDisabledIcon(this.disabledIconConfig.getIconValue());
        this.checkDisabled();
        return this.launch;
    }

    public LaunchButton getLaunchButton() {
        return this.launch;
    }

    protected void setLaunchButton(LaunchButton launch) {
        this.launch = launch;
    }

    protected void addPropertyGateListener() {
        this.addPropertyGateListener(false);
    }

    protected void addPropertyGateListener(boolean dontCheck) {
        if (this.property != null) {
            this.removePropertyGateListener();
        }
        if (this.isShowDisabledOptions() && this.canDisable && !this.propertyGate.isEmpty()) {
            Buildable ancestor = this.getNonFolderAncestor();
            MutableProperty.Impl impl = this.property = ancestor instanceof Map ? (MutableProperty.Impl)((Map)ancestor).getMutableProperty(this.propertyGate) : null;
            if (this.property == null) {
                this.property = (MutableProperty.Impl)GameModule.getGameModule().getMutableProperty(this.propertyGate);
            }
            if (this.property != null) {
                this.property.addMutablePropertyChangeListener(this);
            }
        }
        if (!dontCheck) {
            this.checkDisabled();
        }
    }

    protected void removePropertyGateListener() {
        if (this.property != null) {
            this.property.removeMutablePropertyChangeListener(this);
            this.property = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals(this.propertyGate)) {
            String value = String.valueOf(evt.getNewValue());
            this.disableIfTrue("true".equals(value));
        }
    }

    public void checkDisabled() {
        if (!(this.isShowDisabledOptions() && this.canDisable || this.launch == null)) {
            this.launch.setEnabled(true);
            return;
        }
        if (this.property == null && !this.propertyGate.isEmpty()) {
            this.addPropertyGateListener(true);
        }
        if (this.property != null) {
            this.disableIfTrue("true".equals(this.property.getPropertyValue()));
        }
    }

    public void disableIfTrue(boolean disable) {
        if (this.launch != null) {
            this.launch.setEnabled(!this.isShowDisabledOptions() || !this.canDisable || !disable);
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        this.addPropertyGateListener();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public String[] getAttributeNames() {
        if (!this.nameKey.isEmpty()) {
            return new String[]{this.nameKey, this.buttonTextKey, this.tooltipKey, this.iconKey, this.hotKeyKey, CAN_DISABLE, PROPERTY_GATE, HIDE_WHEN_DISABLED, DISABLED_ICON};
        }
        return new String[]{this.buttonTextKey, this.tooltipKey, this.iconKey, this.hotKeyKey, CAN_DISABLE, PROPERTY_GATE, HIDE_WHEN_DISABLED, DISABLED_ICON};
    }

    @Override
    public String[] getAttributeDescriptions() {
        if (!this.nameKey.isEmpty()) {
            return new String[]{this.namePrompt.isEmpty() ? Resources.getString("Editor.description_label") : this.namePrompt, Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.AbstractToolbarItem.can_disable"), Resources.getString("Editor.AbstractToolbarItem.property_gate"), Resources.getString("Editor.AbstractToolbarItem.hide_when_disabled"), Resources.getString("Editor.AbstractToolbarItem.disabled_icon")};
        }
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.AbstractToolbarItem.can_disable"), Resources.getString("Editor.AbstractToolbarItem.property_gate"), Resources.getString("Editor.AbstractToolbarItem.hide_when_disabled"), Resources.getString("Editor.AbstractToolbarItem.disabled_icon")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        if (!this.nameKey.isEmpty()) {
            return new Class[]{String.class, FormattedStringConfig.class, String.class, IconConfig.class, NamedKeyStroke.class, Boolean.class, String.class, Boolean.class, IconConfig.class};
        }
        return new Class[]{FormattedStringConfig.class, String.class, IconConfig.class, NamedKeyStroke.class, Boolean.class, String.class, Boolean.class, IconConfig.class};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (!this.nameKey.isEmpty() && this.nameKey.equals(key)) {
            this.setConfigureName((String)value);
        } else if (CAN_DISABLE.equals(key)) {
            if (value instanceof String) {
                this.canDisable = "true".equals(value);
            } else if (value instanceof Boolean) {
                this.canDisable = (Boolean)value;
            }
            this.checkDisabled();
        } else if (PROPERTY_GATE.equals(key)) {
            this.propertyGate = (String)value;
            this.addPropertyGateListener();
        } else if (DISABLED_ICON.equals(key)) {
            if (value instanceof String) {
                this.disabledIconConfig.setValue((String)value);
                if (this.launch != null) {
                    this.launch.setDisabledIcon(this.disabledIconConfig.getIconValue());
                }
            }
        } else if (HIDE_WHEN_DISABLED.equals(key)) {
            if (value instanceof String) {
                this.hideWhenDisabled = "true".equals(value);
            } else if (value instanceof Boolean) {
                this.hideWhenDisabled = (Boolean)value;
            }
            this.checkDisabled();
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (!this.nameKey.isEmpty() && this.nameKey.equals(key)) {
            return this.getConfigureName();
        }
        if (CAN_DISABLE.equals(key)) {
            return String.valueOf(this.canDisable);
        }
        if (PROPERTY_GATE.equals(key)) {
            return this.propertyGate;
        }
        if (DISABLED_ICON.equals(key)) {
            return this.disabledIconConfig.getValueString();
        }
        if (HIDE_WHEN_DISABLED.equals(key)) {
            return String.valueOf(this.hideWhenDisabled);
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        if (List.of(PROPERTY_GATE).contains(key)) {
            return () -> this.isShowDisabledOptions() && this.canDisable;
        }
        if (HIDE_WHEN_DISABLED.equals(key)) {
            return () -> false;
        }
        if (DISABLED_ICON.equals(key)) {
            return () -> this.isShowDisabledOptions() && this.canDisable;
        }
        if (CAN_DISABLE.equals(key)) {
            return this::isShowDisabledOptions;
        }
        return null;
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().addGameComponent(this);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().add(this.getComponent());
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().removeGameComponent(this);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().remove(this.getComponent());
            ((ToolBarComponent)((Object)parent)).getToolBar().revalidate();
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (!this.isShowDisabledOptions() || !this.canDisable) {
            return Collections.emptyList();
        }
        String prop = this.getAttributeValueString(PROPERTY_GATE);
        if (prop != null && !prop.isEmpty()) {
            return List.of(prop);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getMenuTextList() {
        return Arrays.asList(this.getAttributeValueString(this.buttonTextKey), this.getAttributeValueString(this.tooltipKey));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(this.hotKeyKey)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String string = this.launch.getAttributeValueString(this.launch.getIconAttribute());
        if (string != null) {
            s.add(string);
        }
    }

    public static class FormattedStringConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[0]);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((AbstractToolbarItem)c).getLaunchButton().getAttributeValueString(AbstractToolbarItem.ICON));
        }
    }
}

