/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.AttachmentManager;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.StartupGlobalKeyCommand;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.CommandFilter;
import VASSAL.command.ConditionalCommand;
import VASSAL.command.Logger;
import VASSAL.command.NullCommand;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.launch.ModuleManagerUpdateHelper;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogAndSaveFileFilter;
import VASSAL.tools.io.DeobfuscatingInputStream;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.io.ZipWriter;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.version.VersionUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class GameState
implements CommandEncoder {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(GameState.class);
    protected java.util.Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    protected List<GameComponent> gameComponents = new ArrayList<GameComponent>();
    protected List<GameSetupStep> setupSteps = new ArrayList<GameSetupStep>();
    protected Action loadGame;
    protected Action loadGameOld;
    protected Action saveGame;
    protected Action saveGameAs;
    protected Action newGame;
    protected Action closeGame;
    protected Action loadContinuation;
    protected Action loadAndFastForward;
    protected Action loadAndAppend;
    protected String lastSave;
    protected File lastSaveFile = null;
    protected DirectoryConfigurer savedGameDirectoryPreference;
    protected DirectoryConfigurer editorImageDirectoryPreference;
    protected DirectoryConfigurer editorSoundDirectoryPreference;
    protected String loadComments;
    protected boolean loadingInBackground = false;
    private boolean fastForwarding = false;
    private final AttachmentManager attachmentManager = new AttachmentManager();
    private boolean gameStarting = false;
    private boolean gameStarted = false;
    private volatile boolean gameUpdating = false;
    private boolean refreshInProgress = false;
    public static final int NO_NEED_TO_SAVE = 6;
    public static final String SAVEFILE_ZIP_ENTRY = "savedGame";
    public static final String BEGIN_SAVE = "begin_save";
    public static final String END_SAVE = "end_save";

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public boolean isLoadingInBackground() {
        return this.loadingInBackground;
    }

    void setLoadingInBackground(boolean b) {
        this.loadingInBackground = b;
    }

    public boolean isFastForwarding() {
        return this.fastForwarding;
    }

    void setLastSaveFile(File f) {
        this.lastSaveFile = f;
    }

    public void addTo(GameModule mod) {
        this.loadGame = new AbstractAction(Resources.getString("GameState.load_game_new")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.loadGame(false);
            }
        };
        this.loadGame.putValue("MnemonicKey", Resources.getString("GameState.load_game.shortcut").charAt(0));
        this.loadGameOld = new AbstractAction(Resources.getString("GameState.load_continuation")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ProblemDialog.show(1, (Component)GameModule.getGameModule().getPlayerWindow(), null, Resources.getString("GameState.old_continuation_title"), Resources.getString("GameState.old_continuation_heading"), Resources.getString("GameState.old_continuation_warning"));
            }
        };
        this.loadGameOld.setEnabled(false);
        this.loadContinuation = new AbstractAction(Resources.getString("GameState.load_game_old")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.loadGame(true);
            }
        };
        this.loadContinuation.setEnabled(false);
        this.loadAndFastForward = new AbstractAction(Resources.getString("GameState.load_and_fast_forward")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.loadFastForward(false);
            }
        };
        this.loadAndAppend = new AbstractAction(Resources.getString("GameState.load_and_append")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.loadFastForward(true);
            }
        };
        this.saveGame = new AbstractAction(Resources.getString("GameState.save_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.saveGame();
            }
        };
        this.saveGame.putValue("MnemonicKey", Resources.getString("GameState.save_game.shortcut").charAt(0));
        this.saveGameAs = new AbstractAction(Resources.getString("GameState.save_game_as")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.saveGameAs();
            }
        };
        this.saveGameAs.putValue("MnemonicKey", Resources.getString("GameState.save_game_as.shortcut").charAt(0));
        this.newGame = new AbstractAction(Resources.getString("GameState.new_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameModule.getGameModule().setGameFileMode(GameModule.GameFileMode.NEW_GAME);
                GameState.this.setup(false);
                Logger log = GameModule.getGameModule().getLogger();
                if (log instanceof BasicLogger) {
                    ((BasicLogger)log).setMultiPlayer(GameModule.getGameModule().isMultiPlayer());
                }
                GameState.this.setup(true);
                GameModule.getGameModule().getGameState().freshenStartupGlobalKeyCommands(GameModule.getGameModule());
            }
        };
        this.newGame.putValue("MnemonicKey", Resources.getString("GameState.new_game.shortcut").charAt(0));
        this.closeGame = new AbstractAction(Resources.getString("GameState.close_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.closeGame();
            }
        };
        this.closeGame.putValue("MnemonicKey", Resources.getString("GameState.close_game.shortcut").charAt(0));
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("GameState.new_game", this.newGame);
        mm.addAction("GameState.load_game_new", this.loadGame);
        mm.addAction("GameState.load_game_old", this.loadGameOld);
        mm.addAction("GameState.load_continuation", this.loadContinuation);
        mm.addAction("GameState.save_game", this.saveGame);
        mm.addAction("GameState.save_game_as", this.saveGameAs);
        mm.addAction("GameState.close_game", this.closeGame);
        mm.addAction("GameState.load_and_fast_forward", this.loadAndFastForward);
        mm.addAction("GameState.load_and_append", this.loadAndAppend);
        this.saveGame.setEnabled(this.gameStarting);
        this.saveGameAs.setEnabled(this.gameStarting);
        this.closeGame.setEnabled(this.gameStarting);
        this.loadGameOld.setEnabled(this.gameStarting);
        this.loadContinuation.setEnabled(this.gameStarting);
    }

    public boolean isModified() {
        String s = this.saveString();
        return s != null && !s.equals(this.lastSave);
    }

    public boolean isSaveEnabled() {
        return this.saveGame != null && this.saveGame.isEnabled();
    }

    public void addGameComponent(GameComponent theComponent) {
        this.gameComponents.add(theComponent);
    }

    public void removeGameComponent(GameComponent theComponent) {
        this.gameComponents.remove(theComponent);
    }

    public Collection<GameComponent> getGameComponents() {
        return Collections.unmodifiableCollection(this.gameComponents);
    }

    public void addGameSetupStep(GameSetupStep step) {
        this.setupSteps.add(step);
    }

    public void removeGameSetupStep(GameSetupStep step) {
        this.setupSteps.remove(step);
    }

    public Iterator<GameSetupStep> getUnfinishedSetupSteps() {
        ArrayList<GameSetupStep> l = new ArrayList<GameSetupStep>();
        for (GameSetupStep step : this.setupSteps) {
            if (step.isFinished()) continue;
            l.add(step);
        }
        return l.iterator();
    }

    public void setupRefresh() {
        this.gameStarting = false;
        this.refreshInProgress = true;
        this.newGame.setEnabled(false);
        this.saveGame.setEnabled(true);
        this.saveGameAs.setEnabled(true);
        this.closeGame.setEnabled(true);
        this.gameStarted &= this.gameStarting;
        for (GameComponent gc : this.gameComponents) {
            gc.setup(this.gameStarting);
        }
    }

    public void setup(boolean gameStarting, boolean gameUpdating) {
        GameModule.getGameModule().setGameFileMode(GameModule.GameFileMode.NEW_GAME);
        this.gameUpdating = gameUpdating;
        this.setup(gameStarting);
    }

    public void updateDone() {
        this.gameUpdating = false;
        this.refreshInProgress = false;
    }

    public boolean isUpdating() {
        return this.gameUpdating;
    }

    public void freshenStartupGlobalKeyCommands(AbstractBuildable target) {
        for (Buildable b : target.getBuildables()) {
            if (b instanceof StartupGlobalKeyCommand) {
                ((StartupGlobalKeyCommand)b).freshGame();
                continue;
            }
            if (!(b instanceof AbstractBuildable)) continue;
            this.freshenStartupGlobalKeyCommands((AbstractBuildable)b);
        }
    }

    private boolean applyStartupGlobalKeyCommands(AbstractBuildable target, boolean playerChange) {
        boolean any = false;
        for (Buildable b : target.getBuildables()) {
            if (b instanceof StartupGlobalKeyCommand) {
                if (playerChange) {
                    any |= ((StartupGlobalKeyCommand)b).applyPlayerChange();
                    continue;
                }
                any |= ((StartupGlobalKeyCommand)b).applyIfNotApplied();
                continue;
            }
            if (!(b instanceof AbstractBuildable)) continue;
            any |= this.applyStartupGlobalKeyCommands((AbstractBuildable)b, playerChange);
        }
        return any;
    }

    public void doStartupGlobalKeyCommands(boolean playerChange) {
        if (this.applyStartupGlobalKeyCommands(GameModule.getGameModule(), playerChange)) {
            FinishedStartupGlobalKeyCommands finished = new FinishedStartupGlobalKeyCommands();
            finished.execute();
            GameModule.getGameModule().sendAndLog(finished);
        }
    }

    public int maybeSaveGame() {
        if (!(this.gameStarted && this.isModified() && this.saveGame.isEnabled())) {
            return 6;
        }
        int result = JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("GameState.save_game_query"), Resources.getString("GameState.game_modified"), 1);
        if (result == 0) {
            this.saveGame();
        }
        return result;
    }

    public void setup(boolean gameStarting) {
        GameModule g = GameModule.getGameModule();
        if (g.isRefreshingSemaphore()) {
            return;
        }
        if (!gameStarting) {
            switch (this.maybeSaveGame()) {
                case 0: {
                    this.saveGame();
                    break;
                }
                case -1: 
                case 2: {
                    return;
                }
            }
        }
        this.gameStarting = gameStarting;
        if (!gameStarting) {
            this.pieces.clear();
            this.attachmentManager.clearAll();
        }
        this.newGame.setEnabled(!gameStarting);
        this.saveGame.setEnabled(gameStarting);
        this.saveGameAs.setEnabled(gameStarting);
        this.closeGame.setEnabled(gameStarting);
        g.resetSourcesAndListeners();
        if (gameStarting) {
            g.getWizardSupport().showGameSetupWizard();
        }
        this.loadGameOld.setEnabled(gameStarting);
        this.loadContinuation.setEnabled(gameStarting);
        this.gameStarted &= this.gameStarting;
        for (int i = 0; i < this.gameComponents.size(); ++i) {
            this.gameComponents.get(i).setup(this.gameStarting);
        }
        this.gameStarted |= this.gameStarting;
        this.lastSave = gameStarting ? this.saveString() : null;
        this.lastSaveFile = null;
        if (this.gameStarted && gameStarting) {
            SwingUtilities.invokeLater(this.fastForwarding ? () -> {
                GameModule.getGameModule().getIndexManager().rebuild();
                this.doStartupGlobalKeyCommands(false);
            } : () -> {
                GameModule.getGameModule().getIndexManager().rebuild();
                this.doStartupGlobalKeyCommands(false);
                Logger logger = GameModule.getGameModule().getLogger();
                if (logger instanceof BasicLogger && !((BasicLogger)logger).isReplaying()) {
                    ((BasicLogger)logger).queryNewLogFile(true);
                }
            });
        }
        if (!gameStarting) {
            GameModule.getGameModule().getIndexManager().clearAll();
        }
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public boolean isSaveMetaDataValid(File file) {
        AbstractMetaData metaData = MetaDataFactory.buildMetaData(file);
        if (!(metaData instanceof SaveMetaData)) {
            WarningDialog.show("GameState.invalid_save_file", file.getPath());
            return false;
        }
        SaveMetaData saveData = (SaveMetaData)metaData;
        String moduleName = GameModule.getGameModule().getGameName();
        String moduleVersion = GameModule.getGameModule().getGameVersion();
        String vassalVersion = VersionUtils.truncateToMinorVersion(Info.getVersion());
        String saveModuleName = saveData.getModuleName();
        String saveModuleVersion = "?";
        String saveVassalVersion = "?";
        GameModule g = GameModule.getGameModule();
        this.loadComments = saveData.getLocalizedDescription();
        if (saveData.getModuleData() != null) {
            String message;
            saveModuleVersion = saveData.getModuleVersion();
            saveVassalVersion = VersionUtils.truncateToMinorVersion(saveData.getVassalVersion());
            if (!saveModuleName.equals(moduleName)) {
                String m = Resources.getString("GameState.load_module_mismatch", saveModuleName, moduleName);
                g.warn("!<b>" + m);
                log.info(m);
                StringBuilder message2 = new StringBuilder();
                message2.append(Resources.getString("GameState.load_mismatch_header", file.getName())).append("\n\n").append(m).append("\n\n").append(Resources.getString("GameState.load_mismatch_trailer")).append('\n');
                if (JOptionPane.showConfirmDialog(null, message2.toString(), Resources.getString("GameState.load_mismatch"), 0, 3) != 0) {
                    return false;
                }
            }
            if (!saveModuleVersion.equals(moduleVersion)) {
                message = Resources.getString("GameState.load_version_mismatch", saveModuleVersion, moduleVersion);
                g.warn("?<b>" + message);
                log.info(message);
            }
            if (!saveVassalVersion.equals(vassalVersion)) {
                message = Resources.getString("GameState.load_vassal_mismatch", saveVassalVersion, vassalVersion);
                g.warn("?<b>" + message);
                log.info(message);
            }
        }
        log.info("Loading save game " + file.getPath() + ", created with module version " + saveModuleVersion);
        return true;
    }

    public void loadGame() {
        this.loadGame(true);
    }

    public void loadGame(boolean continuation) {
        this.loadGame(continuation, false);
    }

    public void loadGame(boolean continuation, boolean forceForeground) {
        GameModule g = GameModule.getGameModule();
        if (this.gameStarted && continuation && GlobalOptions.getInstance().isWarnOldContinuation()) {
            Object[] options = new Object[]{Resources.getString("GameState.anyway"), Resources.getString("GameState.cancel"), Resources.getString("GameState.dont_prompt_again")};
            int result = JOptionPane.showOptionDialog(g.getPlayerWindow(), Resources.getString("GameState.old_continuation_warning"), "", 1, 3, null, options, options[0]);
            if (result == 1) {
                return;
            }
            if (result == 2) {
                g.getPrefs().setValue("oldContinuation", Boolean.FALSE);
            }
        }
        this.loadComments = "";
        FileChooser fc = g.getFileChooser();
        fc.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fc.showOpenDialog() != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        this.loadGame(f, continuation, forceForeground);
    }

    public boolean loadGame(File f, boolean continuation) {
        return this.loadGame(f, continuation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGame(File f, boolean continuation, boolean forceForeground) {
        block14: {
            GameModule g = GameModule.getGameModule();
            try {
                if (!f.exists()) {
                    throw new FileNotFoundException("Unable to locate " + f.getPath());
                }
                if (!this.isSaveMetaDataValid(f)) {
                    g.warn(Resources.getString("GameState.cancel_load", f.getName()));
                    return false;
                }
                if (this.gameStarted && continuation) {
                    this.loadContinuation(f);
                    break block14;
                }
                int optionToSave = 6;
                if (this.gameStarted && (optionToSave = this.maybeSaveGame()) == 2) {
                    return false;
                }
                g.setGameFile(f.getName(), GameModule.GameFileMode.LOADED_GAME);
                if (this.gameStarted) {
                    g.setGameFileMode(GameModule.GameFileMode.NEW_GAME);
                    g.setLoadOverSemaphore(true);
                    try {
                        this.gameStarted = false;
                        this.setup(false);
                        this.loadGameInForeground(f);
                        break block14;
                    }
                    finally {
                        g.setLoadOverSemaphore(false);
                    }
                }
                if (forceForeground) {
                    this.loadGameInForeground(f);
                } else {
                    this.loadGameInBackground(f);
                }
            }
            catch (IllegalStateException e) {
                String msg = e.getMessage();
                if (msg != null && msg.startsWith(Resources.getString("Decorator.no_state_for_trait"))) {
                    WarningDialog.show("GameState.probably_wrong_version", new Object[0]);
                    this.gameStarted = false;
                    this.setup(false);
                }
                throw e;
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, f);
                return false;
            }
        }
        this.updateRecentGames(f);
        return true;
    }

    private void updateRecentGames(File f) {
        StringArrayConfigurer recentGamesConf = (StringArrayConfigurer)GameModule.getGameModule().getPrefs().getOption("RecentGames");
        ArrayList<String> rgs = new ArrayList<String>(Arrays.asList(recentGamesConf.getStringArray()));
        String path = f.toString();
        rgs.remove(path);
        rgs.add(path);
        int max = 24;
        int end = rgs.size();
        recentGamesConf.setValue(rgs.subList(Math.max(0, end - 24), end).toArray(new String[0]));
    }

    private void loadFastForward(boolean append) {
        this.fastForwarding = true;
        this.loadGame(false, true);
        GameModule g = GameModule.getGameModule();
        BasicLogger bl = g.getBasicLogger();
        if (bl.isReplaying()) {
            if (!bl.isLogging() && append) {
                bl.queryNewLogFile(true, true);
            }
            while (bl.isReplaying()) {
                Command c = bl.logInput.get(bl.nextInput++);
                c.execute();
                g.sendAndLog(c);
            }
            bl.stepAction.setEnabled(false);
            if (append) {
                if (!bl.isLogging()) {
                    g.warn(Resources.getString("GameState.fast_forward_only"));
                } else {
                    g.warn(Resources.getString("GameState.fast_forward_and_append"));
                }
            } else {
                if (!bl.isLogging()) {
                    bl.queryNewLogFile(false, true);
                }
                if (!bl.isLogging()) {
                    g.warn(Resources.getString("GameState.fast_forward"));
                } else {
                    g.warn(Resources.getString("GameState.fast_forward_new_log"));
                }
            }
        } else {
            g.warn(Resources.getString("GameState.simple_save_append"));
        }
        this.fastForwarding = false;
    }

    /*
     * Exception decompiling
     */
    public void dropFile(DropTargetDropEvent dtde) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String saveString() {
        return GameModule.getGameModule().encode(this.getRestoreCommand());
    }

    protected boolean checkForOldSaveFile(File f) {
        AbstractMetaData md;
        if (f.exists() && (md = MetaDataFactory.buildMetaData(f)) instanceof SaveMetaData && Info.hasOldFormat(md.getVassalVersion())) {
            return Dialogs.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Warning.save_will_be_updated_title"), Resources.getString("Warning.save_will_be_updated_heading"), Resources.getString("Warning.save_will_be_updated_message", f.getPath(), VersionUtils.truncateToMinorVersion(Info.getVersion())), 2, 2) != 2;
        }
        return true;
    }

    public void closeGame() {
        GameModule.getGameModule().setGameFileMode(GameModule.GameFileMode.NEW_GAME);
        this.setup(false);
        Logger log = GameModule.getGameModule().getLogger();
        if (log instanceof BasicLogger) {
            ((BasicLogger)log).setMultiPlayer(false);
        }
    }

    public void saveGame() {
        if (this.lastSaveFile != null) {
            if (!this.checkForOldSaveFile(this.lastSaveFile)) {
                return;
            }
            try {
                this.saveGame(this.lastSaveFile);
                if (!GameModule.getGameModule().isReplayingOrLogging()) {
                    GameModule.getGameModule().setGameFile(this.lastSaveFile.getName(), GameModule.GameFileMode.SAVED_GAME);
                }
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, this.lastSaveFile);
            }
        } else {
            this.saveGameAs();
        }
    }

    public void saveGameAs() {
        GameModule g = GameModule.getGameModule();
        File saveFile = this.getSaveFile();
        if (saveFile == null) {
            g.warn(Resources.getString("GameState.save_canceled"));
        } else {
            if (!this.checkForOldSaveFile(saveFile)) {
                return;
            }
            try {
                this.saveGame(saveFile);
                this.lastSaveFile = saveFile;
                if (!GameModule.getGameModule().isReplayingOrLogging()) {
                    g.setGameFile(saveFile.getName(), GameModule.GameFileMode.SAVED_GAME);
                }
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, saveFile);
            }
        }
    }

    public void setModified(boolean modified) {
        this.lastSave = modified ? null : this.saveString();
    }

    private File getSaveFile() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.selectDotSavFile();
        fc.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (this.lastSaveFile != null) {
            fc.setSelectedFile(this.lastSaveFile);
        } else {
            File f = fc.getSelectedFile();
            if (f != null && !f.isDirectory()) {
                fc.setCurrentDirectory(f.getParentFile());
            }
        }
        if (fc.showSaveDialog() != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (!file.getName().endsWith(".vsav")) {
            file = new File(file.getParent(), file.getName() + ".vsav");
        }
        return file;
    }

    public void addPiece(GamePiece p) {
        if (p.getId() == null) {
            p.setId(this.getNewPieceId());
        }
        this.pieces.put(p.getId(), p);
        this.getAttachmentManager().pieceAdded(p);
    }

    public GamePiece getPieceForId(String id) {
        return id == null ? null : this.pieces.get(id);
    }

    public void removePiece(String id) {
        if (id != null) {
            this.pieces.remove(id);
        }
    }

    public void removePiece(GamePiece piece) {
        if (piece != null) {
            this.removePiece(piece.getId());
            this.getAttachmentManager().pieceRemoved(piece);
        }
    }

    public String getNewPieceId() {
        long time = System.currentTimeMillis();
        String id = Long.toString(time);
        while (this.pieces.get(id) != null) {
            id = Long.toString(++time);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadContinuation(File f) throws IOException {
        Command c;
        GameModule g = GameModule.getGameModule();
        g.warn(Resources.getString("GameState.loading", f.getName()));
        g.setLoadingContinuationSemaphore(true);
        try {
            c = this.decodeSavedGame(f);
        }
        finally {
            g.setLoadingContinuationSemaphore(false);
        }
        CommandFilter filter = new CommandFilter(){

            @Override
            protected boolean accept(Command c) {
                return c instanceof BasicLogger.LogCommand;
            }
        };
        c = filter.apply(c);
        if (c != null) {
            c.execute();
        }
        g.setGameFile(f.getName(), ((BasicLogger)g.getLogger()).isReplaying() ? GameModule.GameFileMode.REPLAYING_GAME : GameModule.GameFileMode.LOADED_GAME);
        Object msg = Resources.getString("GameState.loaded", f.getName());
        if (this.loadComments != null && this.loadComments.length() > 0) {
            msg = "!" + (String)msg + ": <b>" + this.loadComments + "</b>";
        }
        GameModule.getGameModule().warn((String)msg);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.getAllPieces());
    }

    public Collection<GamePiece> getAllPieces() {
        return this.pieces.values();
    }

    public Command getRestoreCommand() {
        if (!this.saveGame.isEnabled()) {
            return null;
        }
        SetupCommand c = new SetupCommand(false);
        c.append(this.checkVersionCommand());
        c.append(this.getRestorePiecesCommand());
        for (GameComponent gc : this.gameComponents) {
            c.append(gc.getRestoreCommand());
        }
        c.append(new SetupCommand(true));
        return c;
    }

    private Command checkVersionCommand() {
        String runningVersion = GameModule.getGameModule().getAttributeValueString("runningVassalVersion");
        ConditionalCommand.Lt cond = new ConditionalCommand.Lt("runningVassalVersion", runningVersion);
        ConditionalCommand c = new ConditionalCommand(new ConditionalCommand.Condition[]{cond}, new AlertCommand(Resources.getString("GameState.version_mismatch", runningVersion)));
        String moduleName = GameModule.getGameModule().getAttributeValueString("name");
        String moduleVersion = GameModule.getGameModule().getAttributeValueString("version");
        cond = new ConditionalCommand.Lt("version", moduleVersion);
        c.append(new ConditionalCommand(new ConditionalCommand.Condition[]{cond}, new AlertCommand(Resources.getString("GameState.version_mismatch2", moduleName, moduleVersion))));
        return c;
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof SetupCommand)) {
            return null;
        }
        return ((SetupCommand)c).isGameStarting() ? END_SAVE : BEGIN_SAVE;
    }

    @Override
    public Command decode(String theCommand) {
        if (BEGIN_SAVE.equals(theCommand)) {
            return new SetupCommand(false);
        }
        if (END_SAVE.equals(theCommand)) {
            return new SetupCommand(true);
        }
        return null;
    }

    public void saveGameRefresh(ZipArchive archive) throws IOException {
        GameModule mod = GameModule.getGameModule();
        Prefs myPrefs = mod.getPrefs();
        Boolean oldPrompt = (Boolean)myPrefs.getValue("promptLogComment");
        myPrefs.setValue("promptLogComment", false);
        SaveMetaData metaData = new SaveMetaData();
        String save = this.saveString();
        try (OutputStream zout = archive.getOutputStream(SAVEFILE_ZIP_ENTRY);
             BufferedOutputStream bout = new BufferedOutputStream(zout);
             ObfuscatingOutputStream out = new ObfuscatingOutputStream(bout);){
            ((OutputStream)out).write(save.getBytes(StandardCharsets.UTF_8));
        }
        archive.close();
        metaData.save(archive);
        myPrefs.setValue("promptLogComment", oldPrompt);
    }

    public void saveGame(File f) throws IOException {
        GameModule.getGameModule().warn(Resources.getString("GameState.saving_game") + ": " + f.getName());
        SaveMetaData metaData = new SaveMetaData();
        String save = this.saveString();
        if (save == null) {
            GameModule.getGameModule().warn("~" + Resources.getString("GameState.save_disabled"));
        }
        try (ZipWriter zw = new ZipWriter(f);){
            try (ObfuscatingOutputStream out = new ObfuscatingOutputStream(new BufferedOutputStream(zw.write(SAVEFILE_ZIP_ENTRY)));){
                ((OutputStream)out).write(save.getBytes(StandardCharsets.UTF_8));
            }
            metaData.save(zw);
        }
        this.lastSave = save;
        String saveComments = metaData.getLocalizedDescription();
        Object msg = !StringUtils.isEmpty((CharSequence)saveComments) ? "!" + Resources.getString("GameState.game_saved") + ": <b>" + saveComments + "</b>" : Resources.getString("GameState.game_saved");
        GameModule.getGameModule().warn((String)msg);
        ModuleManagerUpdateHelper.sendGameUpdate(f);
    }

    public void loadGameInForeground(File f) {
        try {
            this.loadGameInForeground(f.getName(), new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGameInForeground(String shortName, InputStream in) throws IOException {
        block7: {
            Object msg;
            GameModule g;
            block8: {
                block6: {
                    g = GameModule.getGameModule();
                    g.warn(Resources.getString("GameState.loading", shortName));
                    Chatter ch = g.getChatter();
                    ch.paintImmediately(0, 0, ch.getWidth(), ch.getHeight());
                    Command loadCommand = this.decodeSavedGame(in);
                    if (loadCommand == null) break block7;
                    try {
                        loadCommand.execute();
                        if (!g.getGameState().isGameStarted() && !this.refreshInProgress) break block6;
                        msg = this.loadComments != null && this.loadComments.length() > 0 ? "!" + Resources.getString("GameState.loaded", shortName) + ": <b>" + this.loadComments + "</b>" : Resources.getString("GameState.loaded", shortName);
                    }
                    catch (Throwable throwable) {
                        Object msg2;
                        if (g.getGameState().isGameStarted() || this.refreshInProgress) {
                            msg2 = this.loadComments != null && this.loadComments.length() > 0 ? "!" + Resources.getString("GameState.loaded", shortName) + ": <b>" + this.loadComments + "</b>" : Resources.getString("GameState.loaded", shortName);
                            g.setGameFile(shortName, GameModule.GameFileMode.LOADED_GAME);
                            if (((BasicLogger)g.getLogger()).isReplaying()) {
                                this.lastSaveFile = null;
                            }
                        } else {
                            msg2 = Resources.getString("GameState.cancel_load", shortName);
                        }
                        g.warn((String)msg2);
                        throw throwable;
                    }
                    g.setGameFile(shortName, GameModule.GameFileMode.LOADED_GAME);
                    if (((BasicLogger)g.getLogger()).isReplaying()) {
                        this.lastSaveFile = null;
                    }
                    break block8;
                }
                msg = Resources.getString("GameState.cancel_load", shortName);
            }
            g.warn((String)msg);
        }
    }

    public void loadGameInBackground(File f) {
        try {
            this.loadGameInBackground(f.getName(), new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, f);
        }
    }

    public void loadGameInBackground(String shortName, InputStream in) {
        this.loadGameInBackground(shortName, in, false);
    }

    public void loadGameInBackground(final String shortName, final InputStream in, final boolean fromPredefinedSetup) {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", shortName));
        final PlayerWindow frame = GameModule.getGameModule().getPlayerWindow();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        this.setLoadingInBackground(true);
        new SwingWorker<Command, Void>(){

            @Override
            public Command doInBackground() throws Exception {
                try (InputStream inputStream = in;){
                    Command command = GameState.this.decodeSavedGame(in);
                    return command;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Command loadCommand = null;
                    Object msg = null;
                    try {
                        loadCommand = (Command)this.get();
                    }
                    catch (InterruptedException e) {
                        ErrorDialog.bug(e);
                    }
                    catch (ExecutionException e) {
                        OutOfMemoryError oom = ThrowableUtils.getAncestor(OutOfMemoryError.class, e);
                        if (oom != null) {
                            ErrorDialog.bug(e);
                        } else {
                            log.error("", (Throwable)e);
                        }
                        msg = Resources.getString("GameState.error_loading", shortName);
                        GameModule.getGameModule().warn((String)msg);
                    }
                    if (loadCommand != null) {
                        loadCommand.execute();
                    }
                    GameModule g = GameModule.getGameModule();
                    if (fromPredefinedSetup) {
                        g.getGameState().freshenStartupGlobalKeyCommands(g);
                    }
                    if (g.getGameState().isGameStarted()) {
                        if (loadCommand != null) {
                            msg = GameState.this.loadComments != null && GameState.this.loadComments.length() > 0 ? "!" + Resources.getString("GameState.loaded", shortName) + ": <b>" + GameState.this.loadComments + "</b>" : Resources.getString("GameState.loaded", shortName);
                            g.setGameFile(shortName, GameModule.GameFileMode.LOADED_GAME);
                            if (((BasicLogger)g.getLogger()).isReplaying() || fromPredefinedSetup) {
                                GameState.this.lastSaveFile = null;
                            }
                        } else {
                            msg = Resources.getString("GameState.invalid_savefile", shortName);
                            g.setGameFileMode(GameModule.GameFileMode.NEW_GAME);
                        }
                    } else {
                        msg = Resources.getString("GameState.cancel_load", shortName);
                        g.setGameFileMode(GameModule.GameFileMode.NEW_GAME);
                    }
                    g.warn((String)msg);
                }
                finally {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    GameState.this.setLoadingInBackground(false);
                }
            }
        }.execute();
    }

    public Command getRestorePiecesCommand() {
        ArrayList<GamePiece> pieceList = new ArrayList<GamePiece>(this.pieces.values());
        pieceList.sort(new Comparator<GamePiece>(){
            private final java.util.Map<GamePiece, Integer> indices = new HashMap<GamePiece, Integer>();

            private int indexOf(GamePiece p, Map m) {
                return this.indices.computeIfAbsent(p, k -> m.getPieceCollection().indexOf((GamePiece)k));
            }

            @Override
            public int compare(GamePiece a, GamePiece b) {
                Map amap = a.getMap();
                Map bmap = b.getMap();
                if (amap == null) {
                    return bmap == null ? a.getId().compareTo(b.getId()) : -1;
                }
                if (bmap == null) {
                    return 1;
                }
                if (amap.getId().equals(bmap.getId())) {
                    return this.indexOf(a, amap) - this.indexOf(b, bmap);
                }
                return amap.getId().compareTo(bmap.getId());
            }
        });
        NullCommand c = new NullCommand();
        for (GamePiece p : pieceList) {
            c.append(new AddPiece(p));
        }
        return c;
    }

    public Command decodeSavedGame(File saveFile) throws IOException {
        return this.decodeSavedGame(new BufferedInputStream(Files.newInputStream(saveFile.toPath(), new OpenOption[0])));
    }

    public Command decodeSavedGame(InputStream in) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(in);){
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                if (SAVEFILE_ZIP_ENTRY.equals(entry.getName())) {
                    try (DeobfuscatingInputStream din = new DeobfuscatingInputStream(zipInput);){
                        Command command = GameModule.getGameModule().decode(IOUtils.toString((InputStream)din, (Charset)StandardCharsets.UTF_8));
                        return command;
                    }
                }
                entry = zipInput.getNextEntry();
            }
        }
        throw new IOException("Invalid saveFile format");
    }

    public DirectoryConfigurer getSavedGameDirectoryPreference() {
        if (this.savedGameDirectoryPreference == null) {
            this.savedGameDirectoryPreference = new DirectoryConfigurer("savedGameDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.savedGameDirectoryPreference);
        }
        return this.savedGameDirectoryPreference;
    }

    public DirectoryConfigurer getEditorImageDirectoryPreference() {
        if (this.editorImageDirectoryPreference == null) {
            this.editorImageDirectoryPreference = new DirectoryConfigurer("editorImageDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.editorImageDirectoryPreference);
        }
        return this.editorImageDirectoryPreference;
    }

    public DirectoryConfigurer getEditorSoundDirectoryPreference() {
        if (this.editorSoundDirectoryPreference == null) {
            this.editorSoundDirectoryPreference = new DirectoryConfigurer("editorSoundDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.editorSoundDirectoryPreference);
        }
        return this.editorSoundDirectoryPreference;
    }

    private static class FinishedStartupGlobalKeyCommands
    extends Command {
        private FinishedStartupGlobalKeyCommands() {
        }

        @Override
        protected void executeCommand() {
            Logger l = GameModule.getGameModule().getLogger();
            if (l instanceof BasicLogger) {
                ((BasicLogger)l).blockUndo(2);
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class SetupCommand
    extends Command {
        private final boolean gameStarting;

        public SetupCommand(boolean gameStarting) {
            this.gameStarting = gameStarting;
        }

        public boolean isGameStarting() {
            return this.gameStarting;
        }

        @Override
        protected void executeCommand() {
            GameModule.getGameModule().getGameState().setup(this.gameStarting);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

