/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.password.ToggleablePasswordConfigurer;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.FlowLabel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.netbeans.spi.wizard.WizardController;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PlayerRoster
extends AbstractToolbarItem
implements CommandEncoder,
GameComponent,
GameSetupStep,
ComponentDescription {
    public static final String DESCRIPTION = "description";
    public static final String BUTTON_ICON = "buttonIcon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOL_TIP = "buttonToolTip";
    public static final String BUTTON_KEYSTROKE = "buttonKeyStroke";
    public static final String SIDES = "sides";
    public static final String COMMAND_PREFIX = "PLAYER\t";
    public static final String REMOVE_PREFIX = "PYREMOVE\t";
    public static final String OBSERVER = "<observer>";
    public static final String SOLITAIRE = "Solitaire";
    public static final String REFEREE = "Referee";
    public static final String SOLO = "Solo";
    public static final String MODERATOR = "Moderator";
    protected List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    protected List<String> sides = new ArrayList<String>();
    protected String[] untranslatedSides;
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton retireButton;
    protected List<SideChangeListener> sideChangeListeners = new ArrayList<SideChangeListener>();
    protected String translatedObserver;
    private boolean pickedSide = false;
    protected String description;
    private ToggleablePasswordConfigurer tpc;
    private WizardController wc;
    private boolean forcePwd = false;
    protected StringEnumConfigurer sideConfig;

    public PlayerRoster() {
        this.setButtonTextKey(BUTTON_TEXT);
        this.setTooltipKey(TOOL_TIP);
        this.setIconKey(BUTTON_ICON);
        this.setHotKeyKey(BUTTON_KEYSTROKE);
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("PlayerRoster.allow_another"), Resources.getString("PlayerRoster.retire"), "", e -> this.launch()));
        this.getLaunchButton().setVisible(false);
        this.retireButton = this.getLaunchButton();
        this.setShowDisabledOptions(false);
        this.translatedObserver = Resources.getString("PlayerRoster.observer");
    }

    @Override
    public void removeFrom(Buildable parent) {
        super.removeFrom(parent);
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().removeGameComponent(this);
        gm.removeCommandEncoder(this);
    }

    @Override
    public void remove(Buildable child) {
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            NamedNodeMap attributes = e.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr att = (Attr)attributes.item(i);
                if (BUTTON_ICON.equals(att.getName()) && "Retire".equals(att.getValue())) {
                    try {
                        GameModule.getGameModule().getDataArchive().getInputStream("images/" + att.getValue());
                    }
                    catch (IOException ex) {
                        continue;
                    }
                }
                this.getLaunchButton().setAttribute(att.getName(), att.getValue());
                Localization.getInstance().saveTranslatableAttribute(this, att.getName(), att.getValue());
            }
            NodeList n = e.getElementsByTagName("*");
            this.sides.clear();
            for (int i = 0; i < n.getLength(); ++i) {
                Element el = (Element)n.item(i);
                this.sides.add(Builder.getText(el));
            }
            Localization.getInstance().saveTranslatableAttribute(this, SIDES, this.getSidesAsString());
        }
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PlayerRoster.component_type");
    }

    @Override
    public void add(Buildable child) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String att = super.getAttributeValueString(BUTTON_TEXT);
        if (att != null) {
            el.setAttribute(BUTTON_TEXT, att);
        }
        if ((att = super.getAttributeValueString(BUTTON_ICON)) != null) {
            el.setAttribute(BUTTON_ICON, att);
        }
        if ((att = super.getAttributeValueString(TOOL_TIP)) != null) {
            el.setAttribute(TOOL_TIP, att);
        }
        if ((att = super.getAttributeValueString(BUTTON_KEYSTROKE)) != null) {
            el.setAttribute(BUTTON_KEYSTROKE, att);
        }
        for (String s : this.sides) {
            Element sub = doc.createElement("entry");
            sub.appendChild(doc.createTextNode(s));
            el.appendChild(sub);
        }
        return el;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void addSideChangeListenerToInstance(SideChangeListener l) {
        this.sideChangeListeners.add(l);
    }

    public void removeSideChangeListenerFromInstance(SideChangeListener l) {
        this.sideChangeListeners.remove(l);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "Definition_of_Player_Sides");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable b) {
        GameModule gm = GameModule.getGameModule();
        gm.getGameState().addGameComponent(this);
        gm.getGameState().addGameSetupStep(this);
        gm.addCommandEncoder(this);
        super.addTo(b);
    }

    protected void launch() {
        String mySide = PlayerRoster.getMySide();
        if (mySide == null && this.allSidesAllocated()) {
            return;
        }
        String newSide = this.promptForSide();
        if (newSide == null || newSide.equals(mySide)) {
            return;
        }
        GameModule gm = GameModule.getGameModule();
        if (GameModule.getGameModule().getGameState().isLoadingInBackground()) {
            return;
        }
        PlayerInfo me = new PlayerInfo(GameModule.getActiveUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
        Command c = new Chatter.DisplayText(gm.getChatter(), Resources.getString(GlobalOptions.getInstance().chatterHTMLSupport() ? "PlayerRoster.changed_sides_2" : "PlayerRoster.changed_sides", GameModule.getGameModule().getPrefs().getValue("RealName"), mySide, newSide));
        c.execute();
        Remove r = new Remove(this, GameModule.getActiveUserId());
        r.execute();
        c = c.append(r);
        GameModule.setTempUserId(null);
        me.playerId = GameModule.getActiveUserId();
        Add a = new Add(this, me.playerId, me.playerName, me.side);
        a.execute();
        c = c.append(a);
        gm.getServer().sendToOthers(c);
        newSide = PlayerRoster.getMySide();
        this.fireSideChange(mySide, newSide);
        GameModule.getGameModule().getGameState().doStartupGlobalKeyCommands(true);
    }

    protected void fireSideChange(String oldSide, String newSide) {
        for (SideChangeListener l : this.sideChangeListeners) {
            l.sideChanged(oldSide, newSide);
        }
    }

    public static boolean isActive() {
        return GameModule.getGameModule().getPlayerRoster() != null;
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    protected static PlayerRoster getInstance() {
        return GameModule.getGameModule().getPlayerRoster();
    }

    public static String getMySide() {
        return PlayerRoster.getMySide(false);
    }

    public static String getMyLocalizedSide() {
        return PlayerRoster.getMySide(true);
    }

    protected static List<String> getCurrentPasswords() {
        return List.of(GameModule.getUserId(), Resources.getString("Prefs.password_prompt", System.getProperty("user.name")));
    }

    protected static String getMySide(boolean localized) {
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        if (r != null) {
            for (PlayerInfo pi : r.getPlayers()) {
                if (!pi.playerId.equals(GameModule.getActiveUserId())) continue;
                return localized ? pi.getLocalizedSide() : pi.getSide();
            }
        }
        return null;
    }

    public PlayerInfo[] getPlayers() {
        return this.players.toArray(new PlayerInfo[0]);
    }

    public List<String> getSides() {
        return new ArrayList<String>(this.sides);
    }

    public void add(String playerId, String playerName, String side) {
        Logger log;
        PlayerInfo e = new PlayerInfo(playerId, playerName, side);
        if (this.players.contains(e)) {
            this.players.set(this.players.indexOf(e), e);
        } else {
            this.players.add(e);
        }
        if (GameModule.getGameModule().isMultiPlayer() && (log = GameModule.getGameModule().getLogger()) instanceof BasicLogger) {
            ((BasicLogger)log).setMultiPlayer(true);
        }
    }

    public void remove(String playerId) {
        PlayerInfo e = new PlayerInfo(playerId, null, null);
        this.players.remove(e);
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
            st.nextToken();
            return new Add(this, st.nextToken(), st.nextToken(), st.nextToken());
        }
        if (command.startsWith(REMOVE_PREFIX)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
            st.nextToken();
            return new Remove(this, st.nextToken(""));
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof Add) {
            Add a = (Add)c;
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(a.id).append(a.name).append(a.side);
            return COMMAND_PREFIX + se.getValue();
        }
        if (c instanceof Remove) {
            Remove a = (Remove)c;
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(a.id);
            return REMOVE_PREFIX + se.getValue();
        }
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        Add c = null;
        for (PlayerInfo entry : this.players) {
            Add sub = new Add(this, entry.playerId, entry.playerName, entry.side);
            c = c == null ? sub : c.append(sub);
        }
        return c;
    }

    @Override
    public void setup(boolean gameStarting) {
        super.setup(gameStarting);
        if (gameStarting) {
            Logger log;
            this.claimOccupiedSide();
            if (GameModule.getGameModule().isMultiPlayer() && (log = GameModule.getGameModule().getLogger()) instanceof BasicLogger) {
                ((BasicLogger)log).setMultiPlayer(true);
            }
        } else {
            GameModule.setTempUserId(null);
            this.players.clear();
        }
        this.getLaunchButton().setVisible(gameStarting && PlayerRoster.getMySide() != null);
        this.pickedSide = false;
    }

    @Override
    public void finish() {
        GameModule.getGameModule().getPasswordConfigurer().setValue(GameModule.getUserId());
        try {
            GameModule.getGameModule().getPrefs().save();
        }
        catch (IOException e) {
            GameModule.getGameModule().warn(Resources.getString("PlayerRoster.failed_pref_write", e.getLocalizedMessage()));
        }
        String newSide = this.untranslateSide(this.sideConfig.getValueString());
        if (newSide != null) {
            if (GameModule.getGameModule().isMultiplayerConnected()) {
                Chatter.DisplayText c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), Resources.getString(GlobalOptions.getInstance().chatterHTMLSupport() ? "PlayerRoster.joined_side_2" : "PlayerRoster.joined_side", GameModule.getGameModule().getPrefs().getValue("RealName"), newSide));
                c.execute();
            }
            Add a = new Add(this, GameModule.getActiveUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
            a.execute();
            GameModule.getGameModule().getServer().sendToOthers(a);
        }
        this.getLaunchButton().setVisible(PlayerRoster.getMySide() != null);
        this.pickedSide = true;
    }

    @Override
    public Component getControls() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        availableSides.add(0, this.translatedObserver);
        this.sideConfig = new StringEnumConfigurer(null, Resources.getString("PlayerRoster.join_game_as"), availableSides.toArray(new String[0]));
        this.sideConfig.setValue(this.translatedObserver);
        String pwd = (String)GameModule.getGameModule().getPrefs().getValue("SecretName");
        if (!this.forcePwd || pwd != null && !pwd.isEmpty()) {
            return this.sideConfig.getControls();
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]", "[]para[]rel[]"));
        panel.add(this.sideConfig.getControls(), "wrap");
        FlowLabel message = new FlowLabel(Resources.getString("PlayerRoster.need_non_blank_password"));
        panel.add((Component)message, "wrap");
        JLabel label = new JLabel(Resources.getString("PlayerRoster.please_set_your_password"));
        panel.add((Component)label, "split 2");
        this.tpc = new ToggleablePasswordConfigurer("SecretName", "", "");
        this.tpc.addPropertyChangeListener(evt -> GameModule.setUserId((String)evt.getNewValue()));
        label.setLabelFor(this.tpc.getControls());
        panel.add(this.tpc.getControls());
        return panel;
    }

    @Override
    public String getStepTitle() {
        return Resources.getString("PlayerRoster.choose_side");
    }

    public void validatePassword() {
        if (this.pickedSide || this.wc == null || !this.forcePwd) {
            return;
        }
        String pwd = (String)GameModule.getGameModule().getPrefs().getValue("SecretName");
        if (pwd != null && !pwd.isEmpty()) {
            this.wc.setProblem(null);
        } else {
            this.wc.setProblem(Resources.getString("PlayerRoster.please_set_non_blank_password"));
        }
    }

    @Override
    public void setController(WizardController wc) {
        this.wc = wc;
        if (this.forcePwd && wc != null && this.tpc != null) {
            this.tpc.addPropertyChangeListener(evt -> {
                String newPwd = (String)evt.getNewValue();
                if (newPwd.isEmpty()) {
                    wc.setProblem(Resources.getString("PlayerRoster.please_set_non_blank_password"));
                } else {
                    wc.setProblem(null);
                }
            });
            SwingUtilities.invokeLater(this::validatePassword);
        }
    }

    public void setForcePwd(boolean forcePwd) {
        this.forcePwd = forcePwd;
    }

    @Override
    public boolean isFinished() {
        if (this.pickedSide) {
            return true;
        }
        if (this.allSidesAllocated()) {
            return true;
        }
        this.claimOccupiedSide();
        PlayerInfo newPlayerInfo = new PlayerInfo(GameModule.getActiveUserId(), GlobalOptions.getInstance().getPlayerId(), null);
        int i = this.players.indexOf(newPlayerInfo);
        if (i != -1) {
            return !OBSERVER.equals(this.players.get(i).getSide());
        }
        return false;
    }

    protected boolean allSidesAllocated() {
        int allocatedSideCount = 0;
        for (PlayerInfo p : this.players) {
            if (OBSERVER.equals(p.getSide())) continue;
            ++allocatedSideCount;
        }
        return this.sides.size() == allocatedSideCount;
    }

    public static boolean isSoloSide(String side) {
        return Resources.getString("PlayerRoster.solitaire").equals(side) || Resources.getString("PlayerRoster.solo").equals(side) || Resources.getString("PlayerRoster.moderator").equals(side) || Resources.getString("PlayerRoster.referee").equals(side);
    }

    public boolean isMultiPlayer() {
        if (!this.sides.isEmpty()) {
            int takenSideCount = 0;
            for (PlayerInfo p : this.players) {
                if (!this.sides.contains(p.side)) continue;
                ++takenSideCount;
            }
            return takenSideCount > 1;
        }
        return this.players.size() > 1;
    }

    protected void claimSlot(int index) {
        PlayerInfo[] roster = GameModule.getGameModule().getPlayerRoster().getPlayers();
        PlayerInfo slot = roster[index];
        slot.playerName = GlobalOptions.getInstance().getPlayerId();
        GameModule.setTempUserId(slot.playerId);
    }

    protected void claimOccupiedSide() {
        GameModule g;
        String choice;
        int pick;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<String> availableNames = new ArrayList<String>();
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        List<String> pwdsToMatch = PlayerRoster.getCurrentPasswords();
        ArrayList<PlayerInfo> allowedSides = new ArrayList<PlayerInfo>();
        boolean blankMatch = false;
        if (r != null) {
            int index = 0;
            for (PlayerInfo pi : r.getPlayers()) {
                if (pwdsToMatch.contains(pi.playerId)) {
                    allowedSides.add(pi);
                    indices.add(index);
                }
                ++index;
            }
            if (allowedSides.isEmpty()) {
                index = 0;
                for (PlayerInfo pi : r.getPlayers()) {
                    if ("".equals(pi.playerId) && !OBSERVER.equals(pi.getSide())) {
                        allowedSides.add(pi);
                        indices.add(index);
                    }
                    ++index;
                    blankMatch = true;
                }
            }
        }
        GameModule.setTempUserId(null);
        if (allowedSides.isEmpty()) {
            return;
        }
        if (allowedSides.size() == 1 && (!blankMatch || this.allSidesAllocated())) {
            this.claimSlot((Integer)indices.get(0));
            return;
        }
        for (PlayerInfo p : allowedSides) {
            String s = p.playerId.equals(GameModule.getUserId()) ? Resources.getString("PlayerRoster.current_password") : (p.playerId.isEmpty() ? Resources.getString("PlayerRoster.empty_password") : Resources.getString("PlayerRoster.quoted_password", p.playerId));
            availableNames.add(Resources.getString("PlayerRoster.occupied_side", p.getLocalizedSide(), s));
        }
        if (blankMatch) {
            availableNames.add(Resources.getString("PlayerRoster.none_of_the_above"));
        }
        if ((pick = availableNames.indexOf(choice = (String)JOptionPane.showInputDialog((g = GameModule.getGameModule()).getPlayerWindow(), Resources.getString("PlayerRoster.pick_an_occupied_side"), Resources.getString("PlayerRoster.choose_side"), 3, null, availableNames.toArray(new String[0]), availableNames.get(0)))) >= 0 && pick < indices.size()) {
            this.claimSlot((Integer)indices.get(pick));
        }
    }

    public List<String> getAvailableSides() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        return availableSides;
    }

    protected String promptForSide() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        boolean found = false;
        String mySide = PlayerRoster.getMySide();
        int myidx = mySide != null ? this.sides.indexOf(mySide) : -1;
        int i = myidx >= 0 ? (myidx + 1) % this.sides.size() : 0;
        for (int tries = 0; i != myidx && tries < this.sides.size(); ++tries) {
            String s = this.sides.get(i);
            if (!alreadyTaken.contains(s) && !PlayerRoster.isSoloSide(s)) {
                found = true;
                break;
            }
            i = (i + 1) % this.sides.size();
        }
        String nextChoice = found ? this.sides.get(i) : this.translatedObserver;
        availableSides.add(0, this.translatedObserver);
        GameModule g = GameModule.getGameModule();
        String newSide = (String)JOptionPane.showInputDialog(g.getPlayerWindow(), Resources.getString("PlayerRoster.switch_sides", PlayerRoster.getMyLocalizedSide()), Resources.getString("PlayerRoster.choose_side"), 3, null, availableSides.toArray(new String[0]), nextChoice);
        newSide = this.translatedObserver.equals(newSide) ? OBSERVER : this.untranslateSide(newSide);
        return newSide;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DESCRIPTION, SIDES, BUTTON_TEXT, TOOL_TIP, BUTTON_ICON, BUTTON_KEYSTROKE};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String[].class, String.class, String.class, AbstractToolbarItem.IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SIDES.equals(key)) {
            return this.getSidesAsString();
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SIDES.equals(key)) {
            this.untranslatedSides = this.sides.toArray(new String[0]);
            if (value instanceof String) {
                this.setSidesFromString((String)value);
            } else {
                String[] s = (String[])value;
                this.sides = new ArrayList<String>(s.length);
                Collections.addAll(this.sides, s);
            }
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    protected String getSidesAsString() {
        String[] s = this.sides.toArray(new String[0]);
        return StringArrayConfigurer.arrayToString(s);
    }

    protected void setSidesFromString(String newSides) {
        this.sides = Arrays.asList(StringArrayConfigurer.stringToArray(newSides));
    }

    public String untranslateSide(String side) {
        if (this.translatedObserver.equals(side)) {
            return OBSERVER;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.sides.size(); ++i) {
                if (!this.sides.get(i).equals(side)) continue;
                return this.untranslatedSides[i];
            }
        }
        return side;
    }

    public String translateSide(String side) {
        if (OBSERVER.equals(side)) {
            return this.translatedObserver;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.untranslatedSides.length; ++i) {
                if (!this.untranslatedSides[i].equals(side)) continue;
                return this.sides.get(i);
            }
        }
        return side;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.PlayerRoster.sides_label"), Resources.getString("Editor.PlayerRoster.retire_button_text"), Resources.getString("Editor.PlayerRoster.retire_button_tooltip"), Resources.getString("Editor.PlayerRoster.retire_button_icon"), Resources.getString("Editor.PlayerRoster.retire_button_keystroke")};
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getPropertyList() {
        return this.sides;
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData c = super.getI18nData();
        c.setAttributeTranslatable(SIDES, true);
        return c;
    }

    public static class PlayerInfo {
        public String playerId;
        public String playerName;
        private final String side;

        public PlayerInfo(String id, String name, String side) {
            this.playerId = Objects.requireNonNull(id);
            this.playerName = name;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerInfo && this.playerId != null) {
                return this.playerId.equals(((PlayerInfo)o).playerId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.playerId);
        }

        public boolean isObserver() {
            return PlayerRoster.OBSERVER.equals(this.side);
        }

        public String getSide() {
            return this.side;
        }

        public String getLocalizedSide() {
            return GameModule.getGameModule().getPlayerRoster().translateSide(this.side);
        }
    }

    public static class Remove
    extends Command {
        private final PlayerRoster roster;
        private final String id;

        public Remove(PlayerRoster r, String playerId) {
            this.roster = r;
            this.id = playerId;
        }

        @Override
        protected void executeCommand() {
            this.roster.remove(this.id);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class Add
    extends Command {
        private final PlayerRoster roster;
        private final String id;
        private final String name;
        private final String side;

        public Add(PlayerRoster r, String playerId, String playerName, String side) {
            this.roster = r;
            this.id = playerId;
            this.name = playerName;
            this.side = side;
        }

        @Override
        protected void executeCommand() {
            this.roster.add(this.id, this.name, this.side);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    @FunctionalInterface
    public static interface SideChangeListener {
        public void sideChanged(String var1, String var2);
    }
}

