/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.BeanShellFunctionMenu;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.swing.SwingUtils;
import bsh.BeanShellExpressionValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class BeanShellExpressionConfigurer
extends StringConfigurer {
    protected JPanel expressionPanel;
    protected JPanel detailPanel;
    protected Validator validator;
    protected JButton extraDetails;
    protected Icon up;
    protected Icon down;
    protected StringConfigurer errorMessage = new StringConfigurer("");
    protected JLabel variables = new JLabel();
    protected JLabel methods = new JLabel();
    protected EditablePiece target;
    protected Option option;
    protected String selectedText;
    protected boolean displayOnly;
    protected FunctionBuilder builder;
    protected JTextArea nameField;

    public BeanShellExpressionConfigurer(String val, GamePiece piece) {
        this(null, "", val, piece);
    }

    public BeanShellExpressionConfigurer(String key, String name, String val, GamePiece piece) {
        this(key, name, val, piece, Option.NONE);
    }

    public BeanShellExpressionConfigurer(String key, String name, String val, GamePiece piece, Option option) {
        this(key, name, val, piece, option, false);
    }

    public BeanShellExpressionConfigurer(String key, String name, String val, GamePiece piece, Option option, FunctionBuilder builder) {
        this(key, name, val, piece, option, false);
        this.builder = builder;
    }

    public BeanShellExpressionConfigurer(String key, String name, String val, GamePiece piece, Option option, boolean displayOnly) {
        super(key, name, val);
        this.option = option;
        this.displayOnly = displayOnly;
        this.target = piece instanceof EditablePiece ? (EditablePiece)piece : null;
        this.strip();
        this.up = IconFactory.getIcon("go-up", 0);
        this.down = IconFactory.getIcon("go-down", 0);
        this.extraDetails = new JButton(Resources.getString("Editor.BeanShell.insert"));
        this.extraDetails.addActionListener(e -> {
            this.setSelectedText(this.nameField.getSelectedText());
            this.doPopup();
        });
    }

    protected void strip() {
        String s = this.getValueString().trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            this.setValue(s.substring(1, s.length() - 1));
        }
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String s) {
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(s);
        }
        this.setValue((Object)s);
    }

    @Override
    public void requestFocus() {
        if (this.nameField != null) {
            this.nameField.requestFocus();
        }
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.getControls();
        this.nameField.setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.nameField.repaint();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.getControls();
        this.nameField.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.getControls();
        this.nameField.removeFocusListener(listener);
    }

    protected Component getTopLevelAncestor() {
        return this.p.getTopLevelAncestor();
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.expressionPanel = new ConfigurerPanel(this.getName(), "[grow,fill]", "[][grow,fill]", "[grow, fill]");
            ((MigLayout)this.expressionPanel.getLayout()).setLayoutConstraints((Object)"ins 0,fill");
            JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[fill,grow]2[]2[]", "[grow]"));
            this.validator = new Validator();
            this.nameField = new JTextArea(1, 100);
            this.nameField.setFont(new Font("Monospaced", 0, 14));
            this.nameField.setLineWrap(true);
            this.nameField.setWrapStyleWord(true);
            this.nameField.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.nameField.setFocusTraversalKeys(0, null);
            this.nameField.setFocusTraversalKeys(1, null);
            this.nameField.setText(this.getValueString());
            panel.add((Component)this.nameField, "grow");
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    BeanShellExpressionConfigurer.this.noUpdate = true;
                    BeanShellExpressionConfigurer.this.setValue(BeanShellExpressionConfigurer.this.nameField.getText());
                    BeanShellExpressionConfigurer.this.validator.validate();
                    BeanShellExpressionConfigurer.this.noUpdate = false;
                    BeanShellExpressionConfigurer.this.updateParentBuilder();
                }
            });
            SwingUtils.allowUndo(this.nameField);
            if (!GraphicsEnvironment.isHeadless()) {
                this.nameField.setDragEnabled(true);
            }
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                private void update() {
                    BeanShellExpressionConfigurer.this.noUpdate = true;
                    BeanShellExpressionConfigurer.this.setValue(BeanShellExpressionConfigurer.this.nameField.getText());
                    BeanShellExpressionConfigurer.this.noUpdate = false;
                }
            });
            this.nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BeanShellExpressionConfigurer.this.nameField.selectAll();
                        }
                    });
                }
            });
            panel.add(this.validator);
            panel.add(this.extraDetails);
            this.expressionPanel.add((Component)panel, "grow");
            this.nameField.setEditable(!this.isDisplayOnly());
            this.extraDetails.setVisible(!this.isDisplayOnly());
            this.validator.validate();
            this.detailPanel = new JPanel();
            this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 1));
            this.errorMessage = new StringConfigurer(null, "Error Message:  ", "");
            this.errorMessage.getControls().setEnabled(false);
            this.variables.setText("Vassal Properties:  ");
            this.methods.setText("Methods:  ");
            this.detailPanel.add(this.errorMessage.getControls());
            this.detailPanel.add(this.variables);
            this.detailPanel.add(this.methods);
            this.detailPanel.setVisible(false);
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.expressionPanel);
            this.p.add(this.detailPanel);
            this.nameField.setPreferredSize(this.nameField.getPreferredSize());
            ComponentAdapter l = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    BeanShellExpressionConfigurer.this.repack();
                }
            };
            this.nameField.addComponentListener(l);
        }
        return this.p;
    }

    public void validate() {
        this.validator.validate();
    }

    protected void updateParentBuilder() {
        if (this.builder != null) {
            this.builder.update();
        }
    }

    protected void doPopup() {
        BeanShellFunctionMenu popup = new BeanShellFunctionMenu(this.target, this);
        popup.show(this.extraDetails, 0, 0);
    }

    protected void insertPropertyName(String name) {
        this.insertName(this.cleanName(name));
    }

    protected void insertName(String name) {
        int selectionEnd;
        Object work = this.nameField.getText();
        int pos = this.nameField.getCaretPosition();
        int selectionStart = this.nameField.getSelectionStart();
        if (selectionStart != (selectionEnd = this.nameField.getSelectionEnd())) {
            work = ((String)work).substring(0, selectionStart) + ((String)work).substring(selectionEnd);
            if (pos >= selectionStart && pos <= selectionEnd) {
                pos = selectionStart;
            }
        }
        String news = ((String)work).substring(0, pos) + name + ((String)work).substring(pos);
        this.nameField.setText(news);
        this.nameField.setCaretPosition(pos + name.length());
        this.noUpdate = true;
        this.setValue(this.nameField.getText());
        this.validator.validate();
        this.noUpdate = false;
        this.nameField.repaint();
        this.updateParentBuilder();
        this.nameField.requestFocusInWindow();
    }

    protected String cleanName(String name) {
        boolean valid = true;
        for (int i = 0; i < name.length() && valid; ++i) {
            char c = name.charAt(i);
            valid = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
        }
        return valid ? name : "GetProperty(\"" + name + "\")";
    }

    protected void setDetails(String error, List<String> v, List<String> m) {
        this.errorMessage.setValue(error);
        String s = "Vassal Properties:  " + (v == null ? "" : v.toString());
        this.variables.setText(s);
        s = "Methods:  " + (m == null ? "" : m.toString());
        this.methods.setText(s);
    }

    protected void setDetails() {
        this.setDetails("", null, null);
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public void setSelectedText(String selectedText) {
        this.selectedText = selectedText;
    }

    public boolean isDisplayOnly() {
        return this.displayOnly;
    }

    public void setDisplayOnly(boolean displayOnly) {
        this.displayOnly = displayOnly;
    }

    public static enum Option {
        NONE,
        PME,
        COMMENT;

    }

    class Validator
    extends JLabel {
        protected static final int INVALID = 0;
        protected static final int VALID = 1;
        protected static final int UNKNOWN = 2;
        protected Icon tick;
        protected Icon cross;
        protected ImageIcon none;
        protected int status = 2;
        protected boolean validating = false;
        protected boolean dirty = false;
        protected ValidationThread validationThread = new ValidationThread();
        private static final long serialVersionUID = 1L;

        public Validator() {
            this.cross = IconFactory.getIcon("no", 0);
            this.tick = IconFactory.getIcon("yes", 0);
            BufferedImage image = new BufferedImage(this.cross.getIconWidth(), this.cross.getIconHeight(), 2);
            this.none = new ImageIcon(image);
            this.setStatus(2);
        }

        public void setStatus(int status) {
            if (status == 1) {
                this.setIcon(this.tick);
            } else if (status == 0) {
                this.setIcon(this.cross);
            } else {
                this.setIcon(this.none);
            }
            this.status = status;
            this.repaint();
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public void validate() {
            if (this.validating) {
                this.dirty = true;
            } else {
                this.validating = true;
                BeanShellExpressionConfigurer.this.validator.setStatus(2);
                SwingUtilities.invokeLater(this.validationThread);
            }
        }

        class ValidationThread
        implements Runnable {
            ValidationThread() {
            }

            @Override
            public void run() {
                if (BeanShellExpressionConfigurer.this.getValueString().length() == 0) {
                    BeanShellExpressionConfigurer.this.validator.setStatus(2);
                    BeanShellExpressionConfigurer.this.setDetails();
                } else {
                    BeanShellExpressionValidator v = new BeanShellExpressionValidator(BeanShellExpressionConfigurer.this.getValueString());
                    if (v.isValid()) {
                        BeanShellExpressionConfigurer.this.validator.setStatus(1);
                    } else {
                        BeanShellExpressionConfigurer.this.validator.setStatus(0);
                    }
                    BeanShellExpressionConfigurer.this.setDetails(v.getError(), v.getAllVariables(), v.getMethods());
                }
                Validator.this.validating = false;
                if (Validator.this.dirty) {
                    Validator.this.dirty = false;
                    Validator.this.validate();
                }
            }
        }
    }
}

