/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.GlobalCommandTargetConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.search.SearchTarget;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GlobalCommandTarget
implements ConfigurerFactory,
SearchTarget {
    protected static final char ENCODE_DELIMITER = '|';
    protected GKCtype gkcType = GKCtype.MAP;
    protected boolean fastMatchLocation = false;
    protected Target targetType = Target.MAP;
    protected FormattedStringExpression targetMap;
    protected FormattedStringExpression targetBoard;
    protected FormattedStringExpression targetZone;
    protected FormattedStringExpression targetLocation;
    protected FormattedStringExpression targetDeck;
    protected FormattedStringExpression targetX;
    protected FormattedStringExpression targetY;
    protected FormattedStringExpression targetAttachment;
    protected FormattedStringExpression targetAttachmentId;
    protected boolean fastMatchProperty = false;
    protected FormattedStringExpression targetProperty;
    protected FormattedStringExpression targetValue;
    protected CompareMode targetCompare;
    private GamePiece curPiece;

    @Override
    public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
        return new GlobalCommandTargetConfigurer(key, name, ((MassKeyCommand)c).getTarget());
    }

    public GlobalCommandTarget() {
        this(GKCtype.MAP);
    }

    public GlobalCommandTarget(GKCtype gkc) {
        this.setGKCtype(gkc);
        this.targetMap = new FormattedStringExpression("");
        this.targetBoard = new FormattedStringExpression("");
        this.targetZone = new FormattedStringExpression("");
        this.targetLocation = new FormattedStringExpression("");
        this.targetDeck = new FormattedStringExpression("");
        this.targetProperty = new FormattedStringExpression("");
        this.targetValue = new FormattedStringExpression("");
        this.targetX = new FormattedStringExpression("0");
        this.targetY = new FormattedStringExpression("0");
        this.targetAttachment = new FormattedStringExpression("");
        this.targetAttachmentId = new FormattedStringExpression("");
        this.targetCompare = CompareMode.EQUALS;
    }

    public GlobalCommandTarget(String s) {
        this.decode(s);
    }

    public GlobalCommandTarget(GlobalCommandTarget gc) {
        this(gc.encode());
    }

    public String encode() {
        SequenceEncoder se = new SequenceEncoder('|');
        se.append(this.gkcType.name()).append(this.fastMatchLocation).append(this.targetType.name()).append(this.targetMap.getExpression()).append(this.targetBoard.getExpression()).append(this.targetZone.getExpression()).append(this.targetLocation.getExpression()).append(this.targetX.getExpression()).append(this.targetY.getExpression()).append(this.targetDeck.getExpression()).append(this.fastMatchProperty).append(this.targetProperty.getExpression()).append(this.targetValue.getExpression()).append(this.targetCompare.name()).append(this.targetAttachment.getExpression()).append(this.targetAttachmentId.getExpression());
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, '|');
        String source = sd.nextToken("");
        this.gkcType = source.isEmpty() ? GKCtype.MAP : GKCtype.valueOf(source);
        this.fastMatchLocation = sd.nextBoolean(false);
        String type = sd.nextToken(Target.MAP.name());
        this.targetType = type.isEmpty() ? Target.MAP : Target.valueOf(type);
        this.targetMap = new FormattedStringExpression(sd.nextToken(""));
        this.targetBoard = new FormattedStringExpression(sd.nextToken(""));
        this.targetZone = new FormattedStringExpression(sd.nextToken(""));
        this.targetLocation = new FormattedStringExpression(sd.nextToken(""));
        this.targetX = new FormattedStringExpression(sd.nextToken("0"));
        this.targetY = new FormattedStringExpression(sd.nextToken("0"));
        this.targetDeck = new FormattedStringExpression(sd.nextToken(""));
        this.fastMatchProperty = sd.nextBoolean(false);
        this.targetProperty = new FormattedStringExpression(sd.nextToken(""));
        this.targetValue = new FormattedStringExpression(sd.nextToken(""));
        String compare = sd.nextToken(CompareMode.EQUALS.name());
        this.targetCompare = compare.isEmpty() ? CompareMode.EQUALS : CompareMode.valueOf(compare);
        this.targetAttachment = new FormattedStringExpression(sd.nextToken(""));
        this.targetAttachmentId = new FormattedStringExpression(sd.nextToken(""));
    }

    public boolean equals(Object o) {
        if (!(o instanceof GlobalCommandTarget)) {
            return false;
        }
        GlobalCommandTarget t = (GlobalCommandTarget)o;
        return this.encode().equals(t.encode());
    }

    public int hashCode() {
        return this.encode().hashCode();
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> expList = new ArrayList<String>();
        if (this.fastMatchLocation) {
            if (this.targetType == Target.MAP || this.targetType == Target.ZONE || this.targetType == Target.LOCATION || this.targetType == Target.XY) {
                expList.add(this.targetMap.getExpression());
            }
            if (this.targetType == Target.XY) {
                expList.add(this.targetBoard.getExpression());
                expList.add(this.targetX.getExpression());
                expList.add(this.targetY.getExpression());
            } else if (this.targetType == Target.ZONE) {
                expList.add(this.targetZone.getExpression());
            } else if (this.targetType == Target.LOCATION) {
                expList.add(this.targetLocation.getExpression());
            } else if (this.targetType == Target.DECK) {
                expList.add(this.targetDeck.getExpression());
            } else if (this.targetType == Target.CURATTACH && !this.targetAttachment.getExpression().isBlank()) {
                expList.add(this.targetAttachment.getExpression());
                expList.add(this.targetAttachmentId.getExpression());
            }
        }
        if (this.fastMatchProperty) {
            expList.add(this.targetProperty.getExpression());
            expList.add(this.targetValue.getExpression());
        }
        return expList;
    }

    @Override
    public List<String> getFormattedStringList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getMenuTextList() {
        return Collections.emptyList();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getPropertyList() {
        if (this.fastMatchProperty) {
            return List.of(this.targetProperty.getExpression());
        }
        return Collections.emptyList();
    }

    public GKCtype getGKCtype() {
        return this.gkcType;
    }

    public void setGKCtype(GKCtype gkcType) {
        this.gkcType = gkcType;
    }

    public boolean isFastMatchLocation() {
        return this.fastMatchLocation;
    }

    public void setFastMatchLocation(boolean fastMatchLocation) {
        this.fastMatchLocation = fastMatchLocation;
    }

    public boolean isFastMatchProperty() {
        return this.fastMatchProperty;
    }

    public void setFastMatchProperty(boolean fastMatchProperty) {
        this.fastMatchProperty = fastMatchProperty;
    }

    public Target getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Target targetType) {
        this.targetType = targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = Target.valueOf(targetType);
    }

    public FormattedStringExpression getTargetMap() {
        return this.targetMap;
    }

    public void setTargetMap(FormattedStringExpression targetMap) {
        this.targetMap = targetMap;
    }

    public void setTargetMap(String targetMap) {
        this.targetMap = new FormattedStringExpression(targetMap);
    }

    public FormattedStringExpression getTargetBoard() {
        return this.targetBoard;
    }

    public void setTargetBoard(FormattedStringExpression targetBoard) {
        this.targetBoard = targetBoard;
    }

    public void setTargetBoard(String targetBoard) {
        this.targetBoard = new FormattedStringExpression(targetBoard);
    }

    public FormattedStringExpression getTargetZone() {
        return this.targetZone;
    }

    public void setTargetZone(FormattedStringExpression targetZone) {
        this.targetZone = targetZone;
    }

    public void setTargetZone(String targetZone) {
        this.targetZone = new FormattedStringExpression(targetZone);
    }

    public FormattedStringExpression getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(FormattedStringExpression targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = new FormattedStringExpression(targetLocation);
    }

    public FormattedStringExpression getTargetDeck() {
        return this.targetDeck;
    }

    public void setTargetDeck(FormattedStringExpression targetDeck) {
        this.targetDeck = targetDeck;
    }

    public void setTargetDeck(String targetDeck) {
        this.targetDeck = new FormattedStringExpression(targetDeck);
    }

    public FormattedStringExpression getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(FormattedStringExpression targetProperty) {
        this.targetProperty = targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = new FormattedStringExpression(targetProperty);
    }

    public FormattedStringExpression getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(FormattedStringExpression targetValue) {
        this.targetValue = targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = new FormattedStringExpression(targetValue);
    }

    public CompareMode getTargetCompare() {
        return this.targetCompare;
    }

    public void setTargetCompare(CompareMode targetCompare) {
        this.targetCompare = targetCompare;
    }

    public void setTargetCompare(String targetCompare) {
        this.targetCompare = CompareMode.valueOf(targetCompare);
    }

    public Expression getTargetX() {
        return this.targetX;
    }

    public void setTargetX(FormattedStringExpression targetX) {
        this.targetX = targetX;
    }

    public void setTargetX(String targetX) {
        this.targetX = new FormattedStringExpression(targetX);
    }

    public void setTargetX(int targetX) {
        this.targetX = new FormattedStringExpression(Integer.toString(targetX));
    }

    public Expression getTargetY() {
        return this.targetY;
    }

    public void setTargetY(FormattedStringExpression targetY) {
        this.targetY = targetY;
    }

    public void setTargetY(String targetY) {
        this.targetY = new FormattedStringExpression(targetY);
    }

    public void setTargetY(int targetY) {
        this.targetY = new FormattedStringExpression(Integer.toString(targetY));
    }

    public FormattedStringExpression getTargetAttachment() {
        return this.targetAttachment;
    }

    public void setTargetAttachment(String targetAttachment) {
        this.targetAttachment = new FormattedStringExpression(targetAttachment);
    }

    public FormattedStringExpression getTargetAttachmentId() {
        return this.targetAttachmentId;
    }

    public void setTargetAttachmentId(String targetAttachmentId) {
        this.targetAttachmentId = new FormattedStringExpression(targetAttachmentId);
    }

    public void setCurPiece(GamePiece curPiece) {
        this.curPiece = curPiece;
    }

    public GamePiece getCurPiece() {
        return this.curPiece;
    }

    public static enum GKCtype {
        COUNTER,
        MAP,
        MODULE,
        DECK;

    }

    public static enum Target {
        CURSTACK,
        CURMAP,
        CURZONE,
        CURLOC,
        MAP,
        ZONE,
        LOCATION,
        XY,
        DECK,
        CURMAT,
        CURATTACH;


        public boolean isCurrent() {
            return this == CURSTACK || this == CURMAP || this == CURZONE || this == CURLOC || this == CURMAT || this == CURATTACH;
        }

        public String toTranslatedString() {
            return "Editor.GlobalKeyCommand.target_" + this.name().toLowerCase();
        }

        public static String[] getKeys() {
            return (String[])Arrays.stream(Target.values()).map(Enum::name).toArray(String[]::new);
        }

        public static String[] geti18nKeys() {
            return (String[])Arrays.stream(Target.values()).map(Target::toTranslatedString).toArray(String[]::new);
        }
    }

    public static enum CompareMode {
        EQUALS("=="),
        NOT_EQUALS("!="),
        GREATER(">"),
        GREATER_EQUALS(">="),
        LESS("<"),
        LESS_EQUALS("<="),
        MATCH("=~"),
        NOT_MATCH("!~");

        String symbol;

        private CompareMode(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static CompareMode whichSymbol(String symbol) {
            for (CompareMode mode : CompareMode.values()) {
                if (!mode.getSymbol().equals(symbol)) continue;
                return mode;
            }
            return EQUALS;
        }

        public static String[] getSymbols() {
            return (String[])Arrays.stream(CompareMode.values()).map(CompareMode::getSymbol).toArray(String[]::new);
        }
    }
}

