/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class UseTracker {
    private final Map<File, Integer> using = new HashMap<File, Integer>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public synchronized boolean anyInUse() {
        return !this.using.isEmpty();
    }

    public synchronized boolean isInUse(File file) {
        return this.using.containsKey(file);
    }

    public synchronized boolean isEditing(File file) {
        return Integer.valueOf(-1).equals(this.using.get(file));
    }

    public synchronized void incrementUsed(File file) {
        boolean wasOpen = this.using.isEmpty();
        this.using.merge(file, 1, Integer::sum);
        boolean isOpen = this.using.isEmpty();
        if (wasOpen != isOpen) {
            this.pcs.firePropertyChange("open", wasOpen, isOpen);
        }
    }

    public synchronized void decrementUsed(File file) {
        boolean wasOpen = this.using.isEmpty();
        this.using.merge(file, 0, (v, n) -> v == 1 ? null : Integer.valueOf(v - 1));
        boolean isOpen = this.using.isEmpty();
        if (wasOpen != isOpen) {
            this.pcs.firePropertyChange("open", wasOpen, isOpen);
        }
    }

    public synchronized void markEditing(File file) {
        boolean wasOpen = this.using.isEmpty();
        this.using.put(file, -1);
        boolean isOpen = this.using.isEmpty();
        if (wasOpen != isOpen) {
            this.pcs.firePropertyChange("open", wasOpen, isOpen);
        }
    }

    public synchronized void unmarkEditing(File file) {
        boolean wasOpen = this.using.isEmpty();
        this.using.remove(file);
        boolean isOpen = this.using.isEmpty();
        if (wasOpen != isOpen) {
            this.pcs.firePropertyChange("open", wasOpen, isOpen);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

