/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.image.tilecache.TileNotFoundException;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.FileStore;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ImageTileDiskCache
implements ImageTileSource,
FileStore {
    protected final String cpath;

    public ImageTileDiskCache(String cpath) {
        this.cpath = cpath;
    }

    private String tileNameFor(String name, int tileX, int tileY, double scale) {
        return this.cpath + "/" + TileUtils.tileName(name, tileX, tileY, (int)(1.0 / scale));
    }

    @Override
    public BufferedImage getTile(String name, int tileX, int tileY, double scale) throws ImageIOException {
        try {
            return TileUtils.read(this.tileNameFor(name, tileX, tileY, scale));
        }
        catch (TileNotFoundException e) {
            throw new TileNotFoundException(name, tileX, tileY, scale, e);
        }
    }

    @Override
    public Dimension getTileSize(String name, int tileX, int tileY, double scale) throws ImageIOException {
        try {
            return TileUtils.size(this.tileNameFor(name, tileX, tileY, scale));
        }
        catch (TileNotFoundException e) {
            throw new TileNotFoundException(name, tileX, tileY, scale, e);
        }
    }

    @Override
    public boolean tileExists(String name, int tileX, int tileY, double scale) throws ImageIOException {
        File f = new File(this.tileNameFor(name, tileX, tileY, scale));
        return f.exists() && f.isFile();
    }

    @Override
    public boolean contains(String path) throws IOException {
        return new File(this.cpath + "/" + path).exists();
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return Files.newInputStream(Path.of(this.cpath, path), new OpenOption[0]);
    }

    @Override
    public long getSize(String path) throws IOException {
        return new File(this.cpath + "/" + path).length();
    }

    @Override
    public long getMTime(String path) throws IOException {
        return new File(this.cpath + "/" + path).lastModified();
    }

    @Override
    public List<String> getFiles() throws IOException {
        File[] files = new File(this.cpath).listFiles();
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File f : files) {
            names.add(f.getPath());
        }
        return names;
    }

    @Override
    public List<String> getFiles(String root) throws IOException {
        File[] files = new File(this.cpath).listFiles();
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File f : files) {
            String path = f.getPath();
            if (!path.startsWith(root)) continue;
            names.add(path);
        }
        return names;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }
}

