/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.AbstractProxy;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class MenuItemProxy
extends AbstractProxy<JMenuItem> {
    protected Action action;
    private boolean hideIfBlank = false;

    public MenuItemProxy() {
        this(null);
    }

    public MenuItemProxy(Action action) {
        this.action = action;
    }

    public MenuItemProxy(Action action, boolean hideIfBlank) {
        this.action = action;
        this.hideIfBlank = hideIfBlank;
    }

    public void setHideIfBlank(boolean hideIfBlank) {
        this.hideIfBlank = hideIfBlank;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.forEachPeer(item -> {
            item.setAction(action);
            if (action == null) {
                item.setVisible(false);
            } else {
                String name = (String)action.getValue("Name");
                item.setVisible(!this.hideIfBlank || name != null && !name.isEmpty());
            }
        });
    }

    @Override
    public JMenuItem createPeer() {
        JMenuItem item = new JMenuItem(this.action);
        if (this.action == null) {
            item.setVisible(false);
        } else {
            String name = (String)this.action.getValue("Name");
            item.setVisible(!this.hideIfBlank || name != null && !name.isEmpty());
        }
        this.peers.add(new WeakReference<JMenuItem>(item, this.queue));
        return item;
    }
}

