/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.index;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.index.VassalMapPieceIndex;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IndexManager {
    private final java.util.Map<Map, VassalMapPieceIndex> indexes = new HashMap<Map, VassalMapPieceIndex>();

    private VassalMapPieceIndex getIndex(Map map) {
        return this.indexes.computeIfAbsent(map, m -> new VassalMapPieceIndex((Map)m));
    }

    public void rebuild() {
        new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "Indexing pieces...").execute();
        this.clearAll();
        for (GamePiece piece : GameModule.getGameModule().getGameState().getAllPieces()) {
            Map map = piece.getMap();
            if (map == null) continue;
            this.pieceMoved(piece, map);
        }
    }

    public void clearAll() {
        this.indexes.clear();
    }

    public void pieceMoved(GamePiece piece, Map map) {
        if (map != null) {
            if (piece instanceof Stack) {
                for (GamePiece p : ((Stack)piece).asList()) {
                    this.getIndex(map).addOrUpdatePiece(p);
                }
            } else {
                this.getIndex(map).addOrUpdatePiece(piece);
            }
        }
    }

    public void pieceRemoved(GamePiece piece, Map map) {
        if (map != null) {
            if (piece instanceof Stack) {
                for (GamePiece p : ((Stack)piece).asList()) {
                    this.getIndex(map).removePiece(p);
                }
            } else {
                this.getIndex(map).removePiece(piece);
            }
        }
    }

    public List<GamePiece> getPieces(GamePiece piece, int range, boolean forceAsPixels) {
        Map map = piece.getMap();
        VassalMapPieceIndex index = this.getIndex(map);
        return index.getPieces(piece, range, forceAsPixels);
    }

    public List<GamePiece> getPieces(GamePiece piece, int range) {
        return this.getPieces(piece, range, false);
    }

    public List<GamePiece> getPieces(Map map, Point point, int range, boolean forceAsPixels) {
        VassalMapPieceIndex index = this.getIndex(map);
        return index.getPieces(point, range, forceAsPixels);
    }

    public List<GamePiece> getPieces(Map map, Point point, int range) {
        return this.getPieces(map, point, range, false);
    }

    public List<GamePiece> getPieces(Map map, Point point) {
        return this.getPieces(map, point, 0);
    }

    public List<GamePiece> getPieces(Map map, String propertyName, String propertyValue) {
        VassalMapPieceIndex index = this.getIndex(map);
        return new ArrayList<GamePiece>(index.getPieces(propertyName, propertyValue));
    }
}

