/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SolidColorOp
extends AbstractTiledOpImpl {
    protected final Color color;
    protected final int hash;

    public SolidColorOp(Color color, int w, int h) {
        this.color = color;
        this.size = new Dimension(w, h);
        this.tileSize = new Dimension(256, 256);
        this.numXTiles = (int)Math.ceil((double)this.size.width / (double)this.tileSize.width);
        this.numYTiles = (int)Math.ceil((double)this.size.height / (double)this.tileSize.height);
        this.tiles = null;
        this.hash = Objects.hash(color, this.size);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws Exception {
        return SolidColorOp.draw(this.size.width, this.size.height, this.color);
    }

    private static BufferedImage draw(int dw, int dh, Color color) {
        if (dw < 1 || dh < 1) {
            return ImageUtils.NULL_IMAGE;
        }
        BufferedImage dst = ImageUtils.createCompatibleImage(dw, dh, color.getTransparency() != 1);
        Graphics g = dst.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, dw, dh);
        g.dispose();
        return dst;
    }

    @Override
    protected void fixTileSize() {
    }

    @Override
    protected void fixSize() {
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public ImageOp getTileOp(int tileX, int tileY) {
        return this.createTileOp(tileX, tileY);
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SolidColorOp op = (SolidColorOp)o;
        return this.color.equals(op.color) && this.size.equals(op.size);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[color=" + String.valueOf(this.color) + ",size=" + String.valueOf(this.size) + "]";
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final Color color;
        private final int hash;

        public TileOp(SolidColorOp scop, int tileX, int tileY) {
            if (scop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= scop.getNumXTiles() || tileY < 0 || tileY >= scop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.color = scop.getColor();
            this.sop = scop;
            int stw = this.sop.getTileWidth();
            int sth = this.sop.getTileHeight();
            int dx0 = tileX * stw;
            int dy0 = tileY * sth;
            int dw = Math.min(stw, this.sop.getWidth() - dx0);
            int dh = Math.min(sth, this.sop.getHeight() - dy0);
            this.size = new Dimension(dw, dh);
            this.hash = Objects.hash(this.sop, this.color, this.size);
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            return SolidColorOp.draw(this.size.width, this.size.height, this.color);
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.size.equals(op.size) && this.color.equals(op.color) && this.sop.equals(op.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + String.valueOf(this.sop) + ",color=" + String.valueOf(this.color) + ",size=" + String.valueOf(this.size) + "]";
        }
    }
}

