/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;

public class IncrementProperty
implements PropertyChanger {
    protected Constraints constraints;
    protected FormattedString format = new FormattedString();
    protected PropertyChangerConfigurer prop;

    public IncrementProperty(PropertyChangerConfigurer prop, String incr, Constraints constraints) {
        this.prop = prop;
        this.constraints = constraints;
        this.format.setFormat(incr);
    }

    public String getRawValue() {
        return this.format.getFormat();
    }

    public PropertyChangerConfigurer getProp() {
        return this.prop;
    }

    public Constraints getPropSource() {
        return this.constraints;
    }

    @Override
    public String getNewValue(String oldValue) {
        int value;
        try {
            value = oldValue == null || oldValue.length() == 0 ? 0 : Integer.parseInt(oldValue);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": oldValue =" + oldValue, e));
            return oldValue;
        }
        AuditTrail audit = AuditTrail.create((Auditable)this.constraints, this.format.getFormat());
        try {
            String s = this.format.getText(this.getTargetPropertySource(), (Auditable)this.constraints, audit);
            int incr = Integer.parseInt(s);
            if (!this.constraints.isNumeric()) {
                value += incr;
            } else if (this.constraints.isWrap()) {
                int min = this.constraints.getMinimumValue();
                int max = this.constraints.getMaximumValue();
                value = min + (value - min + incr) % (max - min + incr);
            } else {
                value += incr;
                value = Math.min(this.constraints.getMaximumValue(), value);
                value = Math.max(this.constraints.getMinimumValue(), value);
            }
            return String.valueOf(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": format=" + this.format.getFormat() + ", value=" + this.format.getText((PropertySource)this.constraints, (Auditable)this.constraints, audit), e, this.constraints, audit));
            return oldValue;
        }
    }

    public PropertySource getTargetPropertySource() {
        return this.constraints.getPropertySource();
    }

    public String getIncrement() {
        return this.format.getFormat();
    }

    public static interface Constraints
    extends PropertySource {
        public int getMinimumValue();

        public int getMaximumValue();

        public boolean isNumeric();

        public boolean isWrap();

        public PropertySource getPropertySource();
    }
}

