/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.counters.EditablePiece;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.filechooser.AudioFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;

public class AudioClipConfigurer
extends FileConfigurer {
    protected static DirectoryConfigurer resourceDirPref;
    protected FormattedExpressionConfigurer.ExpressionButton button;
    protected EditablePiece sourcePiece;

    public AudioClipConfigurer(String key, String name, ArchiveWriter archive, EditablePiece piece) {
        super(key, name, archive);
        this.sourcePiece = piece;
    }

    public AudioClipConfigurer(String key, String name, ArchiveWriter archive) {
        super(key, name);
        this.archive = archive;
    }

    @Override
    protected FileChooser initFileChooser() {
        if (resourceDirPref == null) {
            resourceDirPref = new DirectoryConfigurer("audioDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, resourceDirPref);
        }
        FileChooser fc = FileChooser.createFileChooser(GameModule.getGameModule().getPlayerWindow(), resourceDirPref);
        fc.setFileFilter(new AudioFileFilter());
        return fc;
    }

    @Override
    protected void addToArchive(File f) {
        this.archive.addSound(f.getPath(), f.getName());
    }

    @Override
    public Component getControls() {
        Component c = super.getControls();
        if (this.button == null) {
            this.button = new FormattedExpressionConfigurer.ExpressionButton(this, this.tf.getPreferredSize().height, this.sourcePiece);
            ((JPanel)c).add(this.button);
        }
        return c;
    }
}

