/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.HintTextField;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;

public class NamedHotKeyConfigurer
extends Configurer
implements FocusListener {
    private static final String STROKE_HINT = Resources.getString("Editor.NamedHotKeyConfigurer.keystroke");
    private static final String NAME_HINT = Resources.getString("Editor.NamedHotKeyConfigurer.command");
    private HintTextField keyStroke;
    private HintTextField keyName;
    private JPanel controls;
    private String lastValue;
    private JButton undoButton;
    private final int defaultFieldLength;

    private HintTextField getKeyStroke() {
        if (this.keyStroke == null) {
            this.keyStroke = new HintTextField(this.defaultFieldLength, STROKE_HINT);
        }
        return this.keyStroke;
    }

    private HintTextField getKeyName() {
        if (this.keyName == null) {
            this.keyName = new HintTextField(this.defaultFieldLength, NAME_HINT);
        }
        return this.keyName;
    }

    public static String getFancyString(NamedKeyStroke k) {
        Object s = NamedHotKeyConfigurer.getString(k);
        if (((String)s).length() > 0) {
            s = "[" + (String)s + "]";
        }
        return s;
    }

    public static String getString(NamedKeyStroke k) {
        return k == null || k.isNull() ? "" : NamedHotKeyConfigurer.getString(k.getStroke());
    }

    public static String getString(KeyStroke k) {
        return NamedKeyManager.isNamed(k) ? "" : HotKeyConfigurer.getString(k);
    }

    public NamedHotKeyConfigurer(String key, String name, NamedKeyStroke val, int defaultFieldLength) {
        super(key, name, val);
        this.defaultFieldLength = defaultFieldLength;
    }

    public NamedHotKeyConfigurer(String key, String name, NamedKeyStroke val) {
        this(key, name, val, 16);
    }

    public NamedHotKeyConfigurer(String key, String name) {
        this(key, name, NamedKeyStroke.NULL_KEYSTROKE);
    }

    public NamedHotKeyConfigurer(NamedKeyStroke val, int defaultFieldLength) {
        this(null, null, val, defaultFieldLength);
    }

    public NamedHotKeyConfigurer(NamedKeyStroke val) {
        this(null, null, val);
    }

    public NamedHotKeyConfigurer() {
        this(null);
    }

    @Override
    public String getValueString() {
        return NamedHotKeyConfigurer.encode((NamedKeyStroke)this.getValue());
    }

    public NamedKeyStroke getValueNamedKeyStroke() {
        return (NamedKeyStroke)this.value;
    }

    public boolean isNamed() {
        return this.value != null && ((NamedKeyStroke)this.value).isNamed();
    }

    @Override
    public void requestFocus() {
        if (this.keyName != null) {
            this.keyName.requestFocus();
        }
    }

    @Override
    public void setValue(Object o) {
        this.setFrozen(true);
        if (this.controls != null && !this.noUpdate) {
            NamedKeyStroke stroke = (NamedKeyStroke)o;
            if (stroke != null && stroke.isNamed()) {
                this.keyName.setText(stroke.getName());
                this.keyStroke.setText("");
            } else {
                this.keyName.setText("");
                this.keyStroke.setText(NamedHotKeyConfigurer.getString(stroke));
            }
            this.updateVisibility();
        }
        this.setFrozen(false);
        super.setValue(o);
    }

    protected void updateVisibility() {
        this.getKeyName().setFocusOnly(this.isNonNullValue());
        this.getKeyStroke().setFocusOnly(this.isNonNullValue());
    }

    private boolean isNonNullValue() {
        return this.value != null && !((NamedKeyStroke)this.value).isNull();
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : NamedHotKeyConfigurer.decode(s));
    }

    private void updateValueFromKeyName() {
        if (!this.isFrozen()) {
            String key = this.keyName.getText();
            if (key.isEmpty()) {
                this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
            } else {
                this.setValue(NamedKeyStroke.of(key));
            }
        }
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new ConfigurerPanel(this.getName(), "[fill,grow]", "[][fill,grow]");
            this.keyStroke = this.getKeyStroke();
            this.keyStroke.setMaximumSize(new Dimension(this.keyStroke.getMaximumSize().width, this.keyStroke.getPreferredSize().height));
            this.keyStroke.setText(this.keyToString());
            this.keyStroke.addKeyListener(new KeyStrokeAdapter());
            ((AbstractDocument)this.keyStroke.getDocument()).setDocumentFilter(new KeyStrokeFilter());
            this.keyStroke.addFocusListener(this);
            this.keyStroke.setTransferHandler(null);
            this.keyName = this.getKeyName();
            this.keyName.setMaximumSize(new Dimension(this.keyName.getMaximumSize().width, this.keyName.getPreferredSize().height));
            this.keyName.setText(this.getValueNamedKeyStroke() == null ? null : this.getValueNamedKeyStroke().getName());
            ((AbstractDocument)this.keyName.getDocument()).setDocumentFilter(new KeyNameFilter());
            this.keyName.addFocusListener(this);
            this.keyName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NamedHotKeyConfigurer.this.keyName.selectAll();
                        }
                    });
                }
            });
            JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]0[]0[fill,grow]0[]"));
            ConfigLayerUI layerUI = new ConfigLayerUI(this);
            JLayer<JTextField> nameLayer = new JLayer<JTextField>(this.keyName, layerUI);
            panel.add(nameLayer, "grow");
            panel.add(new JLabel("-"));
            JLayer<JTextField> keyLayer = new JLayer<JTextField>(this.keyStroke, layerUI);
            panel.add(keyLayer, "grow");
            this.undoButton = new JButton(IconFactory.getIcon("edit-undo", 0));
            int size = (int)this.keyName.getPreferredSize().getHeight();
            this.undoButton.setPreferredSize(new Dimension(size, size));
            this.undoButton.setMaximumSize(new Dimension(size, size));
            this.undoButton.addActionListener(e -> this.undo());
            this.undoButton.setEnabled(false);
            this.undoButton.setToolTipText(Resources.getString("Editor.undo"));
            panel.add(this.undoButton);
            this.controls.add((Component)panel, "grow");
            this.updateVisibility();
        }
        return this.controls;
    }

    private void undo() {
        if (this.lastValue != null) {
            this.setValue(this.lastValue);
            this.lastValue = null;
            this.undoButton.setEnabled(false);
            this.keyName.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.lastValue = this.getValueString();
        this.undoButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public String keyToString() {
        return NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue());
    }

    protected boolean isPrintableAscii(char c) {
        return this.isPrintableAscii((int)c);
    }

    protected boolean isPrintableAscii(int i) {
        return i >= 32 && i <= 126;
    }

    public static NamedKeyStroke decode(String s) {
        if (s == null) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        String[] parts = s.split(",");
        if (parts.length < 2) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        try {
            KeyStroke stroke = KeyStroke.getKeyStroke(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            String name = null;
            if (parts.length > 2) {
                name = parts[2];
            }
            return NamedKeyStroke.of(stroke, name);
        }
        catch (Exception e) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
    }

    public static String encode(NamedKeyStroke stroke) {
        if (stroke == null) {
            return "";
        }
        KeyStroke key = stroke.getStroke();
        if (key == null) {
            return "";
        }
        String s = key.getKeyCode() + "," + key.getModifiers();
        if (stroke.isNamed()) {
            s = s + "," + stroke.getName();
        }
        return s;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.getKeyStroke().setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.getKeyName().setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.getKeyStroke().repaint();
        this.getKeyName().repaint();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.getKeyStroke().addFocusListener(listener);
        this.getKeyName().addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.getKeyStroke().removeFocusListener(listener);
        this.getKeyName().removeFocusListener(listener);
    }

    private class KeyStrokeAdapter
    extends KeyAdapter {
        private KeyStrokeAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 8: 
                case 127: {
                    if (NamedHotKeyConfigurer.this.getValue().equals(NamedKeyStroke.NULL_KEYSTROKE) || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isAltDown()) {
                        NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.of(SwingUtils.convertKeyEvent(e)));
                        break;
                    }
                    NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                    break;
                }
                case 0: 
                case 16: 
                case 17: 
                case 18: 
                case 157: 
                case 65406: {
                    break;
                }
                case 10: 
                case 27: {
                    e.consume();
                    NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.of(SwingUtils.convertKeyEvent(e)));
                    break;
                }
                default: {
                    NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.of(SwingUtils.convertKeyEvent(e)));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (SystemUtils.IS_OS_MAC) {
                switch (e.getKeyCode()) {
                    case 8: 
                    case 127: {
                        if (NamedHotKeyConfigurer.this.getValue().equals(NamedKeyStroke.NULL_KEYSTROKE) || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isAltDown()) {
                            NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.of(SwingUtils.convertKeyEvent(e)));
                            break;
                        }
                        NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                        break;
                    }
                    case 0: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        break;
                    }
                    default: {
                        NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.of(SwingUtils.convertKeyEvent(e)));
                    }
                }
            }
        }
    }

    private class KeyStrokeFilter
    extends DocumentFilter {
        private KeyStrokeFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, 0, NamedHotKeyConfigurer.this.keyStroke.getText().length(), text, attrs);
        }
    }

    private class KeyNameFilter
    extends DocumentFilter {
        private KeyNameFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
            NamedHotKeyConfigurer.this.keyName.setCaretPosition(offset);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            super.insertString(fb, offset, string, attr);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
            NamedHotKeyConfigurer.this.keyName.setCaretPosition(offset + string.length());
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, offset, length, text, attrs);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
            NamedHotKeyConfigurer.this.keyName.setCaretPosition(offset + text.length());
        }
    }

    private static class ConfigLayerUI
    extends LayerUI<JTextField> {
        private static final long serialVersionUID = 1L;
        private final Configurer parent;

        public ConfigLayerUI(Configurer parent) {
            this.parent = parent;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Object cc = ((JLayer)c).getView();
            if (this.parent.isHighlighted()) {
                Dimension d = ((Component)cc).getSize();
                g.setColor(Color.red);
                g.drawRect(0, 0, d.width - 2, d.height - 2);
            }
        }
    }
}

