/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;

public interface EditablePiece
extends GamePiece {
    public String getDescription();

    public void mySetType(String var1);

    public PieceEditor getEditor();

    public HelpFile getHelpFile();

    default public String getBaseDescription() {
        String desc = this.getDescription();
        if (desc.contains(" - ")) {
            return desc.substring(0, desc.indexOf(" - "));
        }
        return desc;
    }

    @Override
    default public Command prepareMove(Command c, boolean mark_moved) {
        Map map;
        GameModule.getGameModule().getDeckManager().clearEmptyDecksList();
        GamePiece outer = Decorator.getOutermost(this);
        if (mark_moved && (map = this.getMap()) != null && map.isMarkMoved()) {
            ChangeTracker tracker = new ChangeTracker(outer);
            outer.setProperty("MaybeMoved", Boolean.TRUE);
            c = c.append(tracker.getChangeCommand());
        }
        c = c.append(Decorator.putOldProperties(this));
        Stack parent = outer.getParent();
        if (parent != null) {
            c = c.append(parent.pieceRemoved(outer));
        }
        return c;
    }

    @Override
    default public Command checkTrueMoved() {
        String loc = (String)this.getProperty("LocationName");
        String oldLoc = (String)this.getProperty("OldLocationName");
        if (loc == null || loc.equals(oldLoc)) {
            if (GameModule.getGameModule().isMatSupport()) {
                String mat = (String)this.getProperty("MatID");
                String oldMat = (String)this.getProperty("OldMatID");
                if (mat == null || mat.equals(oldMat)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        GamePiece outer = Decorator.getOutermost(this);
        ChangeTracker tracker = new ChangeTracker(outer);
        outer.setProperty("Moved", Boolean.TRUE);
        return tracker.getChangeCommand();
    }

    @Override
    default public Command finishMove(Command c, boolean afterburner, boolean findmat) {
        return this.finishMove(c, afterburner, findmat, false);
    }

    @Override
    default public Command finishMove(Command c, boolean afterburner, boolean findmat, boolean mark_moved) {
        Map map;
        GamePiece outer = Decorator.getOutermost(this);
        if (findmat) {
            c = MatCargo.findNewMat(c, outer);
        }
        if (mark_moved && GameModule.getGameModule().isTrueMovedSupport() && (map = this.getMap()) != null && map.isMarkMoved()) {
            c = c.append(this.checkTrueMoved());
        }
        if (afterburner && (map = outer.getMap()).getMoveKey() != null) {
            c = c.append(outer.keyEvent(map.getMoveKey()));
        }
        c = GameModule.getGameModule().getDeckManager().checkEmptyDecks(c);
        return c;
    }
}

