/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.i18n.Resources;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.ReflectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExtensionTree
extends ConfigureTree {
    private static final long serialVersionUID = 1L;
    private final ModuleExtension extension;

    public ExtensionTree(Configurable root, HelpWindow helpWindow, ModuleExtension extension, EditorWindow editorWindow) {
        super(root, helpWindow, editorWindow);
        this.extension = extension;
        this.setCellRenderer(new ExtensionRenderer());
    }

    @Override
    public int checkMinimumIndex(DefaultMutableTreeNode targetNode, int index) {
        if (this.isEditable(targetNode)) {
            return index;
        }
        while (index < targetNode.getChildCount() && !this.isEditable((DefaultMutableTreeNode)targetNode.getChildAt(index))) {
            ++index;
        }
        return index;
    }

    public boolean isEditable(DefaultMutableTreeNode node) {
        if (this.extension == null) {
            return false;
        }
        if (node != null) {
            for (ExtensionElement el : this.extension.getComponentsOf(ExtensionElement.class)) {
                if (el.getExtension() != node.getUserObject()) continue;
                return true;
            }
            if (node.getParent() instanceof DefaultMutableTreeNode) {
                return this.isEditable((DefaultMutableTreeNode)node.getParent());
            }
        }
        return false;
    }

    public Configurable[] getPath(DefaultMutableTreeNode node) {
        Object[] nodePath = node.getUserObjectPath();
        Configurable[] path = new Configurable[nodePath.length - 1];
        for (int i = 0; i < path.length; ++i) {
            path[i] = (Configurable)nodePath[i + 1];
        }
        return path;
    }

    @Override
    public void externalInsert(Configurable parent, Configurable child) {
        super.externalInsert(parent, child);
        if (!this.isEditable(parent)) {
            this.extension.add(new ExtensionElement(child, this.getPath(this.getTreeNode(parent))));
        }
    }

    @Override
    protected Action buildAddAction(Configurable target, Class<? extends Buildable> newConfig) {
        return this.buildAddAction(target, newConfig, "Editor.ConfigureTree.add_component", -1, null);
    }

    @Override
    protected Action buildAddAction(final Configurable target, final Class<? extends Buildable> newConfig, String key, final int index, final Configurable duplicate) {
        return new AbstractAction(this, Resources.getString(key, ExtensionTree.getConfigureName(newConfig))){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ ExtensionTree this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configurable ch = null;
                try {
                    ch = (Configurable)newConfig.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, newConfig);
                }
                if (ch != null) {
                    int finalIndex;
                    final Configurable child = ch;
                    child.build(duplicate != null ? duplicate.getBuildElement(Builder.createNewDocument()) : null);
                    if (child instanceof PieceSlot) {
                        ((PieceSlot)child).updateGpId(this.this$0.extension);
                    }
                    int n = finalIndex = index < 0 ? this.this$0.getTreeNode(target).getChildCount() : this.this$0.checkMinimumIndex(this.this$0.getTreeNode(target), index);
                    if (child.getConfigurer() != null) {
                        if (this.this$0.insert(target, child, finalIndex)) {
                            PropertiesWindow w = new PropertiesWindow(this, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.this$0), false, child, this.this$0.helpWindow){
                                private static final long serialVersionUID = 1L;
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    super(owner, modal, target, helpWindow);
                                }

                                @Override
                                public void save() {
                                    super.save();
                                    if (!this.this$1.this$0.isEditable(this.this$1.target)) {
                                        ExtensionElement el = new ExtensionElement(child, this.this$1.this$0.getPath(this.this$1.this$0.getTreeNode(this.this$1.target)));
                                        this.this$1.this$0.extension.add(el);
                                    }
                                }

                                @Override
                                public void cancel() {
                                    this.this$1.this$0.delete(child);
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        }
                    } else {
                        boolean inserted = this.this$0.insert(target, child, finalIndex);
                        if (inserted && !this.this$0.isEditable(this.this$0.getTreeNode(target))) {
                            this.this$0.extension.add(new ExtensionElement(child, this.this$0.getPath(this.this$0.getTreeNode(target))));
                        }
                    }
                }
            }
        };
    }

    @Override
    protected Action buildImportAction(final Configurable target) {
        return new AbstractAction(this, Resources.getString("Editor.ConfigureTree.add_imported_class")){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ ExtensionTree this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                final Configurable child = this.this$0.importConfigurable();
                if (child != null) {
                    try {
                        child.build(null);
                        if (child.getConfigurer() != null) {
                            PropertiesWindow w = new PropertiesWindow(this, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.this$0), false, child, this.this$0.helpWindow){
                                private static final long serialVersionUID = 1L;
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                    super(owner, modal, target, helpWindow);
                                }

                                @Override
                                public void save() {
                                    super.save();
                                    this.this$1.this$0.insert(this.this$1.target, child, this.this$1.this$0.getTreeNode(this.this$1.target).getChildCount());
                                    if (!this.this$1.this$0.isEditable(this.this$1.target)) {
                                        ExtensionElement el = new ExtensionElement(child, this.this$1.this$0.getPath(this.this$1.this$0.getTreeNode(this.this$1.target)));
                                        this.this$1.this$0.extension.add(el);
                                    }
                                }

                                @Override
                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        } else {
                            this.this$0.insert(target, child, this.this$0.getTreeNode(target).getChildCount());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.this$0.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(child) + " to " + ConfigureTree.getConfigureName(target) + "\n" + ex.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
    }

    private boolean isEditable(Configurable target) {
        return this.isEditable(this.getTreeNode(target));
    }

    @Override
    protected Action buildEditAction(Configurable target) {
        return this.isEditable(target) ? super.buildEditAction(target) : null;
    }

    @Override
    protected Action buildCutAction(Configurable target) {
        return this.isEditable(target) ? super.buildCutAction(target) : null;
    }

    @Override
    protected Action buildPasteAction(final Configurable target) {
        Action a;
        if (this.isEditable(target)) {
            a = super.buildPasteAction(target);
        } else {
            a = new AbstractAction(this, Resources.getString("Editor.ConfigureTree.paste")){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ ExtensionTree this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.this$0.cutData != null) {
                        DefaultMutableTreeNode targetNode = this.this$0.getTreeNode(target);
                        Configurable cutTarget = (Configurable)this.this$0.cutData.getUserObject();
                        Configurable convertedCutTarget = this.this$0.convertChild(target, cutTarget);
                        if (this.this$0.remove(this.this$0.getParent(this.this$0.cutData), cutTarget)) {
                            this.this$0.deleteFromExtension(this.this$0.getParent(this.this$0.cutData), cutTarget);
                            if (this.this$0.insert(target, convertedCutTarget, targetNode.getChildCount())) {
                                this.this$0.postPasteFixups(convertedCutTarget);
                                this.this$0.extension.add(new ExtensionElement(convertedCutTarget, this.this$0.getPath(targetNode)));
                            }
                        }
                    } else if (this.this$0.copyData != null) {
                        Configurable copyTarget = (Configurable)this.this$0.copyData.getUserObject();
                        Buildable clone = null;
                        try {
                            clone = this.this$0.convertChild(target, (Configurable)copyTarget.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Throwable t) {
                            ReflectionUtils.handleNewInstanceFailure(t, copyTarget.getClass());
                        }
                        if (clone != null) {
                            clone.build(copyTarget.getBuildElement(Builder.createNewDocument()));
                            if (this.this$0.insert(target, (Configurable)clone, this.this$0.getTreeNode(target).getChildCount())) {
                                this.this$0.updateGpIds((Configurable)clone);
                                this.this$0.postPasteFixups((Configurable)clone);
                                this.this$0.extension.add(new ExtensionElement(clone, this.this$0.getPath(this.this$0.getTreeNode(target))));
                            }
                        }
                    }
                    this.this$0.cutData = null;
                    this.this$0.updateEditMenu();
                }
            };
            a.setEnabled(this.isValidPasteTarget(target));
        }
        return a;
    }

    @Override
    protected boolean isValidPasteTarget(Configurable target) {
        return this.isValidPasteTarget(target, this.cutData) || this.isValidPasteTarget(target, this.copyData);
    }

    @Override
    protected boolean isValidPasteTarget(Configurable target, DefaultMutableTreeNode sourceNode) {
        if (sourceNode == null) {
            return false;
        }
        return super.isValidParent(target, (Configurable)sourceNode.getUserObject());
    }

    @Override
    public void updateGpIds(Configurable c) {
        if (c instanceof PieceSlot) {
            ((PieceSlot)c).updateGpId(this.extension);
        } else {
            for (Configurable conf : c.getConfigureComponents()) {
                this.updateGpIds(conf);
            }
        }
    }

    @Override
    protected Action buildMoveAction(Configurable target) {
        return this.isEditable((DefaultMutableTreeNode)this.getTreeNode(target).getParent()) ? super.buildMoveAction(target) : null;
    }

    @Override
    protected Action buildDeleteAction(final Configurable target) {
        AbstractAction action = null;
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null && this.isEditable(targetNode)) {
            final Configurable parent = (Configurable)((DefaultMutableTreeNode)targetNode.getParent()).getUserObject();
            action = new AbstractAction(this, Resources.getString("Editor.ConfigureTree.delete")){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ ExtensionTree this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean removed = this.this$0.remove(parent, target);
                    if (removed) {
                        this.this$0.deleteFromExtension(parent, target);
                    }
                }
            };
        }
        return action;
    }

    @Override
    protected Action buildCloneAction(final Configurable target) {
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        final DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        if (this.isEditable(parentNode)) {
            return super.buildCloneAction(target);
        }
        if (parentNode != null) {
            return new AbstractAction(this, Resources.getString("Editor.ConfigureTree.clone")){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ ExtensionTree this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Configurable clone = null;
                    try {
                        clone = (Configurable)target.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, target.getClass());
                    }
                    if (clone != null) {
                        clone.build(target.getBuildElement(Builder.createNewDocument()));
                        if (this.this$0.insert((Configurable)parentNode.getUserObject(), clone, parentNode.getChildCount())) {
                            this.this$0.extension.add(new ExtensionElement(clone, this.this$0.getPath(parentNode)));
                        }
                    }
                }
            };
        }
        return null;
    }

    @Override
    protected Action buildEditPiecesAction(Configurable target) {
        Action a = null;
        if (this.isEditable(target)) {
            a = super.buildEditPiecesAction(target);
        }
        return a;
    }

    @Override
    protected Action buildOpenPiecesAction(Configurable target) {
        Action a = null;
        if (this.isEditable(target)) {
            a = super.buildOpenPiecesAction(target);
        }
        return a;
    }

    @Override
    protected boolean isValidParent(Configurable parent, Configurable child) {
        return super.isValidParent(parent, child) && this.isEditable(parent);
    }

    @Override
    protected void updateEditMenu() {
        super.updateEditMenu();
        this.deleteAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.cutAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.propertiesAction.setEnabled(this.selected != null && this.isEditable(this.selected) && this.selected.getConfigurer() != null);
    }

    protected void deleteFromExtension(Configurable parent, Configurable child) {
        if (!this.isEditable(parent)) {
            for (ExtensionElement el : this.extension.getComponentsOf(ExtensionElement.class)) {
                if (el.getExtension() != child) continue;
                this.extension.remove(el);
                break;
            }
        }
    }

    protected void addToExtension(Configurable parent, Configurable child) {
        if (!this.isEditable(parent)) {
            ExtensionElement el = new ExtensionElement(child, this.getPath(this.getTreeNode(parent)));
            this.extension.add(el);
        }
    }

    @Override
    protected void postInsertProcessing(Configurable parent, Configurable child) {
        this.addToExtension(parent, child);
    }

    @Override
    protected void postRemoveProcessing(Configurable parent, Configurable child) {
        this.deleteFromExtension(parent, child);
    }

    class ExtensionRenderer
    extends ConfigureTree.Renderer {
        private static final long serialVersionUID = 1L;

        ExtensionRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            c.setForeground(ExtensionTree.this.isEditable((DefaultMutableTreeNode)value) ? Color.BLACK : Color.GRAY);
            return c;
        }
    }
}

