/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.module.Documentation;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.launch.LaunchTourAction;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstTimeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FirstTimeDialog.class);

    public FirstTimeDialog(Frame parent) {
        super(parent, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JLabel about = new JLabel();
        JLabel welcome = new JLabel();
        welcome.setFont(new Font("SansSerif", 1, 40));
        welcome.setText(Resources.getString("Main.welcome"));
        welcome.setForeground(Color.black);
        JButton tour = new JButton(new LaunchTourAction(parent));
        JButton jump = new JButton(Resources.getString("Main.jump_right_in"));
        JButton help = new JButton(Resources.getString("General.help"));
        ActionListener closer = evt -> this.dispose();
        tour.addActionListener(closer);
        jump.addActionListener(closer);
        try {
            File readme = new File(Documentation.getDocumentationBaseDir(), "README.html");
            help.addActionListener(new ShowHelpAction(readme.toURI().toURL(), null));
        }
        catch (MalformedURLException e2) {
            ErrorDialog.bug(e2);
        }
        JLabel lang = new JLabel(Resources.getString("Prefs.language") + ":");
        JComboBox<Locale> langbox = new JComboBox<Locale>(Resources.getSupportedLocales().toArray(new Locale[0]));
        langbox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((Locale)value).getDisplayName(Resources.getLocale()));
                return this;
            }
        });
        langbox.setSelectedItem(Resources.getLocale());
        langbox.addActionListener(e -> {
            Resources.setLocale((Locale)langbox.getSelectedItem());
            welcome.setText(Resources.getString("Main.welcome"));
            tour.setText(Resources.getString("Main.tour"));
            jump.setText(Resources.getString("Main.jump_right_in"));
            help.setText(Resources.getString("General.help"));
            lang.setText(Resources.getString("Prefs.language") + ":");
            this.pack();
        });
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(about).addComponent(welcome).addGroup(layout.createSequentialGroup().addComponent(tour).addComponent(jump).addComponent(help)).addGroup(layout.createSequentialGroup().addGap(0, 0, Integer.MAX_VALUE).addComponent(lang).addComponent(langbox).addGap(0, 0, Integer.MAX_VALUE)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(about).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addComponent(welcome).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(tour).addComponent(jump).addComponent(help)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(lang).addComponent(langbox)));
        layout.linkSize(tour, jump, help);
        this.add(panel);
        this.pack();
        BufferedImage img = null;
        try {
            img = ImageUtils.getImageResource("/images/Splash.png");
        }
        catch (ImageIOException e3) {
            logger.error("", (Throwable)e3);
        }
        if (img != null) {
            Rectangle screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension dsize = this.getSize();
            Dimension remainder = new Dimension(Math.max(screen.width - dsize.width, 0), Math.max(screen.height - dsize.height, 0));
            if (remainder.width > 0 && remainder.height > 0) {
                if (remainder.width >= img.getWidth() && remainder.height >= img.getHeight()) {
                    about.setIcon(new ImageIcon(img));
                } else {
                    double scale = Math.min((double)remainder.width / (double)img.getWidth(), (double)remainder.height / (double)img.getHeight());
                    about.setIcon(new ImageIcon(ImageUtils.transform(img, scale, 0.0)));
                }
            }
            this.pack();
        }
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(null);
    }
}

