/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class LaunchButton
extends JButton
implements Auditable {
    private static final long serialVersionUID = 1L;
    public static final String UNTRANSLATED_TEXT = "unTranslatedText";
    protected String tooltipAtt;
    protected String nameAtt;
    protected String keyAtt;
    protected String iconAtt;
    protected IconConfigurer iconConfig;
    protected String toolTipText;
    protected NamedKeyStrokeListener keyListener;
    protected Configurer nameConfig;
    protected Configurer keyConfig;
    protected boolean alwaysAcceptKeystroke;
    protected boolean forceVisible = false;
    protected boolean forceInvisible = false;
    protected boolean allowExpression;
    protected boolean usesExpression = false;
    protected FormattedString formatted = new FormattedString("");

    public LaunchButton(String text, String textAttribute, String hotkeyAttribute, ActionListener al) {
        this(text, textAttribute, hotkeyAttribute, null, al);
    }

    public LaunchButton(String text, String tooltipAttribute, String textAttribute, String hotkeyAttribute, String iconAttribute, ActionListener al) {
        this(text, textAttribute, hotkeyAttribute, iconAttribute, al);
        this.tooltipAtt = tooltipAttribute;
    }

    public LaunchButton(String text, String textAttribute, String hotkeyAttribute, String iconAttribute, ActionListener al) {
        this(text, textAttribute, hotkeyAttribute, iconAttribute, al, false);
    }

    public LaunchButton(String text, String tooltipAttribute, String textAttribute, String hotkeyAttribute, String iconAttribute, ActionListener al, boolean allowExpression) {
        this(text, textAttribute, hotkeyAttribute, iconAttribute, al, allowExpression);
        this.tooltipAtt = tooltipAttribute;
    }

    public LaunchButton(String text, String textAttribute, String hotkeyAttribute, String iconAttribute, ActionListener al, boolean allowExpression) {
        super(text);
        this.allowExpression = allowExpression;
        if (allowExpression) {
            this.setFormat(text);
        }
        this.alwaysAcceptKeystroke = false;
        this.nameAtt = textAttribute;
        this.keyAtt = hotkeyAttribute;
        this.iconAtt = iconAttribute;
        this.iconConfig = new IconConfigurer(this.iconAtt, null, null);
        this.setAlignmentY(0.0f);
        this.keyListener = new NamedKeyStrokeListener(e -> {
            if ((this.isEnabled() || this.isAlwaysAcceptKeystroke()) && (GlobalOptions.getInstance().isHotKeysOnClosedWindows() || this.getParent() != null && this.getParent().isShowing())) {
                al.actionPerformed(e);
            }
        });
        if (al != null) {
            GameModule.getGameModule().addKeyStrokeListener(this.keyListener);
            this.addActionListener(al);
        }
        this.setFocusable(false);
        this.checkVisibility();
    }

    public boolean isUsesExpression() {
        return this.usesExpression;
    }

    private void setFormat(String text) {
        this.formatted.setFormat(text);
        this.usesExpression = true;
        this.updateText();
        boolean bl = this.usesExpression = text.contains("$") || text.contains("{");
        if (this.usesExpression) {
            GameModule.getGameModule().setMutableButtonSupport(true);
        }
    }

    public void updateText() {
        if (this.usesExpression) {
            this.setText(this.formatted.getText((PropertySource)GameModule.getGameModule(), (Auditable)this, "Editor.DrawPile.count_express"));
        }
    }

    public Icon getLaunchIcon() {
        return this.iconConfig.getIconValue();
    }

    public boolean isAlwaysAcceptKeystroke() {
        return this.alwaysAcceptKeystroke;
    }

    public void setAlwaysAcceptKeystroke(boolean always) {
        this.alwaysAcceptKeystroke = always;
    }

    public boolean isForcevisible() {
        return this.forceVisible;
    }

    public void setForceVisible(boolean fv) {
        this.forceVisible = fv;
    }

    public boolean isForceInvisible() {
        return this.forceInvisible;
    }

    public void setForceInvisible(boolean fiv) {
        this.forceInvisible = fiv;
    }

    @Override
    public int getBaseline(int width, int height) {
        return -1;
    }

    public String getNameAttribute() {
        return this.nameAtt;
    }

    public String getHotkeyAttribute() {
        return this.keyAtt;
    }

    public String getIconAttribute() {
        return this.iconAtt;
    }

    public String getAttributeValueString(String key) {
        if (key.equals(this.nameAtt)) {
            if (this.allowExpression) {
                return this.formatted.getFormat();
            }
            return this.getText();
        }
        if (key.equals(this.keyAtt)) {
            return NamedHotKeyConfigurer.encode(this.keyListener.getNamedKeyStroke());
        }
        if (key.equals(this.iconAtt)) {
            return this.iconConfig.getValueString();
        }
        if (key.equals(this.tooltipAtt)) {
            return this.toolTipText;
        }
        return null;
    }

    public void setAttribute(String key, Object value) {
        if (key != null) {
            if (key.equals(this.nameAtt)) {
                if (Localization.getInstance().isTranslationInProgress()) {
                    this.putClientProperty(UNTRANSLATED_TEXT, this.getText());
                }
                if (this.allowExpression) {
                    this.setFormat((String)value);
                } else {
                    this.setText((String)value);
                }
                this.checkVisibility();
            } else if (key.equals(this.keyAtt)) {
                if (value instanceof String) {
                    value = NamedHotKeyConfigurer.decode((String)value);
                }
                if (value instanceof NamedKeyStroke) {
                    this.keyListener.setKeyStroke((NamedKeyStroke)value);
                } else {
                    this.keyListener.setKeyStroke((KeyStroke)value);
                }
                this.setToolTipText(this.toolTipText);
            } else if (key.equals(this.tooltipAtt)) {
                this.toolTipText = (String)value;
                this.setToolTipText(this.toolTipText);
            } else if (key.equals(this.iconAtt)) {
                if (value instanceof String) {
                    this.iconConfig.setValue((String)value);
                    this.setIcon(this.iconConfig.getIconValue());
                }
                this.checkVisibility();
            }
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.toolTipText = text;
        if (this.keyListener.getKeyStroke() != null) {
            Object object = text = text == null ? "" : (String)text + " ";
            if (!this.keyListener.getNamedKeyStroke().isNamed()) {
                text = (String)text + "[" + NamedHotKeyConfigurer.getString(this.keyListener.getKeyStroke()) + "]";
            }
        }
        super.setToolTipText((String)text);
    }

    public Configurer getNameConfigurer() {
        if (this.nameConfig == null && this.nameAtt != null) {
            this.nameConfig = new StringConfigurer(this.nameAtt, Resources.getString("Editor.button_text_label"), this.getText());
        }
        return this.nameConfig;
    }

    public Configurer getHotkeyConfigurer() {
        if (this.keyConfig == null && this.keyAtt != null) {
            this.keyConfig = new NamedHotKeyConfigurer(this.keyAtt, Resources.getString("Editor.hotkey_label"), this.keyListener.getNamedKeyStroke());
        }
        return this.keyConfig;
    }

    public boolean isNonBlank() {
        return this.getText() != null && this.getText().length() > 0 || this.getIcon() != null;
    }

    public void checkVisibility() {
        this.setVisible((this.isNonBlank() || this.forceVisible) && !this.forceInvisible);
    }

    @Override
    public String getComponentTypeName() {
        return "Launch Button";
    }

    @Override
    public String getComponentName() {
        return "Launch Button";
    }
}

