/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesEncoder {
    private final Properties prop;
    private final String stringValue;

    public PropertiesEncoder(Properties prop) {
        this.prop = prop;
        this.stringValue = this.encode(prop);
    }

    public PropertiesEncoder(String stringValue) throws IOException {
        this.stringValue = stringValue;
        this.prop = this.decode(stringValue);
    }

    private String encode(Properties p) {
        String s;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            p.store(out, null);
            s = new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ErrorDialog.bug(e);
            return "";
        }
        StringTokenizer st = new StringTokenizer(s, "\n\r", false);
        SequenceEncoder se = new SequenceEncoder('|');
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("#")) continue;
            se.append(token);
        }
        return se.getValue();
    }

    private Properties decode(String s) throws IOException {
        Properties p = new Properties();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '|');
        StringBuilder buffer = new StringBuilder();
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            buffer.append('\n');
        }
        p.load(new ByteArrayInputStream(buffer.toString().getBytes(StandardCharsets.UTF_8)));
        return p;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        return this.stringValue;
    }
}

